/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.forge.munitions.autocannon;

import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import rbasamoyai.createbigcannons.munitions.autocannon.AutocannonAmmoType;
import rbasamoyai.createbigcannons.munitions.autocannon.ammo_container.AutocannonAmmoContainerBlockEntity;

public record AutocannonAmmoContainerInterface(AutocannonAmmoContainerBlockEntity be) implements IItemHandler
{
    private static final int AMMO_SLOT = 0;
    private static final int TRACER_SLOT = 1;

    public int getSlots() {
        return 2;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return switch (slot) {
            case 0 -> this.be.getMainAmmoStack();
            case 1 -> this.be.getTracerStack();
            default -> ItemStack.f_41583_;
        };
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        int currentCapacity;
        ItemStack currentStack;
        if (slot != 0 && slot != 1) {
            return stack;
        }
        AutocannonAmmoType ammoType = this.be.getAmmoType();
        if (!ammoType.isValidMunition(stack)) {
            return stack;
        }
        boolean ammoSlot = slot == 0;
        ItemStack itemStack = currentStack = ammoSlot ? this.be.getMainAmmoStack() : this.be.getTracerStack();
        if (!currentStack.m_41619_() && !ItemStack.m_150942_((ItemStack)stack, (ItemStack)currentStack)) {
            return stack;
        }
        if (ammoType == AutocannonAmmoType.NONE) {
            currentCapacity = AutocannonAmmoType.of(stack).getCapacity();
        } else {
            currentCapacity = ammoSlot ? this.be.getMainAmmoCapacity() : this.be.getTracerAmmoCapacity();
            currentCapacity -= currentStack.m_41613_();
        }
        int canAdd = Math.min(currentCapacity, stack.m_41613_());
        if (canAdd < 1) {
            return stack;
        }
        if (!simulate) {
            if (currentStack.m_41619_()) {
                ItemStack copy = stack.m_41777_();
                copy.m_41764_(canAdd);
                this.be.m_6836_(slot, copy);
            } else {
                currentStack.m_41769_(canAdd);
            }
            this.be.m_6596_();
        }
        ItemStack ret = stack.m_41777_();
        ret.m_41774_(canAdd);
        return ret;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack currentStack;
        if (slot != 0 && slot != 1) {
            return ItemStack.f_41583_;
        }
        boolean ammoSlot = slot == 0;
        ItemStack itemStack = currentStack = ammoSlot ? this.be.getMainAmmoStack() : this.be.getTracerStack();
        if (currentStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int maxRemove = Math.min(currentStack.m_41613_(), amount);
        if (maxRemove < 1) {
            return ItemStack.f_41583_;
        }
        ItemStack ret = currentStack.m_41777_();
        ret.m_41764_(maxRemove);
        if (!simulate) {
            currentStack.m_41774_(maxRemove);
            if (currentStack.m_41619_()) {
                this.be.m_6836_(slot, ItemStack.f_41583_);
            }
            this.be.m_6596_();
        }
        return ret;
    }

    public int getSlotLimit(int slot) {
        if (slot != 0 && slot != 1) {
            return 0;
        }
        return slot == 0 ? this.be.getMainAmmoCapacity() : this.be.getTracerAmmoCapacity();
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.be.getAmmoType().isValidMunition(stack);
    }
}

