/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.block_hit_effects;

import com.simibubi.create.AllFluids;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.block_hit_effects.ProjectileHitEffect;
import rbasamoyai.createbigcannons.effects.particles.impacts.DebrisMatterParticleData;
import rbasamoyai.createbigcannons.effects.particles.impacts.DebrisSmokeBurstParticleData;
import rbasamoyai.createbigcannons.effects.particles.splashes.ProjectileSplashParticleData;
import rbasamoyai.createbigcannons.index.CBCFluids;
import rbasamoyai.createbigcannons.index.CBCSoundEvents;

public class BackupBlockHitEffects {
    public static void backupSolidEffect(Level level, BlockState blockState, boolean deflect, boolean forceDisplay, double x, double y, double z, double dx, double dy, double dz, ProjectileHitEffect projectileEffect) {
        SoundType type = blockState.m_60827_();
        level.m_6493_((ParticleOptions)new DebrisMatterParticleData(deflect, forceDisplay, blockState), forceDisplay, x, y, z, dx, dy, dz);
        if (deflect) {
            level.m_7785_(x, y, z, type.m_56775_(), SoundSource.BLOCKS, 2.0f, type.m_56774_(), false);
        } else if (projectileEffect.effectMultiplier() >= 1.0f) {
            level.m_6493_((ParticleOptions)new DebrisSmokeBurstParticleData(), forceDisplay, x, y, z, dx, dy, dz);
            CBCSoundEvents.PROJECTILE_IMPACT.playAt(level, x, y, z, 3.0f, 1.0f + level.f_46441_.m_188501_() * 0.4f, false);
        }
    }

    public static void backupFluidEffect(Level level, BlockState blockState, boolean deflect, boolean forceDisplay, double x, double y, double z, double dx, double dy, double dz, ProjectileHitEffect projectileEffect) {
        double velScale;
        float light;
        float b;
        float g;
        float r;
        if (dy < Math.sqrt(dx * dx + dy * dy + dz * dz) * 0.15) {
            return;
        }
        Vec3 vel = new Vec3(dx, dy, dz);
        float volume = projectileEffect.volume();
        if (blockState.m_60713_(Blocks.f_49990_)) {
            r = 0.92f;
            g = 0.97f;
            b = 1.0f;
            light = 0.0f;
            velScale = 0.5;
            float pitch = BackupBlockHitEffects.modifyPitch(0.31f, projectileEffect, level.f_46441_.m_188501_() * 0.3f);
            CBCSoundEvents.PROJECTILE_SPLASH.playAt(level, x, y, z, volume, pitch, false);
        } else if (blockState.m_60713_(Blocks.f_49991_)) {
            r = 1.0f;
            g = 0.35f;
            b = 0.05f;
            light = 1.0f;
            velScale = 0.35;
            float pitch = BackupBlockHitEffects.modifyPitch(0.5f, projectileEffect, level.f_46441_.m_188501_() * 0.3f);
            CBCSoundEvents.HOT_PROJECTILE_SPLASH.playAt(level, x, y, z, volume, pitch, false);
        } else if (BackupBlockHitEffects.isFluid(blockState, (Fluid)AllFluids.HONEY.get())) {
            r = 0.95f;
            g = 0.67f;
            b = 0.07f;
            light = 0.0f;
            velScale = 0.2;
            float pitch = BackupBlockHitEffects.modifyPitch(0.0f, projectileEffect, level.f_46441_.m_188501_() * 0.3f);
            CBCSoundEvents.PROJECTILE_SPLASH.playAt(level, x, y, z, volume, pitch, false);
        } else if (BackupBlockHitEffects.isFluid(blockState, (Fluid)AllFluids.CHOCOLATE.get())) {
            r = 0.56f;
            g = 0.25f;
            b = 0.21f;
            light = 0.0f;
            velScale = 0.4;
            float pitch = BackupBlockHitEffects.modifyPitch(0.31f, projectileEffect, level.f_46441_.m_188501_() * 0.3f);
            CBCSoundEvents.PROJECTILE_SPLASH.playAt(level, x, y, z, volume, pitch, false);
        } else if (BackupBlockHitEffects.isFluid(blockState, (Fluid)CBCFluids.MOLTEN_CAST_IRON.get())) {
            r = 0.84f;
            g = 0.43f;
            b = 0.24f;
            light = 0.25f;
            velScale = 0.2;
            float pitch = BackupBlockHitEffects.modifyPitch(0.5f, projectileEffect, level.f_46441_.m_188501_() * 0.3f);
            CBCSoundEvents.HOT_PROJECTILE_SPLASH.playAt(level, x, y, z, volume, pitch, false);
        } else if (BackupBlockHitEffects.isFluid(blockState, (Fluid)CBCFluids.MOLTEN_BRONZE.get())) {
            r = 0.78f;
            g = 0.51f;
            b = 0.31f;
            light = 0.25f;
            velScale = 0.2;
            float pitch = BackupBlockHitEffects.modifyPitch(0.5f, projectileEffect, level.f_46441_.m_188501_() * 0.3f);
            CBCSoundEvents.HOT_PROJECTILE_SPLASH.playAt(level, x, y, z, volume, pitch, false);
        } else if (BackupBlockHitEffects.isFluid(blockState, (Fluid)CBCFluids.MOLTEN_STEEL.get())) {
            r = 0.42f;
            g = 0.43f;
            b = 0.4f;
            light = 0.25f;
            velScale = 0.2;
            float pitch = BackupBlockHitEffects.modifyPitch(0.5f, projectileEffect, level.f_46441_.m_188501_() * 0.3f);
            CBCSoundEvents.HOT_PROJECTILE_SPLASH.playAt(level, x, y, z, volume, pitch, false);
        } else if (BackupBlockHitEffects.isFluid(blockState, (Fluid)CBCFluids.MOLTEN_NETHERSTEEL.get())) {
            r = 0.51f;
            g = 0.37f;
            b = 0.36f;
            light = 0.25f;
            velScale = 0.2;
            float pitch = BackupBlockHitEffects.modifyPitch(0.5f, projectileEffect, level.f_46441_.m_188501_() * 0.3f);
            CBCSoundEvents.HOT_PROJECTILE_SPLASH.playAt(level, x, y, z, volume, pitch, false);
        } else {
            return;
        }
        level.m_6493_((ParticleOptions)new ProjectileSplashParticleData(r, g, b, light), true, x, y, z, dx * velScale * 0.5, dy * velScale, dz * velScale * 0.5);
    }

    private static float modifyPitch(float base, ProjectileHitEffect effect, float modifier) {
        float f = Mth.m_14036_((float)effect.getPitch(base), (float)0.0f, (float)2.0f);
        return Mth.m_14036_((float)(f + modifier), (float)0.0f, (float)2.0f);
    }

    private static boolean isFluid(BlockState state, Fluid fluid) {
        return state.m_60819_().m_76152_().m_6212_(fluid);
    }

    private BackupBlockHitEffects() {
    }
}

