/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.block_armor_properties;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import rbasamoyai.createbigcannons.block_armor_properties.BlockArmorPropertiesProvider;

public record SimpleBlockArmorProperties(double hardness, double toughness) implements BlockArmorPropertiesProvider
{
    @Override
    public double hardness(Level level, BlockState state, BlockPos pos, boolean recurse) {
        return this.hardness;
    }

    @Override
    public double toughness(Level level, BlockState state, BlockPos pos, boolean recurse) {
        return this.toughness;
    }

    @Override
    public List<BlockState> containedBlockStates(Level level, BlockState state, BlockPos pos, boolean recurse) {
        return List.of(state);
    }

    public static SimpleBlockArmorProperties fromJson(JsonObject obj) {
        double hardness = Math.max(GsonHelper.m_144742_((JsonObject)obj, (String)"hardness", (double)1.0), 0.0);
        double toughness = Math.max(GsonHelper.m_144742_((JsonObject)obj, (String)"toughness", (double)1.0), 0.0);
        return new SimpleBlockArmorProperties(hardness, toughness);
    }

    public void toNetwork(FriendlyByteBuf buf) {
        buf.writeDouble(this.hardness).writeDouble(this.toughness);
    }

    public static SimpleBlockArmorProperties fromNetwork(FriendlyByteBuf buf) {
        double hardness = buf.readDouble();
        double toughness = buf.readDouble();
        return new SimpleBlockArmorProperties(hardness, toughness);
    }
}

