/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.base.goggles;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.equipment.goggles.GogglesItem;
import com.simibubi.create.foundation.gui.RemovedGuiUtils;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CClient;
import java.util.ArrayList;
import net.createmod.catnip.gui.element.BoxElement;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import rbasamoyai.createbigcannons.base.goggles.IDisplayEntityAssemblyExceptions;
import rbasamoyai.createbigcannons.base.goggles.IHaveEntityGoggleInformation;
import rbasamoyai.createbigcannons.base.goggles.IHaveEntityHoverInformation;

public class EntityGoggleOverlayRenderer {
    public static int hoverTicks = 0;

    public static void renderOverlay(GuiGraphics graphics, float partialTicks, int windowWidth, int windowHeight) {
        Color colorBorderBot;
        IDisplayEntityAssemblyExceptions deae;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_ || mc.f_91072_.m_105295_() == GameType.SPECTATOR) {
            return;
        }
        HitResult objectMouseOver = mc.f_91077_;
        if (!(objectMouseOver instanceof EntityHitResult)) {
            hoverTicks = 0;
            return;
        }
        EntityHitResult result = (EntityHitResult)objectMouseOver;
        ++hoverTicks;
        Entity entity = result.m_82443_();
        boolean wearingGoggles = GogglesItem.isWearingGoggles((Player)mc.f_91074_);
        boolean shiftKey = mc.f_91074_.m_6144_();
        boolean hasGoggleInformation = entity instanceof IHaveEntityGoggleInformation;
        boolean hasHoveringInformation = entity instanceof IHaveEntityHoverInformation;
        boolean goggleAddedInformation = false;
        boolean hoverAddedInformation = false;
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (hasGoggleInformation && wearingGoggles) {
            goggleAddedInformation = ((IHaveEntityGoggleInformation)entity).addToGoggleTooltip(tooltip, shiftKey);
        }
        if (hasHoveringInformation) {
            if (!tooltip.isEmpty()) {
                tooltip.add((Component)Component.m_237119_());
            }
            hoverAddedInformation = ((IHaveEntityHoverInformation)entity).addToTooltip(tooltip, shiftKey);
            if (goggleAddedInformation && !hoverAddedInformation) {
                tooltip.remove(tooltip.size() - 1);
            }
        }
        if (entity instanceof IDisplayEntityAssemblyExceptions && (deae = (IDisplayEntityAssemblyExceptions)entity).addExceptionToTooltip(tooltip)) {
            hasHoveringInformation = true;
            hoverAddedInformation = true;
        }
        if (tooltip.isEmpty() || hasGoggleInformation && !goggleAddedInformation && hasHoveringInformation && !hoverAddedInformation) {
            hoverTicks = 0;
            return;
        }
        graphics.m_280168_().m_85836_();
        int tooltipTextWidth = 0;
        for (FormattedText formattedText : tooltip) {
            int textLineWidth = mc.f_91062_.m_92852_(formattedText);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        int tooltipHeight = 8;
        if (tooltip.size() > 1) {
            tooltipHeight += 2;
            tooltipHeight += (tooltip.size() - 1) * 10;
        }
        CClient cClient = AllConfigs.client();
        int posX = windowWidth / 2 + (Integer)cClient.overlayOffsetX.get();
        int posY = windowHeight / 2 + (Integer)cClient.overlayOffsetY.get();
        posX = Math.min(posX, windowWidth - tooltipTextWidth - 20);
        posY = Math.min(posY, windowHeight - tooltipHeight - 20);
        float fade = Mth.m_14036_((float)(((float)hoverTicks + partialTicks) / 24.0f), (float)0.0f, (float)1.0f);
        Boolean useCustom = (Boolean)cClient.overlayCustomColor.get();
        Color colorBackground = useCustom != false ? new Color(((Integer)cClient.overlayBackgroundColor.get()).intValue()) : BoxElement.COLOR_VANILLA_BACKGROUND.scaleAlpha(0.75f);
        Color colorBorderTop = useCustom != false ? new Color(((Integer)cClient.overlayBorderColorTop.get()).intValue()) : ((Color)BoxElement.COLOR_VANILLA_BORDER.getFirst()).copy();
        Color color = colorBorderBot = useCustom != false ? new Color(((Integer)cClient.overlayBorderColorBot.get()).intValue()) : ((Color)BoxElement.COLOR_VANILLA_BORDER.getSecond()).copy();
        if (fade < 1.0f) {
            graphics.m_280168_().m_85837_(Math.pow(1.0f - fade, 3.0) * (double)Math.signum((float)((Integer)cClient.overlayOffsetX.get()).intValue() + 0.5f) * 8.0, 0.0, 0.0);
            colorBackground.scaleAlpha(fade);
            colorBorderTop.scaleAlpha(fade);
            colorBorderBot.scaleAlpha(fade);
        }
        RemovedGuiUtils.drawHoveringText((GuiGraphics)graphics, tooltip, (int)posX, (int)posY, (int)windowWidth, (int)windowHeight, (int)-1, (int)colorBackground.getRGB(), (int)colorBorderTop.getRGB(), (int)colorBorderBot.getRGB(), (Font)mc.f_91062_);
        ItemStack item = AllItems.GOGGLES.asStack();
        GuiGameElement.of((ItemStack)item).at((float)(posX + 10), (float)(posY - 16), 450.0f).render(graphics);
        graphics.m_280168_().m_85849_();
    }
}

