/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.data.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.utility.FilesHelper;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import java.util.Map;
import java.util.function.BiConsumer;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.PackOutput;
import net.minecraftforge.data.event.GatherDataEvent;
import org.forsteri.ratatouille.Ratatouille;
import org.forsteri.ratatouille.data.recipe.ProcessingRecipeGen;
import org.forsteri.ratatouille.entry.CRPonderPlugin;

public class RatatouilleDataGen {
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        Ratatouille.REGISTRATE.addDataGenerator(ProviderType.LANG, provider -> {
            BiConsumer<String, String> langConsumer = (arg_0, arg_1) -> ((RegistrateLangProvider)provider).add(arg_0, arg_1);
            RatatouilleDataGen.provideDefaultLang("en_us", langConsumer);
            RatatouilleDataGen.providePonderLang(langConsumer);
        });
        if (event.includeServer()) {
            ProcessingRecipeGen.registerAll(generator, output);
        }
    }

    private static void provideDefaultLang(String fileName, BiConsumer<String, String> consumer) {
        String path = "assets/ratatouille/lang/default/" + fileName + ".json";
        JsonElement jsonElement = FilesHelper.loadJsonResource((String)path);
        if (jsonElement == null) {
            throw new IllegalStateException(String.format("Could not find default lang file: %s", path));
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            String value = ((JsonElement)entry.getValue()).getAsString();
            consumer.accept(key, value);
        }
    }

    private static void providePonderLang(BiConsumer<String, String> consumer) {
        PonderIndex.addPlugin((PonderPlugin)new CRPonderPlugin());
        PonderIndex.getLangAccess().provideLang("ratatouille", consumer);
    }
}

