/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.thresher;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.Optional;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.forsteri.ratatouille.content.thresher.ThresherBlock;
import org.forsteri.ratatouille.content.thresher.ThresherBlockEntity;
import org.forsteri.ratatouille.content.thresher.ThreshingRecipe;
import org.forsteri.ratatouille.entry.CRPartialModels;
import org.forsteri.ratatouille.entry.CRRecipeTypes;

public class ThresherRenderer
extends KineticBlockEntityRenderer<ThresherBlockEntity> {
    public ThresherRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected SuperByteBuffer getRotatedModel(ThresherBlockEntity be, BlockState state) {
        return CachedBuffers.partialFacingVertical((PartialModel)CRPartialModels.THRESHER_BLADE, (BlockState)state, (Direction)((Direction)state.m_61143_(ThresherBlock.HORIZONTAL_FACING)));
    }

    protected void renderSafe(ThresherBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        this.renderItems(be, partialTicks, ms, buffer, light, overlay);
    }

    protected void renderItems(ThresherBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandlerModifiable)be.inputInv);
        if (be.lastRecipe == null || !be.lastRecipe.matches(inventoryIn, be.m_58904_())) {
            Optional recipe = CRRecipeTypes.THRESHING.find(inventoryIn, be.m_58904_());
            if (recipe.isEmpty()) {
                return;
            }
            be.lastRecipe = (ThreshingRecipe)((Object)recipe.get());
        }
        if (be.lastRecipe != null) {
            for (int slot = 0; slot < be.inputInv.getSlots(); ++slot) {
                ItemStack stack = be.inputInv.getStackInSlot(slot);
                int duration = be.lastRecipe.getProcessingDuration();
                int timer = Mth.m_14045_((int)be.timer, (int)0, (int)duration);
                float processPercent = (float)(duration - timer) / (float)duration * 0.5f;
                if (stack.m_41619_()) continue;
                ms.m_85836_();
                ItemStack resultStack = be.lastRecipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_);
                Direction ejectDirection = be.getEjectDirection();
                ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
                ms.m_85841_(0.5f, 0.5f, 0.5f);
                float deltaY = 0.5f - processPercent * 0.6f;
                float deltaM = -processPercent * 1.5f + 0.5f;
                switch (ejectDirection) {
                    case NORTH: {
                        ms.m_252880_(1.0f, deltaY, deltaM);
                        ms.m_252781_(Axis.f_252529_.m_252977_(66.0f));
                        break;
                    }
                    case SOUTH: {
                        ms.m_252880_(1.0f, deltaY, 2.0f - deltaM);
                        ms.m_252781_(Axis.f_252495_.m_252977_(66.0f));
                        break;
                    }
                    case WEST: {
                        ms.m_252880_(deltaM, deltaY, 1.0f);
                        ms.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                        ms.m_252781_(Axis.f_252529_.m_252977_(66.0f));
                        break;
                    }
                    case EAST: {
                        ms.m_252880_(2.0f - deltaM, deltaY, 1.0f);
                        ms.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
                        ms.m_252781_(Axis.f_252529_.m_252977_(66.0f));
                    }
                }
                itemRenderer.m_269128_(resultStack, ItemDisplayContext.FIXED, light, overlay, ms, buffer, be.m_58904_(), 0);
                ms.m_85849_();
                break;
            }
        }
    }
}

