/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.thresher;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.logistics.funnel.FunnelBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.forsteri.ratatouille.content.thresher.ThreshingRecipe;
import org.forsteri.ratatouille.entry.CRRecipeTypes;

public class ThresherBlockEntity
extends KineticBlockEntity {
    public ItemStackHandler inputInv = new ItemStackHandler(1);
    public ItemStackHandler outputInv = new ItemStackHandler(4);
    public LazyOptional<IItemHandler> capability = LazyOptional.of(() -> new ThresherInventoryHandler());
    public int timer;
    public ThreshingRecipe lastRecipe;

    public ThresherBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this));
        super.addBehaviours(behaviours);
    }

    public void tick() {
        super.tick();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.canOutput()) {
            Direction direction = this.getEjectDirection();
            for (int slot = 0; slot < this.outputInv.getSlots(); ++slot) {
                IItemHandler targetInv;
                ItemStack stack = this.outputInv.getStackInSlot(slot);
                if (stack.m_41619_()) continue;
                BlockEntity be = this.f_58857_.m_7702_(this.f_58858_.m_7495_().m_121945_(direction));
                InvManipulationBehaviour inserter = null;
                if (be != null) {
                    inserter = (InvManipulationBehaviour)BlockEntityBehaviour.get((BlockGetter)this.f_58857_, (BlockPos)be.m_58899_(), (BehaviourType)InvManipulationBehaviour.TYPE);
                }
                IItemHandler iItemHandler = be == null ? null : (targetInv = (IItemHandler)be.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_()).orElse(inserter == null ? null : (IItemHandler)inserter.getInventory()));
                if (targetInv == null || !ItemHandlerHelper.insertItemStacked(targetInv, (ItemStack)stack, (boolean)true).m_41619_()) continue;
                ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)stack.m_41777_(), (boolean)false);
                this.outputInv.setStackInSlot(slot, ItemStack.f_41583_);
                this.notifyUpdate();
            }
        } else if (this.f_58857_.m_8055_(this.m_58899_().m_121945_(this.getEjectDirection())).m_60734_() instanceof AirBlock) {
            for (int slot = 0; slot < this.outputInv.getSlots(); ++slot) {
                ItemStack stack = this.outputInv.getStackInSlot(slot);
                if (stack.m_41619_()) continue;
                Vec3 neighbour = VecHelper.getCenterOf((Vec3i)this.m_58899_().m_121945_(this.getEjectDirection()));
                ItemEntity itementity = new ItemEntity(this.f_58857_, neighbour.f_82479_, (double)((float)Mth.m_14107_((double)neighbour.f_82480_) + 0.0625f), neighbour.f_82481_, stack.m_41620_(this.f_58857_.f_46441_.m_188503_(21) + 10));
                itementity.m_20256_(Vec3.f_82478_);
                this.f_58857_.m_7967_((Entity)itementity);
                this.outputInv.setStackInSlot(slot, ItemStack.f_41583_);
                this.notifyUpdate();
            }
        }
        for (int i = 0; i < this.outputInv.getSlots(); ++i) {
            if (this.outputInv.getStackInSlot(i).m_41613_() != this.outputInv.getSlotLimit(i)) continue;
            return;
        }
        if (this.timer > 0) {
            this.timer -= this.getProcessingSpeed();
            if (this.f_58857_.f_46443_) {
                this.spawnParticles();
                return;
            }
            if (this.timer <= 0) {
                this.process();
            }
            return;
        }
        if (this.inputInv.getStackInSlot(0).m_41619_()) {
            return;
        }
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandlerModifiable)this.inputInv);
        if (this.lastRecipe == null || !this.lastRecipe.matches(inventoryIn, this.f_58857_)) {
            Optional recipe = CRRecipeTypes.THRESHING.find(inventoryIn, this.f_58857_);
            if (recipe.isEmpty()) {
                this.timer = 100;
            } else {
                this.lastRecipe = (ThreshingRecipe)((Object)recipe.get());
                this.timer = this.lastRecipe.getProcessingDuration();
            }
        } else {
            this.timer = this.lastRecipe.getProcessingDuration();
        }
        this.notifyUpdate();
    }

    public Direction getEjectDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
    }

    public void invalidate() {
        super.invalidate();
        this.capability.invalidate();
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.inputInv);
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.outputInv);
    }

    private void process() {
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandlerModifiable)this.inputInv);
        if (this.lastRecipe == null || !this.lastRecipe.matches(inventoryIn, this.f_58857_)) {
            Optional recipe = CRRecipeTypes.THRESHING.find(inventoryIn, this.f_58857_);
            if (recipe.isEmpty()) {
                return;
            }
            this.lastRecipe = (ThreshingRecipe)((Object)recipe.get());
        }
        ItemStack stackInSlot = this.inputInv.getStackInSlot(0);
        stackInSlot.m_41774_(1);
        this.inputInv.setStackInSlot(0, stackInSlot);
        this.lastRecipe.rollResults().forEach(stack -> ItemHandlerHelper.insertItemStacked((IItemHandler)this.outputInv, (ItemStack)stack, (boolean)false));
        this.notifyUpdate();
    }

    public void spawnParticles() {
        ItemStack stackInSlot = this.inputInv.getStackInSlot(0);
        if (stackInSlot.m_41619_()) {
            return;
        }
        ItemParticleOption data = new ItemParticleOption(ParticleTypes.f_123752_, stackInSlot);
        float angle = this.f_58857_.f_46441_.m_188501_() * 360.0f;
        Vec3 offset = new Vec3(0.0, 0.0, 0.5);
        offset = VecHelper.rotate((Vec3)offset, (double)angle, (Direction.Axis)Direction.Axis.Y);
        Vec3 target = VecHelper.rotate((Vec3)offset, (double)(this.getSpeed() > 0.0f ? 25.0 : -25.0), (Direction.Axis)Direction.Axis.Y);
        Vec3 center = offset.m_82549_(VecHelper.getCenterOf((Vec3i)this.f_58858_));
        target = VecHelper.offsetRandomly((Vec3)target.m_82546_(offset), (RandomSource)this.f_58857_.f_46441_, (float)0.0078125f);
        this.f_58857_.m_7106_((ParticleOptions)data, center.f_82479_, center.f_82480_, center.f_82481_, target.f_82479_, target.f_82480_, target.f_82481_);
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("Timer", this.timer);
        compound.m_128365_("InputInventory", (Tag)this.inputInv.serializeNBT());
        compound.m_128365_("OutputInventory", (Tag)this.outputInv.serializeNBT());
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.timer = compound.m_128451_("Timer");
        this.inputInv.deserializeNBT(compound.m_128469_("InputInventory"));
        this.outputInv.deserializeNBT(compound.m_128469_("OutputInventory"));
        super.read(compound, clientPacket);
    }

    public int getProcessingSpeed() {
        return Mth.m_14045_((int)((int)Math.abs(this.getSpeed() / 16.0f)), (int)1, (int)512);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.isItemHandlerCap(cap)) {
            return this.capability.cast();
        }
        return super.getCapability(cap, side);
    }

    private boolean canProcess(ItemStack stack) {
        ItemStackHandler tester = new ItemStackHandler(1);
        tester.setStackInSlot(0, stack);
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandlerModifiable)tester);
        if (this.lastRecipe != null && this.lastRecipe.matches(inventoryIn, this.f_58857_)) {
            return true;
        }
        return CRRecipeTypes.THRESHING.find(inventoryIn, this.f_58857_).isPresent();
    }

    private boolean canOutput() {
        DirectBeltInputBehaviour directBeltInputBehaviour;
        Direction direction = this.getEjectDirection();
        BlockPos neighbour = this.m_58899_().m_121945_(direction);
        BlockPos output = neighbour.m_7495_();
        BlockState blockState = this.f_58857_.m_8055_(neighbour);
        if (FunnelBlock.isFunnel((BlockState)blockState)) {
            if (FunnelBlock.getFunnelFacing((BlockState)blockState) == direction) {
                return false;
            }
        } else {
            if (!blockState.m_60812_((BlockGetter)this.f_58857_, neighbour).m_83281_()) {
                return false;
            }
            BlockEntity blockEntity = this.f_58857_.m_7702_(output);
            if (blockEntity instanceof BeltBlockEntity) {
                BeltBlockEntity belt = (BeltBlockEntity)blockEntity;
                return belt.getSpeed() == 0.0f || belt.getMovementFacing() != direction.m_122424_();
            }
        }
        return (directBeltInputBehaviour = (DirectBeltInputBehaviour)BlockEntityBehaviour.get((BlockGetter)this.f_58857_, (BlockPos)output, (BehaviourType)DirectBeltInputBehaviour.TYPE)) != null ? directBeltInputBehaviour.canInsertFromSide(direction) : false;
    }

    public float calculateStressApplied() {
        return 4.0f;
    }

    private class ThresherInventoryHandler
    extends CombinedInvWrapper {
        public ThresherInventoryHandler() {
            super(new IItemHandlerModifiable[]{ThresherBlockEntity.this.inputInv, ThresherBlockEntity.this.outputInv});
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (ThresherBlockEntity.this.outputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return false;
            }
            return ThresherBlockEntity.this.canProcess(stack) && super.isItemValid(slot, stack);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (ThresherBlockEntity.this.outputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return stack;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (ThresherBlockEntity.this.inputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return ItemStack.f_41583_;
            }
            return super.extractItem(slot, amount, simulate);
        }
    }
}

