/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.squeeze_basin;

import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.forsteri.ratatouille.content.squeeze_basin.SqueezeBasinBlock;
import org.forsteri.ratatouille.content.squeeze_basin.SqueezeBasinBlockEntity;
import org.forsteri.ratatouille.content.squeeze_basin.SqueezeBasinInventory;
import org.forsteri.ratatouille.entry.CRItems;
import org.forsteri.ratatouille.entry.CRRecipeTypes;
import org.jetbrains.annotations.NotNull;

public class SqueezingRecipe
extends ProcessingRecipe<SqueezeBasinInventory> {
    public SqueezingRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super((IRecipeTypeInfo)CRRecipeTypes.SQUEEZING, params);
    }

    protected int getMaxInputCount() {
        return 2;
    }

    protected int getMaxOutputCount() {
        return 1;
    }

    protected int getMaxFluidInputCount() {
        return 1;
    }

    public boolean matches(@NotNull SqueezeBasinInventory smartInventory, @NotNull Level level) {
        if (!this.fluidIngredients.isEmpty()) {
            if (smartInventory.blockEntity == null) {
                return false;
            }
            IFluidHandler fluidHandler = (IFluidHandler)smartInventory.blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
            if (fluidHandler == null) {
                return false;
            }
            boolean result = false;
            for (FluidIngredient ingredient : this.fluidIngredients) {
                if (!ingredient.test(fluidHandler.getFluidInTank(0))) continue;
                result = true;
                break;
            }
            if (!result) {
                return false;
            }
        }
        boolean useCasing = this.useCasing();
        for (Ingredient ingredient : this.ingredients) {
            if (ingredient.test(CRItems.SAUSAGE_CASING.asStack())) {
                if (smartInventory.blockEntity == null) {
                    return false;
                }
                if (((Boolean)smartInventory.blockEntity.m_58900_().m_61143_((Property)SqueezeBasinBlock.CASING)).booleanValue()) continue;
                return false;
            }
            if (!ingredient.test(smartInventory.m_8020_(0))) continue;
            return true;
        }
        return useCasing && this.ingredients.size() == 1;
    }

    public boolean useCasing() {
        for (Ingredient ingredient : this.ingredients) {
            if (!ingredient.test(CRItems.SAUSAGE_CASING.asStack())) continue;
            return true;
        }
        return false;
    }

    public boolean match(@NotNull SqueezeBasinBlockEntity be, boolean hasCasing) {
        if (be.getOperator().isEmpty()) {
            return false;
        }
        IFluidHandler inputTank = (IFluidHandler)be.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
        if (be.inputInventory == null || inputTank == null) {
            return false;
        }
        boolean useCasing = this.useCasing();
        if (useCasing != hasCasing) {
            return false;
        }
        if (useCasing && this.ingredients.size() == 1) {
            if (this.fluidIngredients.isEmpty()) {
                return true;
            }
            return ((FluidIngredient)this.fluidIngredients.get(0)).test(inputTank.getFluidInTank(0));
        }
        for (Ingredient ingredient : this.ingredients) {
            if (!ingredient.test(be.inputInventory.m_8020_(0))) continue;
            if (this.fluidIngredients.isEmpty()) {
                return true;
            }
            return ((FluidIngredient)this.fluidIngredients.get(0)).test(inputTank.getFluidInTank(0));
        }
        return false;
    }
}

