/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.spreader;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.foundation.particle.ICustomParticleDataWithSprite;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.forsteri.ratatouille.content.spreader.SpreaderParticle;
import org.forsteri.ratatouille.entry.CRParticleTypes;
import org.jetbrains.annotations.NotNull;

public class SpreaderParticleData
implements ParticleOptions,
ICustomParticleDataWithSprite<SpreaderParticleData> {
    public static final Codec<SpreaderParticleData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.fieldOf("color").forGetter(p -> p.color)).apply((Applicative)i, SpreaderParticleData::new));
    public static final ParticleOptions.Deserializer<SpreaderParticleData> DESERIALIZER = new ParticleOptions.Deserializer<SpreaderParticleData>(){

        @NotNull
        public SpreaderParticleData fromCommand(@NotNull ParticleType<SpreaderParticleData> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int color = reader.readInt();
            return new SpreaderParticleData(color);
        }

        @NotNull
        public SpreaderParticleData fromNetwork(@NotNull ParticleType<SpreaderParticleData> type, FriendlyByteBuf buffer) {
            int color = buffer.readInt();
            return new SpreaderParticleData(color);
        }
    };
    public final int color;

    public SpreaderParticleData() {
        this(0xFFFFFF);
    }

    public SpreaderParticleData(int color) {
        this.color = color;
    }

    public Codec<SpreaderParticleData> getCodec(ParticleType<SpreaderParticleData> type) {
        return CODEC;
    }

    @NotNull
    public ParticleOptions.Deserializer<SpreaderParticleData> getDeserializer() {
        return DESERIALIZER;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ParticleEngine.SpriteParticleRegistration<SpreaderParticleData> getMetaFactory() {
        return SpreaderParticle.Factory::new;
    }

    @NotNull
    public ParticleType<?> m_6012_() {
        return CRParticleTypes.SPREADER.get();
    }

    public void m_7711_(@NotNull FriendlyByteBuf buffer) {
        buffer.writeInt(this.color);
    }

    @NotNull
    public String m_5942_() {
        return String.format("%s %d", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), this.color);
    }
}

