/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.oven;

import com.simibubi.create.content.fluids.tank.BoilerHeaters;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import java.util.List;
import joptsimple.internal.Strings;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.forsteri.ratatouille.content.oven.OvenBlockEntity;
import org.forsteri.ratatouille.content.oven_fan.OvenFanBlock;
import org.forsteri.ratatouille.content.oven_fan.OvenFanBlockEntity;
import org.forsteri.ratatouille.util.Lang;
import org.jetbrains.annotations.NotNull;

public class BakeData {
    public int fanLevel;
    public int sizeLevel;
    public int tempLevel;
    public int updateRequired;

    public void tick(OvenBlockEntity oven) {
        if (this.updateOven(oven)) {
            oven.notifyUpdate();
        }
        this.processFood(oven);
    }

    public boolean updateOven(OvenBlockEntity controller) {
        assert (controller.m_58904_() != null);
        BlockPos controllerPos = controller.m_58899_();
        Level level = controller.m_58904_();
        --this.updateRequired;
        int prevTemp = this.tempLevel;
        this.tempLevel = 0;
        for (int xOffset = 0; xOffset < controller.radius; ++xOffset) {
            for (int zOffset = 0; zOffset < controller.radius; ++zOffset) {
                float heat;
                BlockPos pos = controllerPos.m_7918_(xOffset, -1, zOffset);
                BlockState blockState = level.m_8055_(pos);
                if (!(blockState.m_60734_() instanceof BlazeBurnerBlock) && !blockState.m_61138_((Property)BlazeBurnerBlock.HEAT_LEVEL) || !((heat = (float)BoilerHeaters.blazeBurner((Level)level, (BlockPos)pos, (BlockState)blockState)) > 0.0f)) continue;
                this.tempLevel = (int)((float)this.tempLevel + heat);
            }
        }
        int fanLevelBefore = this.fanLevel;
        float newFanLevel = 0.0f;
        for (int i = 0; i < controller.radius; ++i) {
            for (int j = 0; j < controller.height; ++j) {
                for (int k = 0; k < controller.radius; ++k) {
                    for (Direction direction : Direction.values()) {
                        OvenFanBlockEntity fan;
                        BlockPos pos = controller.m_58899_().m_7918_(i, j, k).m_121945_(direction);
                        BlockState state = controller.m_58904_().m_8055_(pos);
                        if (!(state.m_60734_() instanceof OvenFanBlock) || state.m_61143_(OvenFanBlock.HORIZONTAL_FACING) != direction.m_122424_() || (fan = (OvenFanBlockEntity)controller.m_58904_().m_7702_(pos)) == null) continue;
                        if (Mth.m_14154_((float)fan.getSpeed()) == 256.0f) {
                            newFanLevel += 1.0f;
                            continue;
                        }
                        if (!(Mth.m_14154_((float)fan.getSpeed()) >= 128.0f)) continue;
                        newFanLevel += 0.5f;
                    }
                }
            }
        }
        this.fanLevel = (int)newFanLevel;
        this.fanLevel = Mth.m_14045_((int)this.fanLevel, (int)0, (int)8);
        this.tempLevel = Mth.m_14045_((int)this.tempLevel, (int)0, (int)8);
        return this.tempLevel != prevTemp || fanLevelBefore != this.fanLevel;
    }

    public void processFood(OvenBlockEntity oven) {
        List<List<List<OvenBlockEntity.Inventory>>> inventories = oven.inventories;
        if (inventories == null) {
            return;
        }
        for (List<List<OvenBlockEntity.Inventory>> x : inventories) {
            for (List<OvenBlockEntity.Inventory> y : x) {
                for (OvenBlockEntity.Inventory inventory : y) {
                    if (inventory == null || inventory.tickTillFinishCooking < 0) continue;
                    if (inventory.tickTillFinishCooking > 0) {
                        inventory.tickTillFinishCooking -= Math.min(Math.min(this.fanLevel, this.sizeLevel), this.tempLevel);
                    }
                    if (inventory.tickTillFinishCooking > 0 || inventory.lastRecipe == null) continue;
                    ItemStack resultStack = inventory.lastRecipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41777_();
                    resultStack.m_41764_(inventory.getStackInSlot(0).m_41613_());
                    inventory.setStackInSlot(0, resultStack);
                }
            }
        }
        oven.notifyUpdate();
    }

    public boolean evaluate(OvenBlockEntity oven) {
        assert (oven.m_58904_() != null);
        int sizeLevelBefore = this.sizeLevel;
        this.sizeLevel = oven.radius * oven.height * oven.radius / 4;
        this.sizeLevel = Mth.m_14045_((int)this.sizeLevel, (int)0, (int)8);
        return sizeLevelBefore != this.sizeLevel;
    }

    public void clear() {
        this.fanLevel = 0;
        this.sizeLevel = 0;
        this.tempLevel = 0;
    }

    public void read(CompoundTag compound, boolean ignoredClientPacket) {
        this.fanLevel = compound.m_128451_("fanCount");
        this.sizeLevel = compound.m_128451_("sizeCount");
        this.tempLevel = compound.m_128451_("tempCount");
    }

    public void write(CompoundTag compound, boolean ignoredClientPacket) {
        compound.m_128405_("fanCount", this.fanLevel);
        compound.m_128405_("sizeCount", this.sizeLevel);
        compound.m_128405_("tempCount", this.tempLevel);
    }

    public MutableComponent getSizeComponent(boolean forGoggles, boolean useBlocksAsBars, ChatFormatting ... styles) {
        return this.componentHelper("size", this.sizeLevel, forGoggles, useBlocksAsBars, styles);
    }

    public MutableComponent getHeatComponent(boolean forGoggles, boolean useBlocksAsBars, ChatFormatting ... styles) {
        return this.componentHelper("heat", this.tempLevel, forGoggles, useBlocksAsBars, styles);
    }

    public MutableComponent getFanComponent(boolean forGoggles, boolean useBlocksAsBars, ChatFormatting ... styles) {
        return this.componentHelper("fan", this.fanLevel, forGoggles, useBlocksAsBars, styles);
    }

    private MutableComponent componentHelper(String label, int level, boolean forGoggles, boolean useBlocksAsBars, ChatFormatting ... styles) {
        MutableComponent base;
        MutableComponent mutableComponent = base = useBlocksAsBars ? this.blockComponent(level) : this.barComponent(level);
        if (!forGoggles) {
            return base;
        }
        ChatFormatting style1 = styles.length >= 1 ? styles[0] : ChatFormatting.GRAY;
        ChatFormatting style2 = styles.length >= 2 ? styles[1] : ChatFormatting.DARK_GRAY;
        return Lang.translateDirect("oven." + label, new Object[0]).m_130940_(style1).m_7220_((Component)Lang.translateDirect("oven." + label + "_dots", new Object[0]).m_130940_(style2)).m_7220_((Component)base);
    }

    private MutableComponent blockComponent(int level) {
        int clamped = Mth.m_14045_((int)level, (int)0, (int)8);
        return Component.m_237113_((String)("\u2588".repeat(clamped) + "\u2591".repeat(8 - clamped)));
    }

    private MutableComponent barComponent(int level) {
        return Component.m_237119_().m_7220_((Component)this.bars(Math.max(0, -1), ChatFormatting.DARK_GREEN)).m_7220_((Component)this.bars(0, ChatFormatting.GREEN)).m_7220_((Component)this.bars(Math.max(0, level - 0), ChatFormatting.DARK_GREEN)).m_7220_((Component)this.bars(Math.max(0, 8 - level), ChatFormatting.DARK_RED)).m_7220_((Component)this.bars(Math.max(0, Math.min(10, 2)), ChatFormatting.DARK_GRAY));
    }

    private MutableComponent bars(int level, ChatFormatting format) {
        return Component.m_237113_((String)Strings.repeat((char)'|', (int)level)).m_130940_(format);
    }

    @NotNull
    public MutableComponent getLevelComponent() {
        int ovenLevel = Math.min(this.fanLevel, Math.min(this.sizeLevel, this.tempLevel));
        if (ovenLevel == 0) {
            return Lang.translateDirect("oven.idle", new Object[0]);
        }
        return ovenLevel >= 8 ? Lang.translateDirect("oven.max_lvl", new Object[0]) : Lang.translateDirect("oven.lvl", new Object[0]).m_130946_(String.valueOf(ovenLevel));
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean ignoredIsPlayerSneaking, int ovenSize) {
        MutableComponent indent = Component.m_237113_((String)"    ");
        MutableComponent indent2 = Component.m_237113_((String)"     ");
        tooltip.add((Component)indent.m_6881_().m_7220_((Component)Lang.translateDirect("oven.status", new Object[0]).m_7220_((Component)this.getLevelComponent().m_130940_(ChatFormatting.GREEN))));
        tooltip.add((Component)indent2.m_6881_().m_7220_((Component)this.getSizeComponent(true, false, new ChatFormatting[0])));
        tooltip.add((Component)indent2.m_6881_().m_7220_((Component)this.getFanComponent(true, false, new ChatFormatting[0])));
        tooltip.add((Component)indent2.m_6881_().m_7220_((Component)this.getHeatComponent(true, false, new ChatFormatting[0])));
        return true;
    }
}

