/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.block.radar.receiver;

import com.happysg.radar.registry.ModBlocks;
import com.simibubi.create.content.contraptions.bearing.SailBlock;
import com.simibubi.create.foundation.block.WrenchableDirectionalBlock;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.math.VoxelShaper;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class AbstractRadarFrame
extends WrenchableDirectionalBlock {
    public VoxelShaper shaper;
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public AbstractRadarFrame(BlockBehaviour.Properties properties, VoxelShaper shaper) {
        super(properties);
        this.shaper = shaper;
    }

    public boolean isStickyBlock(BlockState state) {
        return true;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return this.shaper.get((Direction)pState.m_61143_((Property)f_52588_));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack heldItem = pPlayer.m_21120_(pHand);
        IPlacementHelper placementHelper = PlacementHelpers.get((int)placementHelperId);
        if (!pPlayer.m_6144_() && pPlayer.m_36326_() && placementHelper.matchesItem(heldItem)) {
            placementHelper.getOffset(pPlayer, pLevel, pState, pPos, pHit).placeInWorld(pLevel, (BlockItem)heldItem.m_41720_(), pPlayer, pHand, pHit);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return i -> ModBlocks.RADAR_PLATE_BLOCK.isIn(i) || ModBlocks.RADAR_DISH_BLOCK.isIn(i);
        }

        public Predicate<BlockState> getStatePredicate() {
            return s -> s.m_60734_() instanceof AbstractRadarFrame;
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            List directions = IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.m_82450_(), (Direction.Axis)((Direction)state.m_61143_((Property)SailBlock.f_52588_)).m_122434_(), dir -> world.m_8055_(pos.m_121945_(dir)).m_247087_());
            if (directions.isEmpty()) {
                return PlacementOffset.fail();
            }
            return PlacementOffset.success((Vec3i)pos.m_121945_((Direction)directions.get(0)), s -> (BlockState)s.m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)((Direction)state.m_61143_((Property)DirectionalBlock.f_52588_))));
        }
    }
}

