/*
 * Decompiled with CFR 0.152.
 */
package net.TakeruDavis.create_cardboarded_conveynience.utils;

import com.google.common.cache.Cache;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.equipment.armor.CardboardArmorHandler;
import com.simibubi.create.content.equipment.armor.CardboardArmorHandlerClient;
import com.simibubi.create.content.logistics.box.PackageRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import net.TakeruDavis.create_cardboarded_conveynience.utils.SkyhookHelper;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class CardboardHelper {
    private static Cache<UUID, Integer> BOXES_PLAYERS_ARE_HIDING_AS;
    private static final Map<EquipmentSlot, ResourceLocation> CARDBOARD_ARMOR;

    private static void initLinked() {
        try {
            Field f = CardboardArmorHandlerClient.class.getDeclaredField("BOXES_PLAYERS_ARE_HIDING_AS");
            f.setAccessible(true);
            BOXES_PLAYERS_ARE_HIDING_AS = (Cache)f.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public static boolean testForArmor(LivingEntity entity) {
        for (Map.Entry<EquipmentSlot, ResourceLocation> entry : CARDBOARD_ARMOR.entrySet()) {
            ItemStack stack = entity.m_6844_(entry.getKey());
            Item expected = (Item)ForgeRegistries.ITEMS.getValue(entry.getValue());
            if (expected != null && expected.equals(stack.m_41720_())) continue;
            return false;
        }
        return true;
    }

    public static Integer getCurrentBoxIndex(Player player) throws ExecutionException {
        if (BOXES_PLAYERS_ARE_HIDING_AS == null) {
            CardboardHelper.initLinked();
        }
        return (Integer)BOXES_PLAYERS_ARE_HIDING_AS.get((Object)player.m_20148_(), () -> player.m_9236_().f_46441_.m_188503_(AllPartialModels.PACKAGES_TO_HIDE_AS.size()));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void playerRendersAsBoxWhenSneaking(RenderPlayerEvent.Pre event) {
        Player player = event.getEntity();
        if (CardboardArmorHandler.testForStealth((Entity)player)) {
            event.setCanceled(true);
            if (player != Minecraft.m_91087_().f_91074_ || Minecraft.m_91087_().f_91066_.m_92176_() != CameraType.FIRST_PERSON) {
                PoseStack ms = event.getPoseStack();
                ms.m_85836_();
                ms.m_252880_(0.0f, 0.125f, 0.0f);
                float movement = (float)player.m_20182_().m_82492_(player.f_19854_, player.f_19855_, player.f_19856_).m_82553_();
                if (player.m_20096_()) {
                    ms.m_252880_(0.0f, Math.min(Math.abs(Mth.m_14089_((float)(AnimationTickHolder.getRenderTime() % 256.0f / 2.0f))) * 2.0f / 16.0f, movement * 5.0f), 0.0f);
                }
                float interpolatedYaw = Mth.m_14179_((float)event.getPartialTick(), (float)player.f_19859_, (float)player.m_146908_());
                try {
                    PartialModel model = (PartialModel)AllPartialModels.PACKAGES_TO_HIDE_AS.get(CardboardHelper.getCurrentBoxIndex(player));
                    if (SkyhookHelper.isPlayerHanging(player)) {
                        ms.m_85837_(0.0, player.m_150110_().f_35935_ ? 0.5 : 0.75, 0.0);
                        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
                        itemRenderer.m_269128_(player.m_21205_(), ItemDisplayContext.FIXED, event.getPackedLight(), OverlayTexture.f_118083_, ms, event.getMultiBufferSource(), player.m_9236_(), 0);
                        ms.m_85837_(0.0, -0.9, 0.0);
                    }
                    PackageRenderer.renderBox((Entity)player, (float)interpolatedYaw, (PoseStack)ms, (MultiBufferSource)event.getMultiBufferSource(), (int)event.getPackedLight(), (PartialModel)model);
                }
                catch (ExecutionException var6) {
                    var6.printStackTrace();
                }
                ms.m_85849_();
            }
        }
    }

    static {
        CARDBOARD_ARMOR = Map.of(EquipmentSlot.HEAD, new ResourceLocation("create", "cardboard_helmet"), EquipmentSlot.CHEST, new ResourceLocation("create", "cardboard_chestplate"), EquipmentSlot.LEGS, new ResourceLocation("create", "cardboard_leggings"), EquipmentSlot.FEET, new ResourceLocation("create", "cardboard_boots"));
    }
}

