/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.item;

import com.google.common.base.Strings;
import com.simibubi.create.foundation.utility.CreateLang;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class TooltipHelper {
    public static final int MAX_WIDTH_PER_LINE = 200;

    public static MutableComponent holdShift(FontHelper.Palette palette, boolean highlighted) {
        return CreateLang.translateDirect("tooltip.holdForDescription", CreateLang.translateDirect("tooltip.keyShift", new Object[0]).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY);
    }

    public static void addHint(List<Component> tooltip, String hintKey, Object ... messageParams) {
        CreateLang.translate(hintKey + ".title", new Object[0]).style(ChatFormatting.GOLD).forGoggles(tooltip);
        MutableComponent hint = CreateLang.translateDirect(hintKey, new Object[0]);
        List<Component> cutComponent = TooltipHelper.cutTextComponent((Component)hint, FontHelper.Palette.GRAY_AND_WHITE);
        for (Component component : cutComponent) {
            CreateLang.builder().add(component).forGoggles(tooltip);
        }
    }

    public static String makeProgressBar(int length, int filledLength) {
        int i;
        Object bar = " ";
        int emptySpaces = length - filledLength;
        for (i = 0; i < filledLength; ++i) {
            bar = (String)bar + "\u2588";
        }
        for (i = 0; i < emptySpaces; ++i) {
            bar = (String)bar + "\u2592";
        }
        return (String)bar + " ";
    }

    public static Style styleFromColor(ChatFormatting color) {
        return Style.f_131099_.m_131157_(color);
    }

    public static Style styleFromColor(int hex) {
        return Style.f_131099_.m_178520_(hex);
    }

    public static List<Component> cutStringTextComponent(String s, FontHelper.Palette palette) {
        return TooltipHelper.cutTextComponent((Component)Component.m_237113_((String)s), palette);
    }

    public static List<Component> cutTextComponent(Component c, FontHelper.Palette palette) {
        return TooltipHelper.cutTextComponent(c, palette.primary(), palette.highlight());
    }

    public static List<Component> cutStringTextComponent(String s, Style primaryStyle, Style highlightStyle) {
        return TooltipHelper.cutTextComponent((Component)Component.m_237113_((String)s), primaryStyle, highlightStyle);
    }

    public static List<Component> cutTextComponent(Component c, Style primaryStyle, Style highlightStyle) {
        return TooltipHelper.cutTextComponent(c, primaryStyle, highlightStyle, 0);
    }

    public static List<Component> cutStringTextComponent(String c, Style primaryStyle, Style highlightStyle, int indent) {
        return TooltipHelper.cutTextComponent((Component)Component.m_237113_((String)c), primaryStyle, highlightStyle, indent);
    }

    public static List<Component> cutTextComponent(Component c, Style primaryStyle, Style highlightStyle, int indent) {
        String s = c.getString();
        LinkedList<String> words = new LinkedList<String>();
        BreakIterator iterator = BreakIterator.getLineInstance(Minecraft.m_91087_().getLocale());
        iterator.setText(s);
        int start = iterator.first();
        int end = iterator.next();
        while (end != -1) {
            String word = s.substring(start, end);
            words.add(word);
            start = end;
            end = iterator.next();
        }
        Font font = Minecraft.m_91087_().f_91062_;
        LinkedList<String> lines = new LinkedList<String>();
        StringBuilder currentLine = new StringBuilder();
        int width = 0;
        for (String word : words) {
            int newWidth = font.m_92895_(word.replaceAll("_", ""));
            if (width + newWidth > 200) {
                if (width > 0) {
                    String line = currentLine.toString();
                    lines.add(line);
                    currentLine = new StringBuilder();
                    width = 0;
                } else {
                    lines.add(word);
                    continue;
                }
            }
            currentLine.append(word);
            width += newWidth;
        }
        if (width > 0) {
            lines.add(currentLine.toString());
        }
        MutableComponent lineStart = Component.m_237113_((String)Strings.repeat((String)" ", (int)indent));
        lineStart.m_130948_(primaryStyle);
        ArrayList<Component> formattedLines = new ArrayList<Component>(lines.size());
        Couple styles = Couple.create((Object)highlightStyle, (Object)primaryStyle);
        boolean currentlyHighlighted = false;
        for (String string : lines) {
            String[] split;
            MutableComponent currentComponent = lineStart.m_6879_();
            for (String part : split = string.split("_", -1)) {
                currentComponent.m_7220_((Component)Component.m_237113_((String)part).m_130948_((Style)styles.get(currentlyHighlighted)));
                currentlyHighlighted = !currentlyHighlighted;
            }
            formattedLines.add((Component)currentComponent);
            currentlyHighlighted = !currentlyHighlighted;
        }
        return formattedLines;
    }
}

