/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.potatoCannon;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.Create;
import com.simibubi.create.api.equipment.potatoCannon.PotatoProjectileEntityHitAction;
import com.simibubi.create.api.registry.CreateBuiltInRegistries;
import com.simibubi.create.foundation.mixin.accessor.SuspiciousStewItemAccessor;
import com.simibubi.create.foundation.utility.CreateCodecs;
import java.util.UUID;
import net.createmod.catnip.data.WorldAttached;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;

public class AllPotatoProjectileEntityHitActions {
    public static void init() {
    }

    private static void register(String name, Codec<? extends PotatoProjectileEntityHitAction> codec) {
        Registry.m_122965_(CreateBuiltInRegistries.POTATO_PROJECTILE_ENTITY_HIT_ACTION, (ResourceLocation)Create.asResource(name), codec);
    }

    private static void applyEffect(LivingEntity entity, MobEffectInstance effect) {
        if (effect.m_19544_().m_8093_()) {
            effect.m_19544_().m_19461_(null, null, entity, effect.m_19557_(), 1.0);
        } else {
            entity.m_7292_(effect);
        }
    }

    static {
        AllPotatoProjectileEntityHitActions.register("set_on_fire", SetOnFire.CODEC);
        AllPotatoProjectileEntityHitActions.register("potion_effect", PotionEffect.CODEC);
        AllPotatoProjectileEntityHitActions.register("food_effects", FoodEffects.CODEC);
        AllPotatoProjectileEntityHitActions.register("chorus_teleport", ChorusTeleport.CODEC);
        AllPotatoProjectileEntityHitActions.register("cure_zombie_villager", CureZombieVillager.CODEC);
        AllPotatoProjectileEntityHitActions.register("suspicious_stew", SuspiciousStew.CODEC);
    }

    public record SetOnFire(int ticks) implements PotatoProjectileEntityHitAction
    {
        public static final Codec<SetOnFire> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_144629_.fieldOf("ticks").forGetter(SetOnFire::ticks)).apply((Applicative)instance, SetOnFire::new));

        public static SetOnFire seconds(int seconds) {
            return new SetOnFire(seconds * 20);
        }

        @Override
        public boolean execute(ItemStack projectile, EntityHitResult ray, PotatoProjectileEntityHitAction.Type type) {
            ray.m_82443_().m_7311_(this.ticks);
            return false;
        }

        @Override
        public Codec<? extends PotatoProjectileEntityHitAction> codec() {
            return CODEC;
        }
    }

    public record PotionEffect(MobEffect effect, int level, int ticks, boolean recoverable) implements PotatoProjectileEntityHitAction
    {
        public static final Codec<PotionEffect> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_256974_.m_194605_().fieldOf("effect").forGetter(PotionEffect::effect), (App)ExtraCodecs.f_144629_.fieldOf("level").forGetter(PotionEffect::level), (App)ExtraCodecs.f_144629_.fieldOf("ticks").forGetter(PotionEffect::ticks), (App)Codec.BOOL.fieldOf("recoverable").forGetter(PotionEffect::recoverable)).apply((Applicative)instance, PotionEffect::new));

        @Override
        public boolean execute(ItemStack projectile, EntityHitResult ray, PotatoProjectileEntityHitAction.Type type) {
            Entity entity = ray.m_82443_();
            if (entity.m_9236_().f_46443_) {
                return true;
            }
            if (entity instanceof LivingEntity) {
                AllPotatoProjectileEntityHitActions.applyEffect((LivingEntity)entity, new MobEffectInstance(this.effect, this.ticks, this.level - 1));
            }
            return !this.recoverable;
        }

        @Override
        public Codec<? extends PotatoProjectileEntityHitAction> codec() {
            return CODEC;
        }
    }

    public record FoodEffects(FoodProperties foodProperty, boolean recoverable) implements PotatoProjectileEntityHitAction
    {
        public static final Codec<FoodEffects> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CreateCodecs.FOOD_PROPERTIES.fieldOf("food_property").forGetter(FoodEffects::foodProperty), (App)Codec.BOOL.fieldOf("recoverable").forGetter(FoodEffects::recoverable)).apply((Applicative)instance, FoodEffects::new));

        @Override
        public boolean execute(ItemStack projectile, EntityHitResult ray, PotatoProjectileEntityHitAction.Type type) {
            Entity entity = ray.m_82443_();
            if (entity.m_9236_().f_46443_) {
                return true;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                for (Pair effect : this.foodProperty.m_38749_()) {
                    if (!(livingEntity.m_217043_().m_188501_() < ((Float)effect.getSecond()).floatValue())) continue;
                    AllPotatoProjectileEntityHitActions.applyEffect(livingEntity, new MobEffectInstance((MobEffectInstance)effect.getFirst()));
                }
            }
            return !this.recoverable;
        }

        @Override
        public Codec<? extends PotatoProjectileEntityHitAction> codec() {
            return CODEC;
        }
    }

    public record ChorusTeleport(double teleportDiameter) implements PotatoProjectileEntityHitAction
    {
        public static final Codec<ChorusTeleport> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CreateCodecs.POSITIVE_DOUBLE.fieldOf("teleport_diameter").forGetter(ChorusTeleport::teleportDiameter)).apply((Applicative)instance, ChorusTeleport::new));

        @Override
        public boolean execute(ItemStack projectile, EntityHitResult ray, PotatoProjectileEntityHitAction.Type type) {
            Entity entity = ray.m_82443_();
            Level level = entity.m_20193_();
            if (level.f_46443_) {
                return true;
            }
            if (!(entity instanceof LivingEntity)) {
                return false;
            }
            LivingEntity livingEntity = (LivingEntity)entity;
            double entityX = livingEntity.m_20185_();
            double entityY = livingEntity.m_20186_();
            double entityZ = livingEntity.m_20189_();
            for (int teleportTry = 0; teleportTry < 16; ++teleportTry) {
                double teleportZ;
                double teleportY;
                double teleportX = entityX + (livingEntity.m_217043_().m_188500_() - 0.5) * this.teleportDiameter;
                EntityTeleportEvent.ChorusFruit event = ForgeEventFactory.onChorusFruitTeleport((LivingEntity)livingEntity, (double)teleportX, (double)(teleportY = Mth.m_14008_((double)(entityY + (double)(livingEntity.m_217043_().m_188503_((int)this.teleportDiameter) - (int)(this.teleportDiameter / 2.0))), (double)0.0, (double)(level.m_141928_() - 1))), (double)(teleportZ = entityZ + (livingEntity.m_217043_().m_188500_() - 0.5) * this.teleportDiameter));
                if (event.isCanceled()) {
                    return false;
                }
                if (!livingEntity.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true)) continue;
                if (livingEntity.m_20159_()) {
                    livingEntity.m_8127_();
                }
                SoundEvent soundevent = livingEntity instanceof Fox ? SoundEvents.f_11953_ : SoundEvents.f_11757_;
                level.m_6263_(null, entityX, entityY, entityZ, soundevent, SoundSource.PLAYERS, 1.0f, 1.0f);
                livingEntity.m_5496_(soundevent, 1.0f, 1.0f);
                livingEntity.m_20256_(Vec3.f_82478_);
                return true;
            }
            return false;
        }

        @Override
        public Codec<? extends PotatoProjectileEntityHitAction> codec() {
            return CODEC;
        }
    }

    public static enum CureZombieVillager implements PotatoProjectileEntityHitAction
    {
        INSTANCE;

        private static final FoodEffects EFFECT;
        private static final GameProfile ZOMBIE_CONVERTER_NAME;
        private static final WorldAttached<FakePlayer> ZOMBIE_CONVERTERS;
        public static final Codec<CureZombieVillager> CODEC;

        @Override
        public boolean execute(ItemStack projectile, EntityHitResult ray, PotatoProjectileEntityHitAction.Type type) {
            ZombieVillager zombieVillager;
            Entity entity = ray.m_82443_();
            Level world = entity.m_9236_();
            if (!(entity instanceof ZombieVillager) || !(zombieVillager = (ZombieVillager)entity).m_21023_(MobEffects.f_19613_)) {
                return EFFECT.execute(projectile, ray, type);
            }
            if (world.f_46443_) {
                return false;
            }
            FakePlayer dummy = (FakePlayer)ZOMBIE_CONVERTERS.get((LevelAccessor)world);
            dummy.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42436_, 1));
            zombieVillager.m_6071_((Player)dummy, InteractionHand.MAIN_HAND);
            return true;
        }

        @Override
        public Codec<? extends PotatoProjectileEntityHitAction> codec() {
            return CODEC;
        }

        static {
            EFFECT = new FoodEffects(Foods.f_38830_, false);
            ZOMBIE_CONVERTER_NAME = new GameProfile(UUID.fromString("be12d3dc-27d3-4992-8c97-66be53fd49c5"), "Converter");
            ZOMBIE_CONVERTERS = new WorldAttached(w -> new FakePlayer((ServerLevel)w, ZOMBIE_CONVERTER_NAME));
            CODEC = Codec.unit((Object)INSTANCE);
        }
    }

    public static enum SuspiciousStew implements PotatoProjectileEntityHitAction
    {
        INSTANCE;

        public static final Codec<SuspiciousStew> CODEC;

        @Override
        public boolean execute(ItemStack projectile, EntityHitResult ray, PotatoProjectileEntityHitAction.Type type) {
            Entity entity = ray.m_82443_();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                SuspiciousStewItemAccessor.create$listPotionEffects(projectile, arg_0 -> ((LivingEntity)livingEntity).m_7292_(arg_0));
            }
            return false;
        }

        @Override
        public Codec<? extends PotatoProjectileEntityHitAction> codec() {
            return CODEC;
        }

        static {
            CODEC = Codec.unit((Object)INSTANCE);
        }
    }
}

