/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedKinetics;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

@ParametersAreNonnullByDefault
public abstract class ProcessingViaFanCategory<T extends Recipe<?>>
extends CreateRecipeCategory<T> {
    protected static final int SCALE = 24;

    public ProcessingViaFanCategory(CreateRecipeCategory.Info<T> info) {
        super(info);
    }

    public static Supplier<ItemStack> getFan(String name) {
        return () -> AllBlocks.ENCASED_FAN.asStack().m_41714_((Component)CreateLang.translateDirect("recipe." + name + ".fan", new Object[0]).m_130938_(style -> style.m_131155_(Boolean.valueOf(false))));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 21, 48).setBackground(ProcessingViaFanCategory.getRenderedSlot(), -1, -1).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 141, 48).setBackground(ProcessingViaFanCategory.getRenderedSlot(), -1, -1).addItemStack(ProcessingViaFanCategory.getResultItem(recipe));
    }

    public void draw(T recipe, IRecipeSlotsView iRecipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        this.renderWidgets(graphics, recipe, mouseX, mouseY);
        PoseStack matrixStack = graphics.m_280168_();
        matrixStack.m_85836_();
        this.translateFan(matrixStack);
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(-12.5f));
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(22.5f));
        AnimatedKinetics.defaultBlockElement(AllPartialModels.ENCASED_FAN_INNER).rotateBlock(180.0, 0.0, (double)(AnimatedKinetics.getCurrentAngle() * 16.0f)).scale(24.0).render(graphics);
        AnimatedKinetics.defaultBlockElement(AllBlocks.ENCASED_FAN.getDefaultState()).rotateBlock(0.0, 180.0, 0.0).atLocal(0.0, 0.0, 0.0).scale(24.0).render(graphics);
        this.renderAttachedBlock(graphics);
        matrixStack.m_85849_();
    }

    protected void renderWidgets(GuiGraphics graphics, T recipe, double mouseX, double mouseY) {
        AllGuiTextures.JEI_SHADOW.render(graphics, 46, 29);
        this.getBlockShadow().render(graphics, 65, 39);
        AllGuiTextures.JEI_LONG_ARROW.render(graphics, 54, 51);
    }

    protected AllGuiTextures getBlockShadow() {
        return AllGuiTextures.JEI_SHADOW;
    }

    protected void translateFan(PoseStack matrixStack) {
        matrixStack.m_252880_(56.0f, 33.0f, 0.0f);
    }

    protected abstract void renderAttachedBlock(GuiGraphics var1);

    public static abstract class MultiOutput<T extends ProcessingRecipe<?>>
    extends ProcessingViaFanCategory<T> {
        public MultiOutput(CreateRecipeCategory.Info<T> info) {
            super(info);
        }

        @Override
        public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
            List<ProcessingOutput> results = ((ProcessingRecipe)recipe).getRollableResults();
            int xOffsetAmount = 1 - Math.min(3, results.size());
            builder.addSlot(RecipeIngredientRole.INPUT, 5 * xOffsetAmount + 21, 48).setBackground(MultiOutput.getRenderedSlot(), -1, -1).addIngredients((Ingredient)((ProcessingRecipe)recipe).m_7527_().get(0));
            int i = 0;
            boolean excessive = results.size() > 9;
            for (ProcessingOutput output : results) {
                int xOffset = i % 3 * 19 + 9 * xOffsetAmount;
                int yOffset = i / 3 * -19 + (excessive ? 8 : 0);
                ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 141 + xOffset, 48 + yOffset).setBackground(MultiOutput.getRenderedSlot(output), -1, -1).addItemStack(output.getStack())).addRichTooltipCallback(MultiOutput.addStochasticTooltip(output));
                ++i;
            }
        }

        @Override
        protected void renderWidgets(GuiGraphics graphics, T recipe, double mouseX, double mouseY) {
            int size = ((ProcessingRecipe)recipe).getRollableResultsAsItemStacks().size();
            int xOffsetAmount = 1 - Math.min(3, size);
            AllGuiTextures.JEI_SHADOW.render(graphics, 46, 29);
            this.getBlockShadow().render(graphics, 65, 39);
            AllGuiTextures.JEI_LONG_ARROW.render(graphics, 7 * xOffsetAmount + 54, 51);
        }
    }
}

