/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.api.contraption.storage.item.chest;

import com.mojang.serialization.Codec;
import com.simibubi.create.AllMountedStorageTypes;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorage;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageType;
import com.simibubi.create.api.contraption.storage.item.simple.SimpleMountedStorage;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.foundation.item.ItemHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.Nullable;

public class ChestMountedStorage
extends SimpleMountedStorage {
    public static final Codec<ChestMountedStorage> CODEC = SimpleMountedStorage.codec(ChestMountedStorage::new);

    protected ChestMountedStorage(MountedItemStorageType<?> type, IItemHandler handler) {
        super(type, handler);
    }

    public ChestMountedStorage(IItemHandler handler) {
        this((MountedItemStorageType)AllMountedStorageTypes.CHEST.get(), handler);
    }

    @Override
    public void unmount(Level level, BlockState state, BlockPos pos, @Nullable BlockEntity be) {
        if (be instanceof Container) {
            Container container = (Container)be;
            if (this.getSlots() == container.m_6643_()) {
                ItemHelper.copyContents((IItemHandler)this, (IItemHandlerModifiable)new InvWrapper(container));
            }
        }
    }

    @Override
    protected IItemHandlerModifiable getHandlerForMenu(StructureTemplate.StructureBlockInfo info, Contraption contraption) {
        BlockState state = info.f_74676_();
        ChestType type = (ChestType)state.m_61143_((Property)ChestBlock.f_51479_);
        if (type == ChestType.SINGLE) {
            return this;
        }
        Direction facing = (Direction)state.m_61143_((Property)ChestBlock.f_51478_);
        Direction connectedDirection = ChestBlock.m_51584_((BlockState)state);
        BlockPos otherHalfPos = info.f_74675_().m_121945_(connectedDirection);
        MountedItemStorage otherHalf = this.getOtherHalf(contraption, otherHalfPos, state.m_60734_(), facing, type);
        if (otherHalf == null) {
            return this;
        }
        if (type == ChestType.RIGHT) {
            return new CombinedInvWrapper(new IItemHandlerModifiable[]{this, otherHalf});
        }
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{otherHalf, this});
    }

    @Nullable
    protected MountedItemStorage getOtherHalf(Contraption contraption, BlockPos localPos, Block block, Direction thisFacing, ChestType thisType) {
        StructureTemplate.StructureBlockInfo info = contraption.getBlocks().get(localPos);
        if (info == null) {
            return null;
        }
        BlockState state = info.f_74676_();
        if (!state.m_60713_(block)) {
            return null;
        }
        Direction facing = (Direction)state.m_61143_((Property)ChestBlock.f_51478_);
        ChestType type = (ChestType)state.m_61143_((Property)ChestBlock.f_51479_);
        return facing == thisFacing && type == thisType.m_61486_() ? (MountedItemStorage)contraption.getStorage().getMountedItems().storages.get((Object)localPos) : null;
    }

    @Override
    protected void playOpeningSound(ServerLevel level, Vec3 pos) {
        level.m_5594_(null, BlockPos.m_274446_((Position)pos), SoundEvents.f_11749_, SoundSource.BLOCKS, 0.75f, 1.0f);
    }

    @Override
    protected void playClosingSound(ServerLevel level, Vec3 pos) {
        level.m_5594_(null, BlockPos.m_274446_((Position)pos), SoundEvents.f_11747_, SoundSource.BLOCKS, 0.75f, 1.0f);
    }
}

