/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.network;

import com.copycatsplus.copycats.Copycats;
import com.copycatsplus.copycats.network.CCPackets;
import com.copycatsplus.copycats.network.PlayerSelection;
import com.copycatsplus.copycats.network.forge.PacketSystemImpl;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import dev.architectury.injectables.annotations.ExpectPlatform;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

public abstract class PacketSystem {
    public final String id;
    public final int version;
    public final ResourceLocation c2sPacket;
    public final ResourceLocation s2cPacket;
    private final List<Function<FriendlyByteBuf, S2CPacket>> s2cPackets;
    private final Object2IntMap<Class<? extends S2CPacket>> s2cTypes;
    private final List<Function<FriendlyByteBuf, C2SPacket>> c2sPackets;
    private final Object2IntMap<Class<? extends C2SPacket>> c2sTypes;

    protected PacketSystem(String id, int version, List<Function<FriendlyByteBuf, S2CPacket>> s2cPackets, Object2IntMap<Class<? extends S2CPacket>> s2cTypes, List<Function<FriendlyByteBuf, C2SPacket>> c2sPackets, Object2IntMap<Class<? extends C2SPacket>> c2sTypes) {
        this.id = id;
        this.version = version;
        this.s2cPackets = s2cPackets;
        this.s2cTypes = s2cTypes;
        this.c2sPackets = c2sPackets;
        this.c2sTypes = c2sTypes;
        this.c2sPacket = new ResourceLocation(id, "c2s");
        this.s2cPacket = new ResourceLocation(id, "s2c");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void send(C2SPacket packet) {
        int i = this.idOfC2S(packet);
        if (i == -1) {
            throw new IllegalArgumentException("Cannot send unregistered C2SPacket: " + String.valueOf(packet));
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130130_(i);
        packet.write(buf);
        this.doSendC2S(buf);
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void send(SimplePacketBase var1);

    public void sendTo(ServerPlayer player, S2CPacket packet) {
        this.sendTo(PlayerSelection.of(player), packet);
    }

    public abstract void sendTo(ServerPlayer var1, SimplePacketBase var2);

    public void sendTo(PlayerSelection selection, S2CPacket packet) {
        int i = this.idOfS2C(packet);
        if (i == -1) {
            throw new IllegalArgumentException("Cannot send unregistered S2CPacket: " + String.valueOf(packet));
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130130_(i);
        packet.write(buf);
        selection.accept(this.s2cPacket, buf);
    }

    public abstract void sendTo(PlayerSelection var1, SimplePacketBase var2);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void registerS2CListener();

    public abstract void registerC2SListener();

    @OnlyIn(value=Dist.CLIENT)
    protected abstract void doSendC2S(FriendlyByteBuf var1);

    protected int idOfC2S(C2SPacket packet) {
        return this.c2sTypes.getOrDefault(packet.getClass(), -1);
    }

    protected int idOfS2C(S2CPacket packet) {
        return this.s2cTypes.getOrDefault(packet.getClass(), -1);
    }

    @OnlyIn(value=Dist.CLIENT)
    @ApiStatus.Internal
    public void handleS2CPacket(Minecraft mc, FriendlyByteBuf buf) {
        int i = buf.m_130242_();
        if (i < 0 || i >= this.s2cPackets.size()) {
            Copycats.LOGGER.error("Invalid S2C Packet {}, ignoring", (Object)i);
            return;
        }
        Function<FriendlyByteBuf, S2CPacket> factory = this.s2cPackets.get(i);
        S2CPacket packet = factory.apply(buf);
        mc.execute(() -> packet.handle(mc));
    }

    @ApiStatus.Internal
    public void handleC2SPacket(ServerPlayer sender, FriendlyByteBuf buf) {
        int i = buf.m_130242_();
        if (i < 0 || i >= this.c2sPackets.size()) {
            Copycats.LOGGER.error("Invalid C2S Packet {}, ignoring", (Object)i);
            return;
        }
        Function<FriendlyByteBuf, C2SPacket> factory = this.c2sPackets.get(i);
        C2SPacket packet = factory.apply(buf);
        sender.f_8924_.execute(() -> packet.handle(sender));
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ApiStatus.Internal
    @ExpectPlatform.Transformed
    public static PacketSystem create(String id, int version, List<Function<FriendlyByteBuf, S2CPacket>> s2cPackets, Object2IntMap<Class<? extends S2CPacket>> s2cTypes, List<Function<FriendlyByteBuf, C2SPacket>> c2sPackets, Object2IntMap<Class<? extends C2SPacket>> c2sTypes) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return PacketSystemImpl.create(id, (int)var1_1, (List<Function<FriendlyByteBuf, S2CPacket>>)var2_2, (Object2IntMap<Class<? extends S2CPacket>>)var3_3, (List<Function<FriendlyByteBuf, C2SPacket>>)var4_4, (Object2IntMap<Class<? extends C2SPacket>>)var5_5);
    }

    public static Builder builder(String id, int version) {
        return new Builder(id, version).s2c(CheckVersionPacket.class, CheckVersionPacket::new);
    }

    public void onPlayerJoin(ServerPlayer player) {
        this.sendTo(player, (S2CPacket)new CheckVersionPacket(this.version));
    }

    public static interface C2SPacket {
        public void write(FriendlyByteBuf var1);

        public void handle(ServerPlayer var1);
    }

    public static interface S2CPacket {
        public void write(FriendlyByteBuf var1);

        @OnlyIn(value=Dist.CLIENT)
        public void handle(Minecraft var1);
    }

    public static class Builder {
        public final String id;
        public final int version;
        private final List<Function<FriendlyByteBuf, S2CPacket>> s2cPackets = new ArrayList<Function<FriendlyByteBuf, S2CPacket>>();
        private final Object2IntMap<Class<? extends S2CPacket>> s2cTypes = new Object2IntOpenHashMap();
        private final List<Function<FriendlyByteBuf, C2SPacket>> c2sPackets = new ArrayList<Function<FriendlyByteBuf, C2SPacket>>();
        private final Object2IntMap<Class<? extends C2SPacket>> c2sTypes = new Object2IntOpenHashMap();

        protected Builder(String id, int version) {
            this.id = id;
            this.version = version;
        }

        public Builder s2c(Class<? extends S2CPacket> clazz, Function<FriendlyByteBuf, S2CPacket> factory) {
            this.s2cPackets.add(factory);
            this.s2cTypes.put(clazz, this.s2cPackets.indexOf(factory));
            return this;
        }

        public Builder c2s(Class<? extends C2SPacket> clazz, Function<FriendlyByteBuf, C2SPacket> factory) {
            this.c2sPackets.add(factory);
            this.c2sTypes.put(clazz, this.c2sPackets.indexOf(factory));
            return this;
        }

        public PacketSystem build() {
            return PacketSystem.create(this.id, this.version, this.s2cPackets, this.s2cTypes, this.c2sPackets, this.c2sTypes);
        }
    }

    public record CheckVersionPacket(int serverVersion) implements S2CPacket
    {
        public CheckVersionPacket(FriendlyByteBuf buf) {
            this(buf.m_130242_());
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.m_130130_(this.serverVersion);
        }

        @Override
        public void handle(Minecraft mc) {
            if (CCPackets.PACKETS.version == this.serverVersion) {
                return;
            }
            MutableComponent error = Component.m_237113_((String)"Create: Copycats+ on the client uses a different network format than the server.").m_130946_(" You should use the same version of the mod on both sides.");
            mc.m_91403_().m_7026_((Component)error);
        }
    }
}

