/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.api.capability;

import java.util.Arrays;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.cookingforblockheads.api.SourceItem;
import net.blay09.mods.cookingforblockheads.api.capability.AbstractKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IngredientPredicate;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.registry.IngredientPredicateWithCacheImpl;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class DefaultKitchenItemProvider
extends AbstractKitchenItemProvider {
    private Container container;
    private int[] usedStackSize;

    public DefaultKitchenItemProvider() {
    }

    public DefaultKitchenItemProvider(Container container) {
        this.container = container;
        this.usedStackSize = new int[container.m_6643_()];
    }

    public void setContainer(Container container) {
        this.container = container;
        this.usedStackSize = new int[container.m_6643_()];
    }

    @Override
    public void resetSimulation() {
        Arrays.fill(this.usedStackSize, 0);
    }

    @Override
    public int getSimulatedUseCount(int slot) {
        return this.usedStackSize[slot];
    }

    @Override
    public ItemStack useItemStack(int slot, int amount, boolean simulate, List<IKitchenItemProvider> inventories, boolean requireBucket) {
        if (slot == -1) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = this.container.m_8020_(slot);
        if (itemStack.m_41613_() - (simulate ? this.usedStackSize[slot] : 0) >= amount) {
            ItemStack result = ContainerUtils.extractItem((Container)this.container, (int)slot, (int)amount, (boolean)simulate);
            if (simulate && !result.m_41619_()) {
                int n = slot;
                this.usedStackSize[n] = this.usedStackSize[n] + result.m_41613_();
            }
            return result;
        }
        return ItemStack.f_41583_;
    }

    @Override
    public ItemStack returnItemStack(ItemStack itemStack, SourceItem sourceItem) {
        ItemStack restStack = ContainerUtils.insertItem((Container)this.container, (int)sourceItem.getSourceSlot(), (ItemStack)itemStack, (boolean)false);
        if (!restStack.m_41619_()) {
            restStack = ContainerUtils.insertItemStacked((Container)this.container, (ItemStack)itemStack, (boolean)false);
        }
        return restStack;
    }

    @Override
    public int getSlots() {
        return this.container.m_6643_();
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return this.container.m_8020_(slot);
    }

    @Override
    @Nullable
    public SourceItem findSource(IngredientPredicate predicate, int maxAmount, List<IKitchenItemProvider> inventories, boolean requireBucket, boolean simulate) {
        IngredientPredicate modifiedPredicate = predicate;
        if (this.hasPreservationUpgrade()) {
            modifiedPredicate = IngredientPredicateWithCacheImpl.and(predicate, (it, count) -> count > 1 || !Balm.getHooks().getCraftingRemainingItem(it).m_41619_() || CookingRegistry.isToolItem(it));
        }
        return super.findSource(modifiedPredicate, maxAmount, inventories, requireBucket, simulate);
    }

    @Override
    @Nullable
    public SourceItem findSourceAndMarkAsUsed(IngredientPredicate predicate, int maxAmount, List<IKitchenItemProvider> inventories, boolean requireBucket, boolean simulate) {
        IngredientPredicate modifiedPredicate = predicate;
        if (this.hasPreservationUpgrade()) {
            modifiedPredicate = IngredientPredicateWithCacheImpl.and(predicate, (it, count) -> count > 1 || !Balm.getHooks().getCraftingRemainingItem(it).m_41619_() || CookingRegistry.isToolItem(it));
        }
        return super.findSourceAndMarkAsUsed(modifiedPredicate, maxAmount, inventories, requireBucket, simulate);
    }

    public boolean hasPreservationUpgrade() {
        return false;
    }
}

