/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.chemlib.datagen;

import com.smashingmods.chemlib.api.ChemicalItemType;
import com.smashingmods.chemlib.api.MatterState;
import com.smashingmods.chemlib.registry.ItemRegistry;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemTagGenerator
extends ItemTagsProvider {
    public ItemTagGenerator(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pLookupProvider, TagsProvider<Block> pBlockTagProvider, ExistingFileHelper pFileHelper) {
        super(pOutput, pLookupProvider, pBlockTagProvider.m_274426_(), "chemlib", pFileHelper);
    }

    public void m_6577_(HolderLookup.Provider lookupProvider) {
        ItemRegistry.getChemicalItems().forEach(item -> {
            String type = item.getItemType().m_7912_();
            String name = item.getChemicalName();
            TagKey key = Objects.requireNonNull(ForgeRegistries.ITEMS.tags()).createTagKey(new ResourceLocation("forge", String.format("%ss/%s", type, name)));
            this.m_206424_(key).m_255245_(item);
        });
        ItemRegistry.getChemicalBlockItems().forEach(item -> {
            if (item.getMatterState().equals((Object)MatterState.SOLID)) {
                String name = item.getChemicalName();
                TagKey key = Objects.requireNonNull(ForgeRegistries.ITEMS.tags()).createTagKey(new ResourceLocation("forge", String.format("storage_blocks/%s", name)));
                this.m_206424_(key).m_255245_(item);
            }
        });
        ItemRegistry.getChemicalItemByNameAndType("potassium_nitrate", ChemicalItemType.COMPOUND).ifPresent(compound -> {
            ResourceLocation niter = new ResourceLocation("forge", "dusts/niter");
            TagKey key = Objects.requireNonNull(ForgeRegistries.ITEMS.tags()).createTagKey(niter);
            this.m_206424_(key).m_255245_(compound);
        });
        ItemRegistry.getChemicalItemByNameAndType("hydroxylapatite", ChemicalItemType.COMPOUND).ifPresent(compound -> {
            ResourceLocation niter = new ResourceLocation("forge", "dusts/apatite");
            TagKey key = Objects.requireNonNull(ForgeRegistries.ITEMS.tags()).createTagKey(niter);
            this.m_206424_(key).m_255245_(compound);
        });
        ItemRegistry.getChemicalItemByNameAndType("cellulose", ChemicalItemType.COMPOUND).ifPresent(compound -> {
            ResourceLocation sawdust = new ResourceLocation("forge", "sawdust");
            TagKey key = Objects.requireNonNull(ForgeRegistries.ITEMS.tags()).createTagKey(sawdust);
            this.m_206424_(key).m_255245_(compound);
        });
        ItemRegistry.getChemicalItemByNameAndType("mercury_sulfide", ChemicalItemType.COMPOUND).ifPresent(compound -> {
            ResourceLocation sawdust = new ResourceLocation("forge", "dusts/cinnabar");
            TagKey key = Objects.requireNonNull(ForgeRegistries.ITEMS.tags()).createTagKey(sawdust);
            this.m_206424_(key).m_255245_(compound);
        });
    }

    @Nonnull
    public String m_6055_() {
        return "chemlib:tags";
    }
}

