/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.centrifugetiersreproduced.gui;

import com.ultramega.centrifugetiersreproduced.CentrifugeTiers;
import com.ultramega.centrifugetiersreproduced.container.TieredCentrifugeContainer;
import com.ultramega.centrifugetiersreproduced.gui.FluidContainerUtil;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;

public class TieredCentrifugeScreen
extends AbstractContainerScreen<TieredCentrifugeContainer> {
    private static final ResourceLocation GUI_HIGH_END_TEXTURE = new ResourceLocation("centrifugetiersreproduced", "textures/gui/high_end_centrifuge.png");
    private static final ResourceLocation GUI_NUCLEAR_TEXTURE = new ResourceLocation("centrifugetiersreproduced", "textures/gui/nuclear_centrifuge.png");
    private static final ResourceLocation GUI_COSMIC_TEXTURE = new ResourceLocation("centrifugetiersreproduced", "textures/gui/cosmic_centrifuge.png");
    private static final ResourceLocation GUI_CREATIVE_TEXTURE = new ResourceLocation("centrifugetiersreproduced", "textures/gui/creative_centrifuge.png");
    private final CentrifugeTiers tier;

    public TieredCentrifugeScreen(TieredCentrifugeContainer container, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)container, inv, titleIn);
        this.tier = container.blockEntity.tier;
    }

    public void m_88315_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, -5, 6, 0x404040, false);
        guiGraphics.m_280614_(this.f_96547_, this.f_169604_, -5, this.getYSize() - (this.tier == CentrifugeTiers.COSMIC || this.tier == CentrifugeTiers.CREATIVE ? 78 : 96) + 2, 0x404040, false);
        ((TieredCentrifugeContainer)this.f_97732_).blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(handler -> {
            FluidStack fluidStack = handler.getFluidInTank(0);
            if (this.m_6774_(this.tier == CentrifugeTiers.CREATIVE ? 145 : 127, 16, 6, this.tier == CentrifugeTiers.COSMIC || this.tier == CentrifugeTiers.CREATIVE ? 72 : 54, mouseX, mouseY)) {
                ArrayList<FormattedCharSequence> tooltipList = new ArrayList<FormattedCharSequence>();
                if (fluidStack.getAmount() > 0) {
                    tooltipList.add(Component.m_237110_((String)"productivebees.screen.fluid_level", (Object[])new Object[]{Component.m_237115_((String)fluidStack.getTranslationKey()).getString(), fluidStack.getAmount() + "mB"}).m_7532_());
                } else {
                    tooltipList.add(Component.m_237115_((String)"productivebees.hive.tooltip.empty").m_7532_());
                }
                guiGraphics.m_280245_(this.f_96547_, tooltipList, mouseX - this.getGuiLeft(), mouseY - this.getGuiTop());
            }
        });
        if (this.tier != CentrifugeTiers.CREATIVE) {
            ((TieredCentrifugeContainer)this.f_97732_).blockEntity.getCapability(ForgeCapabilities.ENERGY).ifPresent(handler -> {
                int energyAmount = handler.getEnergyStored();
                if (this.m_6774_(-5, 16, 6, this.tier == CentrifugeTiers.COSMIC ? 72 : 54, mouseX, mouseY)) {
                    ArrayList<FormattedCharSequence> tooltipList = new ArrayList<FormattedCharSequence>();
                    tooltipList.add(Component.m_237110_((String)"productivebees.screen.energy_level", (Object[])new Object[]{energyAmount + "FE"}).m_7532_());
                    guiGraphics.m_280245_(this.f_96547_, tooltipList, mouseX - this.getGuiLeft(), mouseY - this.getGuiTop());
                }
            });
        }
    }

    protected void m_7286_(@Nonnull GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        ResourceLocation GUI = switch (this.tier) {
            default -> throw new IncompatibleClassChangeError();
            case CentrifugeTiers.HIGH_END -> GUI_HIGH_END_TEXTURE;
            case CentrifugeTiers.NUCLEAR -> GUI_NUCLEAR_TEXTURE;
            case CentrifugeTiers.COSMIC -> GUI_COSMIC_TEXTURE;
            case CentrifugeTiers.CREATIVE -> GUI_CREATIVE_TEXTURE;
        };
        guiGraphics.m_280218_(GUI, this.getGuiLeft() - 13, this.getGuiTop(), 0, 0, this.getXSize() + (this.tier == CentrifugeTiers.CREATIVE ? 0 : 26), this.getYSize() + (this.tier == CentrifugeTiers.COSMIC || this.tier == CentrifugeTiers.CREATIVE ? 18 : 0));
        int arrowX = this.tier == CentrifugeTiers.CREATIVE ? 176 : 202;
        int arrowY = this.tier == CentrifugeTiers.COSMIC ? 71 : 52;
        int progress = (int)((float)((TieredCentrifugeContainer)this.f_97732_).blockEntity.recipeProgress[0] * (24.0f / (float)((TieredCentrifugeContainer)this.f_97732_).blockEntity.getProcessingTime(((TieredCentrifugeContainer)this.f_97732_).blockEntity.getCurrentRecipes()[0])));
        guiGraphics.m_280218_(GUI, this.getGuiLeft() + 35, this.getGuiTop() + 17, arrowX, arrowY, progress + 1, 16);
        int progress2 = (int)((float)((TieredCentrifugeContainer)this.f_97732_).blockEntity.recipeProgress[1] * (24.0f / (float)((TieredCentrifugeContainer)this.f_97732_).blockEntity.getProcessingTime(((TieredCentrifugeContainer)this.f_97732_).blockEntity.getCurrentRecipes()[1])));
        guiGraphics.m_280218_(GUI, this.getGuiLeft() + 35, this.getGuiTop() + 53, arrowX, arrowY, progress2 + 1, 16);
        if (this.tier.getInputSlotAmount() > 2) {
            int progress3 = (int)((float)((TieredCentrifugeContainer)this.f_97732_).blockEntity.recipeProgress[2] * (24.0f / (float)((TieredCentrifugeContainer)this.f_97732_).blockEntity.getProcessingTime(((TieredCentrifugeContainer)this.f_97732_).blockEntity.getCurrentRecipes()[2])));
            guiGraphics.m_280218_(GUI, this.getGuiLeft() + 35, this.getGuiTop() + 35, arrowX, arrowY, progress3 + 1, 16);
            if (this.tier.getInputSlotAmount() > 3) {
                int progress4 = (int)((float)((TieredCentrifugeContainer)this.f_97732_).blockEntity.recipeProgress[3] * (24.0f / (float)((TieredCentrifugeContainer)this.f_97732_).blockEntity.getProcessingTime(((TieredCentrifugeContainer)this.f_97732_).blockEntity.getCurrentRecipes()[3])));
                guiGraphics.m_280218_(GUI, this.getGuiLeft() + 35, this.getGuiTop() + 71, arrowX, arrowY, progress4 + 1, 16);
            }
        }
        int energySizeY = this.tier == CentrifugeTiers.COSMIC ? 70 : 52;
        guiGraphics.m_280218_(GUI, this.getGuiLeft() - 5, this.getGuiTop() + 17, 206, 0, 4, energySizeY);
        ((TieredCentrifugeContainer)this.f_97732_).blockEntity.getCapability(ForgeCapabilities.ENERGY).ifPresent(handler -> {
            int energyAmount = handler.getEnergyStored();
            double energyLevel = (double)energyAmount * ((double)energySizeY / (double)handler.getMaxEnergyStored());
            guiGraphics.m_280218_(GUI, this.getGuiLeft() - 5, this.getGuiTop() + 17, 8, 17, 4, (int)((double)energySizeY - energyLevel));
        });
        ((TieredCentrifugeContainer)this.f_97732_).blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(handler -> {
            FluidStack fluidStack = handler.getFluidInTank(0);
            if (fluidStack.getAmount() > 0) {
                FluidContainerUtil.renderFluidTank(guiGraphics, this, fluidStack, handler.getTankCapacity(0), this.tier == CentrifugeTiers.CREATIVE ? 145 : 127, 17, 4, this.tier == CentrifugeTiers.CREATIVE || this.tier == CentrifugeTiers.COSMIC ? 70 : 52, 0);
            }
        });
    }
}

