/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.centrifugetiersreproduced.blockentity;

import com.ultramega.centrifugetiersreproduced.CentrifugeTiers;
import com.ultramega.centrifugetiersreproduced.blockentity.TieredCentrifugeBlockEntity;
import cy.jdkdigital.productivebees.common.item.Gene;
import cy.jdkdigital.productivebees.common.item.UpgradeItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;

public class InventoryHandlerHelper {
    public static final int BOTTLE_SLOT = 0;
    public static final int[] INPUT_SLOT = new int[]{1, 2, 3, 4};
    public static final int FLUID_ITEM_OUTPUT_SLOT = 21;
    public static final int[] OUTPUT_SLOTS = new int[]{5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20};

    private static int getAvailableOutputSlot(ItemHandler handler, ItemStack insertStack, CentrifugeTiers tier) {
        return InventoryHandlerHelper.getAvailableOutputSlot(handler, insertStack, new ArrayList<Integer>(), tier);
    }

    private static int getAvailableOutputSlot(ItemHandler handler, ItemStack insertStack, List<Integer> blacklistedSlots, CentrifugeTiers tier) {
        int emptySlot = 0;
        int outputSlotAmount = 0;
        if (tier == CentrifugeTiers.COSMIC) {
            outputSlotAmount = 3;
        } else if (tier == CentrifugeTiers.CREATIVE) {
            outputSlotAmount = 7;
        }
        for (int i = 0; i < 9 + outputSlotAmount; ++i) {
            int slot = handler.getOutputSlots()[i];
            if (blacklistedSlots.contains(slot)) continue;
            ItemStack stack = handler.getStackInSlot(slot);
            if (stack.m_41619_() && emptySlot == 0) {
                emptySlot = slot;
                continue;
            }
            if (!stack.m_41720_().equals(insertStack.m_41720_()) || stack.m_41613_() + insertStack.m_41613_() > tier.getItemMaxStackSize() || !(!Gene.getAttributeName((ItemStack)insertStack).isEmpty() ? Gene.getAttributeName((ItemStack)stack).equals(Gene.getAttributeName((ItemStack)insertStack)) && Gene.getValue((ItemStack)stack).equals(Gene.getValue((ItemStack)insertStack)) && Gene.getPurity((ItemStack)stack).equals(Gene.getPurity((ItemStack)insertStack)) : stack.m_41619_() || InventoryHandlerHelper.areItemsAndTagsEqual(stack, insertStack))) continue;
            return slot;
        }
        return emptySlot;
    }

    public static boolean areItemsAndTagsEqual(ItemStack stack1, ItemStack stack2) {
        return stack1.m_41619_() && stack2.m_41619_() || stack1.m_41720_() == stack2.m_41720_() && InventoryHandlerHelper.areItemStackTagsEqual(stack1, stack2);
    }

    public static boolean areItemStackTagsEqual(ItemStack stackA, ItemStack stackB) {
        if (!stackA.m_41619_() && !stackB.m_41619_()) {
            CompoundTag tagA = stackA.m_41783_();
            CompoundTag tagB = stackB.m_41783_();
            if ((tagA == null || tagA.m_128456_()) && tagB != null && !tagB.m_128456_()) {
                return false;
            }
            return (tagA == null || tagA.m_128456_() || tagA.equals((Object)stackB.m_41783_())) && stackA.areCapsCompatible((CapabilityProvider)stackB);
        }
        return false;
    }

    public static class ItemHandler
    extends ItemStackHandler {
        protected BlockEntity tileEntity;

        public ItemHandler(int size) {
            this(size, null);
        }

        public ItemHandler(int size, @Nullable BlockEntity tileEntity) {
            super(size);
            this.tileEntity = tileEntity;
        }

        public int[] getOutputSlots() {
            return OUTPUT_SLOTS;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (this.tileEntity != null) {
                this.tileEntity.m_6596_();
            }
        }

        public boolean isInputSlot(int slot) {
            return slot == 0 || slot == INPUT_SLOT[0] || slot == INPUT_SLOT[1] || slot == INPUT_SLOT[2] || slot == INPUT_SLOT[3];
        }

        public boolean isInsertableSlot(int slot) {
            return slot != 0 && slot != INPUT_SLOT[0] && slot != INPUT_SLOT[1] && slot != INPUT_SLOT[2] && slot != INPUT_SLOT[3] && slot != 21;
        }

        public boolean isContainerItem(Item item) {
            return item == Items.f_42590_;
        }

        public boolean isInputSlotItem(int slot, ItemStack item) {
            return slot == 0 && this.isContainerItem(item.m_41720_()) || slot == 21 && !this.isContainerItem(item.m_41720_());
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return this.isItemValid(slot, stack, true);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack, boolean fromAutomation) {
            if (this.isInputSlotItem(slot, stack)) {
                return true;
            }
            return !fromAutomation && this.isInsertableSlot(slot);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.extractItem(slot, amount, simulate, true);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate, boolean fromAutomation) {
            if (fromAutomation && this.isInputSlot(slot)) {
                return ItemStack.f_41583_;
            }
            return super.extractItem(slot, amount, simulate);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return this.insertItem(slot, stack, simulate, true);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate, boolean fromAutomation) {
            return super.insertItem(slot, stack, simulate);
        }

        public boolean addOutput(@Nonnull ItemStack stack) {
            int slot = InventoryHandlerHelper.getAvailableOutputSlot(this, stack, ((TieredCentrifugeBlockEntity)this.tileEntity).tier);
            if (slot > 0) {
                ItemStack existingStack = this.getStackInSlot(slot);
                if (existingStack.m_41619_()) {
                    this.setStackInSlot(slot, stack.m_41777_());
                } else {
                    existingStack.m_41769_(stack.m_41613_());
                }
                this.onContentsChanged(slot);
                return true;
            }
            return false;
        }

        public boolean canFitStacks(List<ItemStack> stacks) {
            ArrayList<Integer> usedSlots = new ArrayList<Integer>();
            for (ItemStack stack : stacks) {
                int slot = InventoryHandlerHelper.getAvailableOutputSlot(this, stack, usedSlots, ((TieredCentrifugeBlockEntity)this.tileEntity).tier);
                if (slot != 0) continue;
                return false;
            }
            return true;
        }

        public void deserializeNBT(CompoundTag nbt) {
            int size;
            int n = size = nbt.m_128425_("Size", 3) ? nbt.m_128451_("Size") : this.stacks.size();
            if (size < this.stacks.size()) {
                nbt.m_128405_("Size", this.stacks.size());
            }
            super.deserializeNBT(nbt);
        }
    }

    public static class FluidHandler
    extends FluidTank
    implements INBTSerializable<CompoundTag> {
        public FluidHandler(int capacity) {
            super(capacity);
        }

        public FluidHandler(int capacity, Predicate<FluidStack> validator) {
            super(capacity, validator);
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            this.fluid.writeToNBT(nbt);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)nbt);
        }
    }

    public static class UpgradeHandler
    extends ItemHandler {
        public UpgradeHandler(int size, BlockEntity tileEntity) {
            super(size, tileEntity);
        }

        @Override
        public boolean isInsertableSlot(int slot) {
            return false;
        }

        @Override
        public boolean isInputSlotItem(int slot, ItemStack item) {
            return item.m_41720_() instanceof UpgradeItem;
        }
    }
}

