/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.cclink.libs;

import dan200.computercraft.api.turtle.ITurtleAccess;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class RaycastingUtil {
    public static Optional<Entity> raycastEntity(Player player, double distance) {
        Vec3 lookVec;
        Vec3 endVec;
        Vec3 startVec;
        Level world = player.m_9236_();
        BlockHitResult blockHitResult = world.m_45547_(new ClipContext(startVec = player.m_146892_(), endVec = startVec.m_82549_(lookVec = player.m_20252_(1.0f).m_82490_(distance)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        double blockHitDistance = blockHitResult.m_82450_().m_82554_(startVec);
        if (blockHitDistance < distance) {
            endVec = blockHitResult.m_82450_();
        }
        AABB boundingBox = new AABB(startVec, endVec).m_82400_(1.0);
        Entity closestEntity = null;
        double closestDistance = distance;
        for (Entity entity : world.m_45933_((Entity)player, boundingBox)) {
            double entityDistance;
            AABB entityBoundingBox;
            Optional intersection;
            if (entity == player || !entity.m_6087_() || !(intersection = (entityBoundingBox = entity.m_20191_().m_82400_(0.3)).m_82371_(startVec, endVec)).isPresent() || !((entityDistance = startVec.m_82554_((Vec3)intersection.get())) < closestDistance)) continue;
            closestEntity = entity;
            closestDistance = entityDistance;
        }
        return Optional.ofNullable(closestEntity);
    }

    public static Map<String, Object> raycast(double reach, ITurtleAccess turtle, Direction dir) {
        double limitedReach = Math.min(5.0, Math.max(1.0, reach));
        BlockPos pos = turtle.getPosition();
        Level level = turtle.getLevel();
        Vec3 direction = Vec3.m_82528_((Vec3i)dir.m_122436_());
        Vec3 start = Vec3.m_82512_((Vec3i)pos).m_82549_(direction.m_82490_(0.5));
        Vec3 end = start.m_82549_(direction.m_82490_(limitedReach));
        BlockHitResult blockHit = level.m_45547_(new ClipContext(start, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, null));
        HashMap<String, Object> info = new HashMap<String, Object>();
        if (blockHit.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos hitPos = blockHit.m_82425_();
            Block blk = level.m_8055_(hitPos).m_60734_();
            info.put("id", ForgeRegistries.BLOCKS.getKey((Object)blk).toString());
            info.put("x", hitPos.m_123341_());
            info.put("y", hitPos.m_123342_());
            info.put("z", hitPos.m_123343_());
            info.put("distance", pos.m_252807_().m_82554_(hitPos.m_252807_()));
        }
        return info;
    }
}

