/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.cclink.libs;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.shared.util.NBTUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class LuaConverter {
    public static Map<String, Object> entityToLua(Entity entity) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("id", ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).toString());
        data.put("uuid", entity.m_20149_());
        data.put("name", entity.m_7755_().getString());
        data.put("tags", entity.m_19880_());
        return data;
    }

    public static Map<String, Object> animalToLua(Animal animal, ItemStack itemInHand) {
        Map<String, Object> data = LuaConverter.entityToLua((Entity)animal);
        data.put("baby", animal.m_6162_());
        data.put("inLove", animal.m_27593_());
        data.put("aggressive", animal.m_5912_());
        if (animal instanceof IForgeShearable) {
            IForgeShearable shareable = (IForgeShearable)animal;
            if (!itemInHand.m_41619_()) {
                data.put("shareable", shareable.isShearable(itemInHand, animal.m_9236_(), animal.m_20183_()));
            }
        }
        return data;
    }

    public static Map<String, Object> completeEntityToLua(Entity entity, ItemStack itemInHand) {
        if (entity instanceof Animal) {
            Animal animal = (Animal)entity;
            return LuaConverter.animalToLua(animal, itemInHand);
        }
        return LuaConverter.entityToLua(entity);
    }

    public static Map<String, Object> completeEntityWithPositionToLua(Entity entity, ItemStack itemInHand, BlockPos pos) {
        Map<String, Object> data = LuaConverter.completeEntityToLua(entity, itemInHand);
        data.put("x", entity.m_20185_() - (double)pos.m_123341_());
        data.put("y", entity.m_20186_() - (double)pos.m_123342_());
        data.put("z", entity.m_20189_() - (double)pos.m_123343_());
        return data;
    }

    public static Object posToObject(BlockPos pos) {
        if (pos == null) {
            return null;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>(3);
        map.put("x", pos.m_123341_());
        map.put("y", pos.m_123342_());
        map.put("z", pos.m_123343_());
        return map;
    }

    public static Map<String, Object> stackToObject(@NotNull ItemStack stack) {
        if (stack.m_41619_()) {
            return new HashMap<String, Object>();
        }
        Map<String, Object> map = LuaConverter.itemToObject(stack.m_41720_());
        CompoundTag nbt = stack.m_41777_().m_41784_();
        map.put("count", stack.m_41613_());
        map.put("displayName", stack.m_41611_().getString());
        map.put("maxStackSize", stack.m_41741_());
        map.put("nbt", NBTUtil.toLua((Tag)nbt));
        map.put("name", BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).toString());
        return map;
    }

    public static Map<String, Object> stackToObjectWithSlot(@NotNull ItemStack stack, int slot) {
        if (stack.m_41619_()) {
            return new HashMap<String, Object>();
        }
        Map<String, Object> map = LuaConverter.stackToObject(stack);
        map.put("slot", slot + 1);
        return map;
    }

    public static Map<String, Object> itemToObject(@NotNull Item item) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tags", LuaConverter.tagsToList(() -> item.m_204114_().m_203616_()));
        return map;
    }

    public static <T> List<String> tagsToList(@NotNull Supplier<Stream<TagKey<T>>> tags) {
        if (tags.get().findAny().isEmpty()) {
            return Collections.emptyList();
        }
        return tags.get().map(LuaConverter::tagToString).toList();
    }

    public static <T> String tagToString(@NotNull TagKey<T> tag) {
        return String.valueOf(tag.f_203867_().m_135782_()) + "/" + String.valueOf(tag.f_203868_());
    }

    public static BlockPos convertToBlockPos(Map<?, ?> table) throws LuaException {
        Number y;
        Number x;
        Object obj;
        block5: {
            block4: {
                if (!(table.containsKey("x") && table.containsKey("y") && table.containsKey("z"))) {
                    throw new LuaException("Table should be block position table");
                }
                obj = table.get("x");
                if (!(obj instanceof Number)) break block4;
                x = (Number)obj;
                obj = table.get("y");
                if (!(obj instanceof Number)) break block4;
                y = (Number)obj;
                obj = table.get("z");
                if (obj instanceof Number) break block5;
            }
            throw new LuaException("Table should be block position table");
        }
        Number z = (Number)obj;
        return new BlockPos(x.intValue(), y.intValue(), z.intValue());
    }

    public static BlockPos convertToBlockPos(BlockPos center, Map<?, ?> table) throws LuaException {
        BlockPos relative = LuaConverter.convertToBlockPos(table);
        return new BlockPos(center.m_123341_() + relative.m_123341_(), center.m_123342_() + relative.m_123342_(), center.m_123343_() + relative.m_123343_());
    }
}

