/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.cclink.item;

import com.awesoft.cclink.block.LinkTurtle.LinkTurtleBlockEntity;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerComputerRegistry;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.computer.inventory.ComputerMenuWithoutInventory;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.network.container.ContainerData;
import dan200.computercraft.shared.platform.PlatformHelper;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.HitResult;

public class LinkKeyItem
extends Item {
    public LinkKeyItem(Item.Properties pProperties) {
        super(pProperties);
    }

    private static void openImpl(Player player, ItemStack stack, boolean isTypingOnly, ServerComputer computer) {
        PlatformHelper.get().openMenu(player, stack.m_41786_(), (id, inventory, entity) -> new ComputerMenuWithoutInventory((MenuType)ModRegistry.Menus.COMPUTER.get(), id, inventory, p -> true, computer), (ContainerData)new ComputerContainerData(computer, stack));
    }

    private static int getSessionID(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128441_("SessionId") ? nbt.m_128451_("SessionId") : -1;
    }

    @Nullable
    public static UUID getInstanceID(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128403_("InstanceId") ? nbt.m_128342_("InstanceId") : null;
    }

    @Nullable
    public static ServerComputer getServerComputer(ServerComputerRegistry registry, ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        int sessionId = tag.m_128451_("SessionId");
        UUID instanceId = tag.m_128342_("InstanceId");
        if (instanceId != null) {
            return registry.get(sessionId, instanceId);
        }
        return null;
    }

    @Nullable
    public static ServerComputer getServerComputer(MinecraftServer server, ItemStack stack) {
        if (server != null) {
            return LinkKeyItem.getServerComputer(ServerContext.get((MinecraftServer)server).registry(), stack);
        }
        return null;
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        if (pContext.m_43723_().m_9236_().m_7702_(pContext.m_8083_()) instanceof LinkTurtleBlockEntity && pContext.m_43723_().m_20194_() != null) {
            BlockEntity blockEntity;
            MinecraftServer server = pContext.m_43723_().m_20194_();
            ServerComputerRegistry registry = ServerContext.get((MinecraftServer)server).registry();
            if (pContext.m_43723_().m_6047_() && (blockEntity = pContext.m_43725_().m_7702_(pContext.m_8083_())) instanceof LinkTurtleBlockEntity) {
                LinkTurtleBlockEntity tile = (LinkTurtleBlockEntity)blockEntity;
                ServerComputer computer = tile.getServerComputer();
                if (tile.getAccess().getOwningPlayer() == null) {
                    return InteractionResult.FAIL;
                }
                String ownerName = tile.getAccess().getOwningPlayer().getName();
                if (ownerName.equals(pContext.m_43723_().m_36316_().getName()) && computer != null) {
                    CompoundTag tag = pContext.m_43722_().m_41784_();
                    tag.m_128405_("SessionId", registry.getSessionID());
                    if (computer.getInstanceUUID() != null) {
                        tag.m_128362_("InstanceId", computer.getInstanceUUID());
                    } else {
                        tag.m_128362_("InstanceId", computer.register());
                    }
                    tag.m_128405_("computId", computer.getID());
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemstack = pPlayer.m_21120_(pUsedHand);
        if (pPlayer.m_6047_()) {
            HitResult hitResult = pPlayer.m_19907_(5.0, 0.0f, false);
            if (hitResult.m_6662_() == HitResult.Type.MISS) {
                CompoundTag tag = itemstack.m_41783_();
                if (tag != null) {
                    if (tag.m_128441_("SessionId")) {
                        tag.m_128473_("SessionId");
                    }
                    if (tag.m_128441_("InstanceId")) {
                        tag.m_128473_("InstanceId");
                    }
                    if (tag.m_128441_("computId")) {
                        tag.m_128473_("computId");
                    }
                }
                return InteractionResultHolder.m_19090_((Object)itemstack);
            }
        } else {
            try {
                ServerComputer computer = LinkKeyItem.getServerComputer(pPlayer.m_20194_(), itemstack);
                if (computer != null) {
                    if (!computer.isOn()) {
                        computer.turnOn();
                    }
                    LinkKeyItem.openImpl(pPlayer, pPlayer.m_21120_(pUsedHand), false, computer);
                    return InteractionResultHolder.m_19090_((Object)itemstack);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return InteractionResultHolder.m_19098_((Object)pPlayer.m_21120_(pUsedHand));
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            if (tag.m_128441_("computId")) {
                tooltip.add((Component)Component.m_237113_((String)("Linked to Id: " + tag.m_128451_("computId"))));
            } else {
                tooltip.add((Component)Component.m_237113_((String)"Not Linked"));
            }
        } else {
            tooltip.add((Component)Component.m_237113_((String)"Not Linked"));
        }
    }
}

