/*
 * Decompiled with CFR 0.152.
 */
package com.thunderbear06.menu;

import com.thunderbear06.ai.AndroidBrain;
import com.thunderbear06.inventory.HandContainer;
import com.thunderbear06.menu.MenuRegistry;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.inventory.AbstractComputerMenu;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import java.util.function.Predicate;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AndroidMenu
extends AbstractComputerMenu {
    public static final int BORDER = 8;
    public static final int PLAYER_START_Y = 134;
    public static final int PLAYER_START_X = 25;
    public static final int ANDROID_START_X = 192;

    public AndroidMenu(int id, Predicate<Player> canUse, ComputerFamily family, @Nullable ServerComputer computer, @Nullable ComputerContainerData containerData, Inventory playerInventory, SimpleContainer inventory, Container container) {
        super((MenuType)MenuRegistry.ANDROID.get(), id, canUse, family, computer, containerData);
        int x;
        int y;
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 3; ++x) {
                this.m_38897_(new Slot((Container)inventory, x + y * 3, 193 + x * 18, 135 + y * 18));
            }
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)playerInventory, x + y * 9 + 9, 25 + x * 18, 135 + y * 18));
            }
        }
        for (int x2 = 0; x2 < 9; ++x2) {
            this.m_38897_(new Slot((Container)playerInventory, x2, 25 + x2 * 18, 193));
        }
        this.m_38897_(new Slot(container, 0, 193, 193));
        this.m_38897_(new Slot(container, 1, 211, 193));
    }

    public static AndroidMenu ofBrain(int id, Inventory inventory, AndroidBrain brain) {
        return new AndroidMenu(id, player -> true, brain.getAndroid().getComputer().getFamily(), brain.getAndroid().getComputer().getOrCreateServerComputer(), null, inventory, brain.getAndroid().inventory, new HandContainer(brain.getAndroid()));
    }

    public static AndroidMenu ofData(int id, Inventory inv, ComputerContainerData data) {
        return new AndroidMenu(id, player -> true, data.family(), null, data, inv, new SimpleContainer(11), (Container)new SimpleContainer(2));
    }

    private ItemStack tryItemMerge(Player player, int slotNum, int firstSlot, int lastSlot, boolean reverse) {
        Slot slot = (Slot)this.f_38839_.get(slotNum);
        ItemStack originalStack = ItemStack.f_41583_;
        if (slot.m_6657_()) {
            ItemStack clickedStack = slot.m_7993_();
            originalStack = clickedStack.m_41777_();
            if (!this.m_38903_(clickedStack, firstSlot, lastSlot, reverse)) {
                return ItemStack.f_41583_;
            }
            if (clickedStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (clickedStack.m_41613_() != originalStack.m_41613_()) {
                slot.m_142406_(player, clickedStack);
            } else {
                return ItemStack.f_41583_;
            }
        }
        return originalStack;
    }

    public ItemStack m_7648_(Player player, int slot) {
        if (slot >= 0 && slot < 9) {
            return this.tryItemMerge(player, slot, 16, 45, true);
        }
        if (slot >= 9) {
            return this.tryItemMerge(player, slot, 0, 9, false);
        }
        return ItemStack.f_41583_;
    }
}

