/*
 * Decompiled with CFR 0.152.
 */
package com.thunderbear06.entity.render;

import com.thunderbear06.entity.android.AndroidEntity;
import com.thunderbear06.entity.android.CommandAndroidEntity;
import com.thunderbear06.entity.render.AndroidEmissiveRenderer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class AndroidEntityRenderer
extends HumanoidMobRenderer<AndroidEntity, PlayerModel<AndroidEntity>> {
    private final ResourceLocation androidNormal = new ResourceLocation("cc_androids", "textures/entity/android_normal.png");
    private final ResourceLocation androidAdvanced = new ResourceLocation("cc_androids", "textures/entity/android_advanced.png");
    private final ResourceLocation androidCommand = new ResourceLocation("cc_androids", "textures/entity/android_command.png");
    private final ResourceLocation core_emissive = new ResourceLocation("cc_androids", "textures/entity/emissive/core.png");
    private final ResourceLocation face_anger = new ResourceLocation("cc_androids", "textures/entity/emissive/face/anger.png");
    private final ResourceLocation face_annoyed = new ResourceLocation("cc_androids", "textures/entity/emissive/face/annoyed.png");
    private final ResourceLocation face_command = new ResourceLocation("cc_androids", "textures/entity/emissive/face/command.png");
    private final ResourceLocation face_happy = new ResourceLocation("cc_androids", "textures/entity/emissive/face/happy.png");
    private final ResourceLocation face_normal = new ResourceLocation("cc_androids", "textures/entity/emissive/face/normal.png");
    private final ResourceLocation face_sad = new ResourceLocation("cc_androids", "textures/entity/emissive/face/sad.png");
    private final ResourceLocation face_woozy = new ResourceLocation("cc_androids", "textures/entity/emissive/face/woozy.png");

    public AndroidEntityRenderer(EntityRendererProvider.Context context) {
        super(context, (HumanoidModel)new PlayerModel(context.m_174023_(ModelLayers.f_171162_), false), 0.5f);
        this.m_115326_(new AndroidEmissiveRenderer((RenderLayerParent)this){

            @Override
            public RenderType getEyesTexture(AndroidEntity entity) {
                if (entity.hasVariant()) {
                    return RenderType.m_110488_((ResourceLocation)AndroidEntityRenderer.this.getVariantTexture(entity.getVariant(), true));
                }
                return RenderType.m_110488_((ResourceLocation)AndroidEntityRenderer.this.core_emissive);
            }
        });
        this.m_115326_(new AndroidEmissiveRenderer((RenderLayerParent)this){

            @Override
            public RenderType getEyesTexture(AndroidEntity entity) {
                if (entity.hasVariant()) {
                    return null;
                }
                return RenderType.m_110488_(switch (entity.getFace()) {
                    case 0 -> {
                        if (entity instanceof CommandAndroidEntity) {
                            yield AndroidEntityRenderer.this.face_command;
                        }
                        yield AndroidEntityRenderer.this.face_normal;
                    }
                    case 1 -> AndroidEntityRenderer.this.face_anger;
                    case 2 -> AndroidEntityRenderer.this.face_annoyed;
                    case 3 -> AndroidEntityRenderer.this.face_happy;
                    case 4 -> AndroidEntityRenderer.this.face_sad;
                    case 5 -> AndroidEntityRenderer.this.face_woozy;
                    default -> null;
                });
            }

            @Override
            public Vec3 getColor(AndroidEntity entity) {
                return switch (entity.getComputer().getFamily()) {
                    default -> throw new IncompatibleClassChangeError();
                    case ComputerFamily.NORMAL -> new Vec3(1.0, 1.0, 1.0);
                    case ComputerFamily.ADVANCED -> new Vec3(1.5, 1.0, 1.0);
                    case ComputerFamily.COMMAND -> new Vec3(1.0, 0.0, 0.0);
                };
            }
        });
    }

    public ResourceLocation getTexture(AndroidEntity entity) {
        if (entity.hasVariant()) {
            return this.getVariantTexture(entity.getVariant(), false);
        }
        ComputerFamily family = entity.getComputer().family;
        if (family == ComputerFamily.ADVANCED) {
            return this.androidAdvanced;
        }
        if (family == ComputerFamily.COMMAND) {
            return this.androidCommand;
        }
        return this.androidNormal;
    }

    private ResourceLocation getVariantTexture(byte b, boolean emissive) {
        String path = emissive ? "textures/entity/emissive/variant/" : "textures/entity/variant/";
        String name = switch (b) {
            case 1 -> "android_kaylon.png";
            case 2 -> "android_pinky.png";
            default -> throw new IllegalArgumentException();
        };
        return new ResourceLocation("cc_androids", path + name);
    }
}

