/*
 * Decompiled with CFR 0.152.
 */
package com.thunderbear06.entity.player;

import com.mojang.authlib.GameProfile;
import com.thunderbear06.ai.AndroidBrain;
import dan200.computercraft.shared.platform.PlatformHelper;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndroidPlayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AndroidPlayer.class);
    private static final GameProfile DEFAULT_PROFILE = new GameProfile(UUID.fromString("0d0c4ca0-4ff1-11e4-916c-0800200c9a66"), "[ComputerCraft]");
    private final ServerPlayer player;

    public AndroidPlayer(ServerPlayer player) {
        this.player = player;
    }

    private static AndroidPlayer create(AndroidBrain brain) {
        ServerLevel world = (ServerLevel)brain.getAndroid().m_9236_();
        GameProfile profile = brain.getOwningPlayerProfile();
        AndroidPlayer player = new AndroidPlayer(PlatformHelper.get().createFakePlayer(world, AndroidPlayer.getProfile(profile != null ? profile : DEFAULT_PROFILE)));
        player.setState(brain);
        return player;
    }

    public static AndroidPlayer get(AndroidBrain brain) {
        AndroidPlayer player = brain.fakePlayer;
        if (player != null && player.player.m_36316_() == AndroidPlayer.getProfile(brain.getOwningPlayerProfile()) && player.player.m_9236_() == brain.getAndroid().m_9236_()) {
            player.setState(brain);
        } else {
            player = brain.fakePlayer = AndroidPlayer.create(brain);
        }
        return player;
    }

    public ServerPlayer player() {
        return this.player;
    }

    private void setState(AndroidBrain brain) {
        if (this.player.f_36096_ != this.player.f_36095_) {
            LOGGER.warn("Android has open container ({})", (Object)this.player.f_36096_);
            this.player.m_9230_();
        }
        this.setPosition(brain);
        this.loadHand(brain.getAndroid().m_21205_(), InteractionHand.MAIN_HAND);
        this.loadHand(brain.getAndroid().m_21206_(), InteractionHand.OFF_HAND);
    }

    private void setRotation(Vec3 rotation) {
        this.player.m_146922_((float)rotation.f_82480_);
        this.player.m_146926_((float)rotation.f_82479_);
    }

    public void setPosition(AndroidBrain brain) {
        this.setRotation(brain.getAndroid().m_20154_());
        Vec3 pos = brain.getAndroid().m_20182_();
        this.player.m_146884_(pos);
        this.player.f_19854_ = pos.m_7096_();
        this.player.f_19855_ = pos.m_7098_();
        this.player.f_19856_ = pos.m_7094_();
        this.player.f_19860_ = this.player.m_146909_();
        this.player.f_20885_ = this.player.f_19859_ = this.player.m_146908_();
        this.player.f_20886_ = this.player.f_19859_;
    }

    private static GameProfile getProfile(@Nullable GameProfile profile) {
        return profile != null && profile.isComplete() ? profile : DEFAULT_PROFILE;
    }

    public void loadHand(ItemStack stack, InteractionHand hand) {
        this.player.m_21008_(hand, stack);
    }
}

