/*
 * Decompiled with CFR 0.152.
 */
package com.thunderbear06.entity.android.frame;

import com.thunderbear06.CCAndroids;
import com.thunderbear06.entity.EntityRegistry;
import com.thunderbear06.entity.android.BaseAndroidEntity;
import com.thunderbear06.item.ItemRegistry;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class AndroidFrame
extends Mob {
    private static final EntityDataAccessor<Byte> BUILD_PROGRESS = SynchedEntityData.m_135353_(AndroidFrame.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> COMPONENTS_NEEDED = SynchedEntityData.m_135353_(AndroidFrame.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> INGOTS_NEEDED = SynchedEntityData.m_135353_(AndroidFrame.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> HAS_CORE = SynchedEntityData.m_135353_(AndroidFrame.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean isAdvanced = false;
    private long lastHitTime = 0L;

    public AndroidFrame(EntityType<? extends Mob> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BUILD_PROGRESS, (Object)0);
        this.f_19804_.m_135372_(COMPONENTS_NEEDED, (Object)CCAndroids.CONFIG.CompsForConstruction);
        this.f_19804_.m_135372_(INGOTS_NEEDED, (Object)CCAndroids.CONFIG.IngotsForConstruction);
        this.f_19804_.m_135372_(HAS_CORE, (Object)false);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack handStack = hand == InteractionHand.MAIN_HAND ? player.m_21205_() : player.m_21206_();
        Level world = player.m_9236_();
        if (handStack.m_150930_((Item)ItemRegistry.COMPONENTS.get()) && this.addComponents(world)) {
            this.onSuccess(handStack, player, hand);
            return InteractionResult.SUCCESS;
        }
        if ((handStack.m_150930_(Items.f_42416_) || handStack.m_150930_(Items.f_42417_)) && this.addPlates(world, handStack.m_150930_(Items.f_42417_))) {
            this.onSuccess(handStack, player, hand);
            return InteractionResult.SUCCESS;
        }
        if (handStack.m_150930_((Item)ItemRegistry.REDSTONE_REACTOR.get()) && this.insertCore(world)) {
            this.onSuccess(handStack, player, hand);
            return InteractionResult.SUCCESS;
        }
        if ((handStack.m_150930_((Item)ItemRegistry.ANDROID_CPU.get()) || handStack.m_150930_(Items.f_42116_)) && this.isReadyForCPU()) {
            this.insertCPU(handStack);
            this.onSuccess(handStack, player, hand);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void incrementProgress(int inc) {
        this.setBuildProgress((Byte)this.f_19804_.m_135370_(BUILD_PROGRESS) + inc);
    }

    private void setBuildProgress(int progress) {
        this.f_19804_.m_135381_(BUILD_PROGRESS, (Object)((byte)progress));
    }

    private void onSuccess(ItemStack stack, Player player, InteractionHand hand) {
        stack.m_41774_(1);
        player.m_21008_(hand, stack);
    }

    private boolean addComponents(Level world) {
        byte comps = this.getComponentsNeeded();
        if (comps <= 0) {
            return false;
        }
        float pitch = (float)this.m_217043_().m_216332_(10, 12) * 0.1f;
        comps = (byte)(comps - 1);
        this.f_19804_.m_135381_(COMPONENTS_NEEDED, (Object)comps);
        if (comps <= 0) {
            world.m_6269_(null, (Entity)this, SoundEvents.f_11671_, SoundSource.NEUTRAL, 1.0f, pitch);
        } else {
            world.m_6269_(null, (Entity)this, SoundEvents.f_12009_, SoundSource.NEUTRAL, 1.0f, pitch);
        }
        return true;
    }

    private boolean addPlates(Level world, boolean isGold) {
        if (this.getComponentsNeeded() > 0) {
            return false;
        }
        if (this.getIngotsNeeded() <= 0) {
            return false;
        }
        if (isGold && !this.isAdvanced) {
            if (this.getIngotsNeeded() < CCAndroids.CONFIG.IngotsForConstruction) {
                return false;
            }
            this.isAdvanced = true;
        }
        if (!isGold && this.isAdvanced) {
            return false;
        }
        float pitch = (float)this.m_217043_().m_216332_(10, 12) * 0.1f;
        byte ingots = (Byte)this.f_19804_.m_135370_(INGOTS_NEEDED);
        ingots = (byte)(ingots - 1);
        this.f_19804_.m_135381_(INGOTS_NEEDED, (Object)ingots);
        if (ingots == 0) {
            world.m_6269_(null, (Entity)this, SoundEvents.f_11671_, SoundSource.NEUTRAL, 1.0f, pitch);
        } else {
            world.m_6269_(null, (Entity)this, SoundEvents.f_12009_, SoundSource.NEUTRAL, 1.0f, pitch);
        }
        return true;
    }

    private boolean insertCore(Level world) {
        if (this.hasCore()) {
            return false;
        }
        this.f_19804_.m_135381_(HAS_CORE, (Object)true);
        world.m_6269_(null, (Entity)this, SoundEvents.f_11859_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        return true;
    }

    private boolean isReadyForCPU() {
        return this.getComponentsNeeded() == 0 && this.hasCore() && this.getIngotsNeeded() == 0;
    }

    private void insertCPU(ItemStack cpu) {
        ComputerFamily family;
        int computerID = -1;
        if (cpu.m_150930_(Items.f_42116_)) {
            family = ComputerFamily.COMMAND;
        } else {
            ComputerFamily computerFamily = family = this.isAdvanced ? ComputerFamily.ADVANCED : ComputerFamily.NORMAL;
        }
        if (cpu.m_41782_() && cpu.m_41783_().m_128441_("ComputerID")) {
            computerID = cpu.m_41783_().m_128451_("ComputerID");
        }
        this.finish(family, computerID);
    }

    private void finish(ComputerFamily family, int computerID) {
        BaseAndroidEntity android = switch (family) {
            case ComputerFamily.NORMAL -> (BaseAndroidEntity)((EntityType)EntityRegistry.ANDROID_ENTITY.get()).m_20615_(this.m_9236_());
            case ComputerFamily.ADVANCED -> (BaseAndroidEntity)((EntityType)EntityRegistry.ADVANCED_ANDROID_ENTITY.get()).m_20615_(this.m_9236_());
            case ComputerFamily.COMMAND -> (BaseAndroidEntity)((EntityType)EntityRegistry.COMMAND_ANDROID_ENTITY.get()).m_20615_(this.m_9236_());
            default -> throw new IllegalArgumentException("Unknown ComputerFamily " + family);
        };
        assert (android != null);
        android.m_20359_((Entity)this);
        android.getComputer().setComputerID(computerID);
        this.m_146870_();
        this.m_9236_().m_7967_((Entity)android);
        android.m_9236_().m_6269_(null, (Entity)android, SoundEvents.f_11736_, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    public byte getComponentsNeeded() {
        return (Byte)this.f_19804_.m_135370_(COMPONENTS_NEEDED);
    }

    public byte getIngotsNeeded() {
        return (Byte)this.f_19804_.m_135370_(INGOTS_NEEDED);
    }

    public boolean hasCore() {
        return (Boolean)this.f_19804_.m_135370_(HAS_CORE);
    }

    protected void m_7324_(Entity entity) {
    }

    public void m_7334_(Entity entity) {
    }

    public void m_147240_(double strength, double x, double z) {
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_9236_().m_5776_() || this.m_213877_()) {
            return false;
        }
        if (source.m_269533_(DamageTypeTags.f_268738_)) {
            this.m_6074_();
            return false;
        }
        if (this.m_6673_(source)) {
            return false;
        }
        if (source.m_269533_(DamageTypeTags.f_268415_)) {
            this.onBreak();
            this.m_6074_();
            return false;
        }
        if (!(source.m_7639_() instanceof Player)) {
            return false;
        }
        if (!((Player)source.m_7639_()).m_150110_().f_35938_) {
            return false;
        }
        if (source.m_19390_()) {
            this.m_6677_(source);
            this.m_6074_();
        } else {
            long l = this.m_9236_().m_46467_();
            if (l - this.lastHitTime > 5L) {
                this.m_9236_().m_7605_((Entity)this, (byte)32);
                this.m_146852_(GameEvent.f_223706_, source.m_7639_());
                this.lastHitTime = l;
            } else {
                this.onBreak();
            }
        }
        return true;
    }

    public void onBreak() {
        this.m_5907_();
        this.m_6074_();
    }

    public void m_6074_() {
        this.m_142687_(Entity.RemovalReason.KILLED);
        this.m_146850_(GameEvent.f_223707_);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_11666_;
    }

    protected void m_5907_() {
        int components_dropped = CCAndroids.CONFIG.CompsForConstruction - this.getComponentsNeeded();
        for (int i = 0; i < components_dropped; ++i) {
            this.m_19983_(new ItemStack((ItemLike)ItemRegistry.COMPONENTS.get()));
        }
        int ingots_dropped = CCAndroids.CONFIG.IngotsForConstruction - this.getIngotsNeeded();
        for (int j = 0; j < ingots_dropped; ++j) {
            this.m_19983_(new ItemStack((ItemLike)(this.isAdvanced ? Items.f_42417_ : Items.f_42416_)));
        }
        if (this.hasCore()) {
            this.m_19983_(new ItemStack((ItemLike)ItemRegistry.REDSTONE_REACTOR.get()));
        }
        this.m_19983_(new ItemStack((ItemLike)ItemRegistry.ANDROID_FRAME.get()));
    }

    public void m_7380_(CompoundTag nbt) {
        nbt.m_128344_("ComponentsNeeded", this.getComponentsNeeded());
        nbt.m_128344_("IngotsNeeded", this.getIngotsNeeded());
        nbt.m_128379_("IsAdvanced", this.isAdvanced);
        nbt.m_128379_("HasCore", this.hasCore());
        super.m_7380_(nbt);
    }

    public void m_7378_(CompoundTag nbt) {
        if (nbt.m_128441_("ComponentsNeeded")) {
            this.f_19804_.m_135381_(COMPONENTS_NEEDED, (Object)nbt.m_128445_("ComponentsNeeded"));
            this.f_19804_.m_135381_(INGOTS_NEEDED, (Object)nbt.m_128445_("IngotsNeeded"));
            this.f_19804_.m_135381_(HAS_CORE, (Object)nbt.m_128471_("HasCore"));
            this.isAdvanced = nbt.m_128471_("IsAdvanced");
        }
        super.m_7378_(nbt);
    }
}

