/*
 * Decompiled with CFR 0.152.
 */
package com.thunderbear06.entity.android;

import com.thunderbear06.AndroidPlatformHelper;
import com.thunderbear06.ai.AndroidBrain;
import com.thunderbear06.computer.AndroidComputerContainer;
import com.thunderbear06.computer.EntityComputer;
import com.thunderbear06.entity.player.AndroidPlayer;
import com.thunderbear06.inventory.AndroidInventory;
import com.thunderbear06.item.ItemRegistry;
import com.thunderbear06.tags.TagRegistry;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class BaseAndroidEntity
extends PathfinderMob {
    public AndroidBrain brain;
    public final AndroidInventory inventory;
    protected final AndroidComputerContainer computerContainer;
    protected final int maxFuel = 10000;
    protected int fuel = 0;
    public boolean isOn = false;

    protected BaseAndroidEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        this.inventory = new AndroidInventory(9);
        this.computerContainer = new AndroidComputerContainer(this);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        return entityData;
    }

    public void m_8107_() {
        super.m_8107_();
        this.brain.getModules().interactionModule.tickDoorInteraction();
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_21203_();
        if (this.m_9236_().m_5776_()) {
            return;
        }
        this.computerContainer.onTick();
        if (this.f_19797_ % 20 > 0) {
            return;
        }
        if (this.isIdle()) {
            this.updatePeripherals();
        } else {
            this.consumeFuel();
        }
    }

    protected boolean isIdle() {
        return true;
    }

    public void shutdown() {
        this.isOn = false;
        this.brain.onShutdown();
    }

    private void updatePeripherals() {
        if (this.computerContainer.getComputerID() < 0 || !this.computerContainer.isOn) {
            return;
        }
        for (Direction direction : Direction.m_235666_().toList()) {
            if (direction == Direction.UP || this.getComputer().hasUpgrade(ComputerSide.valueOf((int)direction.ordinal()))) continue;
            IPeripheral peripheral = AndroidPlatformHelper.get().getPeripheral((ServerLevel)this.m_9236_(), this.m_20183_().m_121945_(direction), direction, () -> this.computerContainer.setPeripheral(ComputerSide.valueOf((int)direction.m_122411_()), null));
            this.computerContainer.setPeripheral(ComputerSide.valueOf((int)direction.m_122411_()), peripheral);
        }
    }

    public void m_21008_(InteractionHand hand, ItemStack stack) {
        super.m_21008_(hand, stack);
        this.getComputer().onHandItemChanged(hand);
        if (this.getComputer().isOn) {
            this.getComputer().getUpgradePeripherals();
        }
    }

    protected void consumeFuel() {
        if (this.fuel > 0) {
            --this.fuel;
        }
    }

    private int getFuelMultiplier(ItemStack stack) {
        if (stack.m_204117_(TagRegistry.MINOR_ANDROID_FUEL)) {
            return 10;
        }
        if (stack.m_204117_(TagRegistry.MEDIUM_ANDROID_FUEL)) {
            return 80;
        }
        if (stack.m_204117_(TagRegistry.MAJOR_ANDROID_FUEL)) {
            return 800;
        }
        return 0;
    }

    public boolean addFuel(int min, ItemStack stack) {
        int mult = this.getFuelMultiplier(stack);
        if (mult <= 0) {
            return false;
        }
        int fuelAvailable = Math.min(min, stack.m_41613_());
        int fuelNeeded = this.maxFuel - this.fuel;
        int fuelUsed = Math.min(fuelAvailable, fuelNeeded);
        this.setFuel(Math.min(this.fuel + fuelUsed * mult, this.maxFuel));
        stack.m_41774_(fuelUsed);
        return true;
    }

    public int getFuel() {
        return this.fuel;
    }

    public void setFuel(int newFuel) {
        this.fuel = newFuel;
    }

    public boolean hasFuel() {
        return this.fuel > 0;
    }

    public AndroidComputerContainer getComputer() {
        return this.computerContainer;
    }

    public MethodResult pickupGroundItem(ItemEntity itemEntity) {
        if (itemEntity.m_213877_()) {
            return MethodResult.of((Object)"Item does not exist");
        }
        if (itemEntity.m_32055_().m_41619_()) {
            return MethodResult.of((Object)"Cannot pickup item. Item is broken (Contact mod author)");
        }
        if (itemEntity.m_32063_()) {
            return MethodResult.of((Object)"Unable to pickup item");
        }
        this.m_7581_(itemEntity);
        return MethodResult.of();
    }

    public MethodResult dropHandItem() {
        ItemStack itemStack = this.m_21205_();
        if (itemStack.m_41619_()) {
            return MethodResult.of((Object)"Hand is empty");
        }
        this.m_19983_(itemStack);
        this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        return MethodResult.of();
    }

    protected void m_5907_() {
        this.dropCPU();
        this.m_19983_(((Item)ItemRegistry.REDSTONE_REACTOR.get()).m_7968_());
        for (ItemStack stack : this.inventory.m_19195_()) {
            this.m_19983_(stack);
        }
    }

    private void dropCPU() {
        boolean isCommand = this.computerContainer.getFamily() == ComputerFamily.COMMAND;
        ItemStack stack = new ItemStack((ItemLike)(isCommand ? Items.f_42116_ : (ItemLike)ItemRegistry.ANDROID_CPU.get()));
        if (this.computerContainer.getComputerID() >= 0) {
            CompoundTag compound = new CompoundTag();
            compound.m_128405_("ComputerID", this.computerContainer.getComputerID());
            stack.m_41751_(compound);
        }
        this.m_19983_(stack);
    }

    public ItemStack m_255207_(ItemStack stack) {
        EquipmentSlot equipmentSlot = EquipmentSlot.MAINHAND;
        ItemStack itemStack = this.m_6844_(equipmentSlot);
        if (this.m_7252_(stack)) {
            if (!itemStack.m_41619_()) {
                this.m_19983_(itemStack);
            }
            this.m_21468_(equipmentSlot, stack);
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack stashStack(ItemStack stack, int index) {
        ItemStack storedStack = this.inventory.m_8020_(index);
        if (storedStack.m_41619_()) {
            this.inventory.m_6836_(index, stack);
            return ItemStack.f_41583_;
        }
        if (storedStack.m_150930_(stack.m_41720_())) {
            int space = storedStack.m_41741_() - storedStack.m_41613_();
            int transfer = Math.min(stack.m_41613_(), space);
            storedStack.m_41769_(transfer);
            stack.m_41774_(transfer);
        }
        return stack.m_41619_() ? ItemStack.f_41583_ : stack;
    }

    public ItemStack getStashItem(int index, boolean remove) {
        ItemStack storedStack = this.inventory.m_8020_(index);
        if (remove) {
            this.inventory.m_6836_(index, ItemStack.f_41583_);
        }
        return storedStack;
    }

    public void swapOffHandStack() {
        ItemStack mainHandStack = this.m_21205_().m_41777_();
        this.m_21008_(InteractionHand.MAIN_HAND, this.m_21206_().m_41777_());
        this.m_21008_(InteractionHand.OFF_HAND, mainHandStack);
    }

    @Nullable
    public MethodResult canStash(ItemStack itemStack, int index) {
        if (index < 0 || index > this.inventory.m_6643_() - 1) {
            return MethodResult.of((Object)String.format("Index must be between 0 and %d", this.inventory.m_6643_()));
        }
        ItemStack storedStack = this.inventory.m_8020_(index);
        if (!storedStack.m_41619_() && !ItemStack.m_150942_((ItemStack)storedStack, (ItemStack)itemStack)) {
            return MethodResult.of((Object)"Index is occupied by another item stack!");
        }
        return null;
    }

    public void sendChatMessage(String msg) {
        if (this.m_20194_() == null) {
            return;
        }
        AndroidPlayer player = AndroidPlayer.get(this.brain);
        this.m_20194_().m_6846_().m_243049_(PlayerChatMessage.m_247306_((String)msg), player.player(), ChatType.m_240980_((ResourceKey)ChatType.f_130598_, (Entity)this));
    }

    public void readChatMessage(String msg, String senderName, UUID senderUUID) {
        if (!this.isOn) {
            return;
        }
        EntityComputer computer = this.getComputer().getServerComputer();
        if (computer == null) {
            return;
        }
        computer.queueEvent("onChatMessage", new Object[]{msg, senderName, senderUUID.toString()});
    }

    public void m_7380_(CompoundTag nbt) {
        nbt.m_128365_("Items", (Tag)this.inventory.toNbtCompound());
        nbt.m_128405_("Fuel", this.getFuel());
        CompoundTag computerCompound = new CompoundTag();
        this.computerContainer.writeNbt(computerCompound);
        this.brain.writeNbt(computerCompound);
        nbt.m_128365_("ComputerEntity", (Tag)computerCompound);
        super.m_7380_(nbt);
    }

    public void m_7378_(CompoundTag nbt) {
        this.inventory.fromNbtCompound(nbt.m_128469_("Items"));
        if (nbt.m_128441_("Fuel")) {
            this.setFuel(nbt.m_128451_("Fuel"));
        }
        if (nbt.m_128441_("ComputerEntity")) {
            CompoundTag computerCompound = nbt.m_128469_("ComputerEntity");
            this.computerContainer.readNbt(computerCompound);
            this.brain.readNbt(computerCompound);
        }
        super.m_7378_(nbt);
    }

    public boolean m_8023_() {
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268515_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    protected void m_142540_(MobEffectInstance effect, @Nullable Entity source) {
    }

    protected void m_141973_(MobEffectInstance effect, boolean reapplyEffect, @Nullable Entity source) {
    }

    public boolean m_6040_() {
        return true;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
        EntityComputer computer = this.computerContainer.getServerComputer();
        if (computer != null) {
            computer.close();
        }
    }

    public double getEntitySearchRadius() {
        return 10.0;
    }

    public int getBlockSearchRadius() {
        return 10;
    }
}

