/*
 * Decompiled with CFR 0.152.
 */
package com.thunderbear06.entity.android;

import com.thunderbear06.CCAndroids;
import com.thunderbear06.ai.AndroidBrain;
import com.thunderbear06.ai.AndroidLookAtEntityGoal;
import com.thunderbear06.entity.EntityRegistry;
import com.thunderbear06.entity.android.BaseAndroidEntity;
import com.thunderbear06.entity.android.frame.AndroidFrame;
import com.thunderbear06.item.ItemRegistry;
import com.thunderbear06.sounds.SoundRegistry;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AndroidEntity
extends BaseAndroidEntity {
    private static final EntityDataAccessor<Boolean> IS_LOCKED = SynchedEntityData.m_135353_(AndroidEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> VARIANT = SynchedEntityData.m_135353_(AndroidEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> FACE = SynchedEntityData.m_135353_(AndroidEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);

    public AndroidEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.brain = new AndroidBrain(this);
        this.computerContainer.setFamily(ComputerFamily.NORMAL);
        this.initAndroidGoals();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_LOCKED, (Object)false);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(FACE, (Object)0);
    }

    public static AttributeSupplier.Builder createAndroidAttributes() {
        return AndroidEntity.m_21552_().m_22268_(Attributes.f_22276_, (double)CCAndroids.CONFIG.AndroidMaxHealth).m_22268_(Attributes.f_22281_, (double)CCAndroids.CONFIG.AndroidDamage).m_22268_(Attributes.f_22279_, (double)CCAndroids.CONFIG.AndroidSpeed).m_22268_(Attributes.f_22284_, (double)CCAndroids.CONFIG.AndroidArmor);
    }

    protected void initAndroidGoals() {
        this.f_21345_.m_25352_(0, (Goal)new AndroidLookAtEntityGoal(this, Player.class, 10.0f));
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.hasFuel()) {
            this.brain.getTaskManager().tick();
        } else if (!this.m_21573_().m_26571_()) {
            this.m_21573_().m_26573_();
        }
    }

    @Override
    protected boolean isIdle() {
        return this.brain.getTaskManager().isIdle();
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.isLocked() && !this.brain.isOwningPlayer(player)) {
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12011_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            player.m_5661_((Component)Component.m_237115_((String)"entity.cc_androids.android.locked"), true);
            return InteractionResult.FAIL;
        }
        if (player.m_6144_()) {
            player.m_21008_(InteractionHand.MAIN_HAND, this.swapHandStack(player.m_21120_(hand)));
            return InteractionResult.SUCCESS;
        }
        ItemStack playerHandStack = player.m_21120_(hand);
        InteractionResult itemUseResult = this.handleItemUse(playerHandStack);
        if (itemUseResult != null) {
            return itemUseResult;
        }
        if (!this.m_9236_().m_5776_()) {
            if (playerHandStack.m_150930_(Items.f_42109_) && this.brain.isOwningPlayer(player)) {
                this.setLocked(!this.isLocked());
                return InteractionResult.SUCCESS;
            }
            if (this.brain.getOwningPlayerProfile() == null) {
                this.brain.setOwningPlayer(player.m_36316_());
            }
            this.getComputer().openComputer((ServerPlayer)player);
        }
        return InteractionResult.CONSUME;
    }

    private InteractionResult handleItemUse(ItemStack stack) {
        if (stack.m_150930_((Item)ItemRegistry.WRENCH.get())) {
            return InteractionResult.PASS;
        }
        if (stack.m_150930_((Item)ItemRegistry.COMPONENTS.get())) {
            this.repair(stack);
            return InteractionResult.SUCCESS;
        }
        if (stack.m_150930_(Items.f_42490_)) {
            this.setVariant((byte)1);
            return InteractionResult.SUCCESS;
        }
        if (stack.m_150930_(Items.f_42489_)) {
            this.setVariant((byte)2);
            return InteractionResult.SUCCESS;
        }
        return null;
    }

    public boolean isLocked() {
        return (Boolean)this.f_19804_.m_135370_(IS_LOCKED);
    }

    public void setLocked(boolean locked) {
        this.f_19804_.m_135381_(IS_LOCKED, (Object)locked);
    }

    public byte getVariant() {
        return (Byte)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(byte variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public boolean hasVariant() {
        return this.getVariant() > 0;
    }

    public void setFace(String faceName) {
        byte face = switch (faceName) {
            case "angry" -> 1;
            case "annoyed" -> 2;
            case "happy" -> 3;
            case "sad" -> 4;
            case "woozy" -> 5;
            default -> 0;
        };
        this.f_19804_.m_135381_(FACE, (Object)face);
    }

    public byte getFace() {
        return (Byte)this.f_19804_.m_135370_(FACE);
    }

    public void deconstruct() {
        super.m_5907_();
        this.dropComponents(true);
        this.dropIngots(true);
        AndroidFrame frame = (AndroidFrame)this.m_21406_((EntityType)EntityRegistry.ANDROID_FRAME_ENTITY.get(), false);
        frame.m_20359_((Entity)this);
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11665_, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    protected ItemStack swapHandStack(ItemStack stack) {
        ItemStack heldStack = this.m_21205_();
        if (stack.m_204117_(ItemTags.f_13149_)) {
            this.spawnHearts();
        }
        this.m_21008_(InteractionHand.MAIN_HAND, stack);
        return heldStack;
    }

    public boolean repair(ItemStack stack) {
        if (this.m_21223_() < this.m_21233_()) {
            this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12009_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.m_5634_(5.0f);
            stack.m_41774_(1);
            return true;
        }
        return false;
    }

    private void spawnHearts() {
        double d = this.f_19796_.m_188583_() * 0.02;
        double e = this.f_19796_.m_188583_() * 0.02;
        double f = this.f_19796_.m_188583_() * 0.02;
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d, e, f);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.ANDROID_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)SoundRegistry.ANDROID_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.ANDROID_DEATH.get();
    }

    @Override
    protected void m_5907_() {
        super.m_5907_();
        this.dropIngots(false);
        this.dropComponents(false);
    }

    protected void dropIngots(boolean full) {
        this.m_19983_(Items.f_42416_.m_7968_().m_255036_((int)((double)CCAndroids.CONFIG.IngotsForConstruction * (full ? 1.0 : (double)CCAndroids.CONFIG.IngotsDroppedOnDeathPercentage))));
    }

    protected void dropComponents(boolean full) {
        this.m_19983_(((Item)ItemRegistry.COMPONENTS.get()).m_7968_().m_255036_((int)((double)CCAndroids.CONFIG.CompsForConstruction * (full ? 1.0 : (double)CCAndroids.CONFIG.CompsDroppedOnDeathPercentage))));
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128344_("Variant", this.getVariant());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.f_19804_.m_135381_(VARIANT, (Object)nbt.m_128445_("Variant"));
    }
}

