/*
 * Decompiled with CFR 0.152.
 */
package com.thunderbear06.entity;

import com.thunderbear06.CCAndroids;
import com.thunderbear06.entity.android.AdvancedAndroidEntity;
import com.thunderbear06.entity.android.AndroidEntity;
import com.thunderbear06.entity.android.CommandAndroidEntity;
import com.thunderbear06.entity.android.RogueDroidEntity;
import com.thunderbear06.entity.android.frame.AndroidFrame;
import dev.architectury.registry.level.biome.BiomeModifications;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;

public class EntityRegistry {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((String)"cc_androids", (ResourceKey)Registries.f_256939_);
    public static final RegistrySupplier<EntityType<AndroidEntity>> ANDROID_ENTITY = ENTITY_TYPES.register("android", () -> EntityType.Builder.m_20704_(AndroidEntity::new, (MobCategory)MobCategory.MISC).m_20712_("android"));
    public static final RegistrySupplier<EntityType<AdvancedAndroidEntity>> ADVANCED_ANDROID_ENTITY = ENTITY_TYPES.register("advanced_android", () -> EntityType.Builder.m_20704_(AdvancedAndroidEntity::new, (MobCategory)MobCategory.MISC).m_20712_("advanced_android"));
    public static final RegistrySupplier<EntityType<CommandAndroidEntity>> COMMAND_ANDROID_ENTITY = ENTITY_TYPES.register("command_android", () -> EntityType.Builder.m_20704_(CommandAndroidEntity::new, (MobCategory)MobCategory.MISC).m_20712_("command_android"));
    public static final RegistrySupplier<EntityType<AndroidFrame>> ANDROID_FRAME_ENTITY = ENTITY_TYPES.register("unfinished_android", () -> EntityType.Builder.m_20704_(AndroidFrame::new, (MobCategory)MobCategory.MISC).m_20712_("android_frame"));
    public static final RegistrySupplier<EntityType<RogueDroidEntity>> ROGUE_ANDROID_ENTITY = ENTITY_TYPES.register("rogue_android", () -> EntityType.Builder.m_20704_(RogueDroidEntity::new, (MobCategory)MobCategory.MONSTER).m_20712_("rogue_android"));

    public static void register() {
        ENTITY_TYPES.register();
        EntityRegistry.registerAttributes();
        EntityRegistry.registerSpawns();
        CCAndroids.LOGGER.info("Registered Entities");
    }

    private static void registerAttributes() {
        EntityAttributeRegistry.register(ANDROID_ENTITY, AndroidEntity::createAndroidAttributes);
        EntityAttributeRegistry.register(ADVANCED_ANDROID_ENTITY, AdvancedAndroidEntity::createAndroidAttributes);
        EntityAttributeRegistry.register(COMMAND_ANDROID_ENTITY, CommandAndroidEntity::createAndroidAttributes);
        EntityAttributeRegistry.register(ROGUE_ANDROID_ENTITY, RogueDroidEntity::createAndroidAttributes);
        EntityAttributeRegistry.register(ANDROID_FRAME_ENTITY, Mob::m_21552_);
    }

    private static void registerSpawns() {
        BiomeModifications.addProperties(context -> !context.hasTag(BiomeTags.f_207603_), (context, properties) -> properties.getSpawnProperties().addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)ROGUE_ANDROID_ENTITY.get(), 1, 1, 1)));
    }
}

