/*
 * Decompiled with CFR 0.152.
 */
package com.thunderbear06.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import dev.architectury.platform.Platform;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"ModConfiguration");

    public static <T extends ConfigState> T loadConfig(String modID, T state) {
        Path configPath = ConfigLoader.getPath(modID);
        if (!Files.exists(configPath, LinkOption.NOFOLLOW_LINKS)) {
            ConfigLoader.createConfig(configPath, state);
        }
        state = ConfigLoader.readConfig(configPath, state.getClass());
        return state;
    }

    private static Path getPath(String modID) {
        return Platform.getConfigFolder().resolve(modID + ".json");
    }

    private static <T extends ConfigState> void createConfig(Path configPath, T state) {
        try {
            Files.createFile(configPath, new FileAttribute[0]);
            ConfigLoader.writeConfig(configPath, state);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create config file: {}", (Object)e.getLocalizedMessage());
        }
    }

    private static <T extends ConfigState> void writeConfig(Path configPath, T state) {
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson(state);
            Files.writeString(configPath, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write config file: {}", (Object)e.getLocalizedMessage());
        }
    }

    private static <T extends ConfigState> T readConfig(Path configPath, Class<? extends ConfigState> clazz) {
        try {
            Gson gson = new Gson();
            JsonReader reader = new JsonReader((Reader)Files.newBufferedReader(configPath));
            return (T)((ConfigState)gson.fromJson(reader, clazz));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load config file: " + e.getLocalizedMessage());
        }
    }

    public static interface ConfigState {
    }
}

