/*
 * Decompiled with CFR 0.152.
 */
package com.thunderbear06.computer;

import com.thunderbear06.CCAndroids;
import com.thunderbear06.ai.AndroidBrain;
import com.thunderbear06.component.ComputerComponents;
import com.thunderbear06.computer.EntityComputer;
import com.thunderbear06.computer.peripherals.DummyPocket;
import com.thunderbear06.entity.android.BaseAndroidEntity;
import com.thunderbear06.menu.AndroidMenu;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.network.container.ContainerData;
import dan200.computercraft.shared.platform.PlatformHelper;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AndroidComputerContainer {
    private final BaseAndroidEntity android;
    public Component label = Component.m_237115_((String)"entity.cc_androids.android");
    public boolean isOn = false;
    public boolean fresh = false;
    @Nullable
    private UUID instanceID = null;
    private int computerID = -1;
    private boolean startOn = false;
    public ComputerFamily family;
    private UpgradeData<IPocketUpgrade> leftUpgrade;
    private UpgradeData<IPocketUpgrade> rightUpgrade;
    private final DummyPocket dummyPocket;

    public AndroidComputerContainer(BaseAndroidEntity android) {
        this.android = android;
        this.dummyPocket = new DummyPocket(android);
    }

    public void onTick() {
        if (this.computerID < 0 && !this.startOn) {
            return;
        }
        EntityComputer computer = this.getOrCreateServerComputer();
        if (this.startOn) {
            this.turnOn(computer);
            this.startOn = false;
        }
        this.fresh = false;
        this.computerID = computer.getID();
        this.updateOwnerLabel(computer);
        this.tickPeripherals();
        computer.keepAlive();
        if (!this.isOn && this.android.isOn) {
            this.android.shutdown();
        }
    }

    public void turnOn(ServerComputer computer) {
        computer.turnOn();
        this.computerID = computer.getID();
        this.android.isOn = true;
        this.isOn = true;
        this.onHandItemChanged(InteractionHand.MAIN_HAND);
        this.onHandItemChanged(InteractionHand.OFF_HAND);
        this.getUpgradePeripherals();
    }

    public void openComputer(ServerPlayer player) {
        EntityComputer computer = this.getOrCreateServerComputer();
        if (!this.isOn) {
            this.turnOn(computer);
        }
        PlatformHelper.get().openMenu((Player)player, this.label, (syncId, playerInventory, player1) -> AndroidMenu.ofBrain(syncId, playerInventory, this.getBrain()), (ContainerData)new ComputerContainerData((ServerComputer)computer, ItemStack.f_41583_));
    }

    protected void updateOwnerLabel(ServerComputer computer) {
        String computerLabel = computer.getLabel();
        if (!this.label.toString().equals(computerLabel)) {
            this.label = computerLabel == null || computerLabel.isEmpty() ? Component.m_237115_((String)"entity.cc_androids.android") : Component.m_237113_((String)computerLabel);
            this.android.m_6593_(this.label);
        }
    }

    public final EntityComputer getOrCreateServerComputer() {
        MinecraftServer server = this.android.m_9236_().m_7654_();
        if (server == null) {
            throw new IllegalStateException("Cannot access server computer on the client.");
        }
        EntityComputer computer = (EntityComputer)ServerContext.get((MinecraftServer)server).registry().get(this.instanceID);
        if (computer == null) {
            if (this.computerID < 0) {
                this.computerID = ComputerCraftAPI.createUniqueNumberedSaveDir((MinecraftServer)server, (String)"computer");
            }
            computer = this.createComputer(this.computerID);
            this.instanceID = computer.register();
            this.fresh = true;
        }
        return computer;
    }

    public void setPeripheral(ComputerSide side, IPeripheral peripheral) {
        EntityComputer computer = this.getServerComputer();
        if (computer == null) {
            CCAndroids.LOGGER.error("Failed to set peripheral of type {} on side {} of computer container owned by {}. Reason: Failed to get ServerComputer (It was null)", new Object[]{peripheral.getType(), side.getName(), this.android.m_7755_()});
            return;
        }
        computer.setPeripheral(side, peripheral);
    }

    public boolean isOn() {
        EntityComputer computer = this.getServerComputer();
        return computer != null && computer.isOn();
    }

    public ComputerFamily getFamily() {
        return this.family;
    }

    public int getComputerID() {
        return this.computerID;
    }

    public void setFamily(ComputerFamily family) {
        this.family = family;
    }

    public void setComputerID(int id) {
        this.computerID = id;
    }

    public AndroidBrain getBrain() {
        return this.android.brain;
    }

    protected EntityComputer createComputer(int id) {
        ServerComputer.Properties properties = ServerComputer.properties((int)id, (ComputerFamily)this.getFamily()).addComponent(ComputerComponents.ANDROID_COMPUTER, (Object)this.android.brain).label(this.label.toString()).terminalSize(39, 13);
        return new EntityComputer((ServerLevel)this.android.m_9236_(), this.android, properties);
    }

    @Nullable
    public EntityComputer getServerComputer() {
        return !this.android.m_9236_().f_46443_ && this.android.m_9236_().m_7654_() != null ? (EntityComputer)ServerContext.get((MinecraftServer)this.android.m_9236_().m_7654_()).registry().get(this.instanceID) : null;
    }

    public void writeNbt(CompoundTag computerCompound) {
        computerCompound.m_128379_("StartOn", this.startOn);
        computerCompound.m_128405_("ComputerID", this.getComputerID());
    }

    public void readNbt(CompoundTag computerCompound) {
        this.startOn = computerCompound.m_128471_("StartOn");
        if (computerCompound.m_128441_("ComputerID")) {
            this.setComputerID(computerCompound.m_128451_("ComputerID"));
        }
    }

    public void getUpgradePeripherals() {
        this.setPeripheral(ComputerSide.LEFT, this.leftUpgrade == null ? null : ((IPocketUpgrade)this.leftUpgrade.upgrade()).createPeripheral((IPocketAccess)this.dummyPocket));
        this.setPeripheral(ComputerSide.RIGHT, this.rightUpgrade == null ? null : ((IPocketUpgrade)this.rightUpgrade.upgrade()).createPeripheral((IPocketAccess)this.dummyPocket));
    }

    private void tickPeripherals() {
        EntityComputer computer = this.getServerComputer();
        assert (computer != null);
        if (this.leftUpgrade != null) {
            ((IPocketUpgrade)this.leftUpgrade.upgrade()).update((IPocketAccess)this.dummyPocket, computer.getPeripheral(ComputerSide.LEFT));
        }
        if (this.rightUpgrade != null) {
            ((IPocketUpgrade)this.rightUpgrade.upgrade()).update((IPocketAccess)this.dummyPocket, computer.getPeripheral(ComputerSide.RIGHT));
        }
    }

    public boolean hasUpgrade(ComputerSide side) {
        return side == ComputerSide.LEFT && this.leftUpgrade != null || side == ComputerSide.RIGHT && this.rightUpgrade != null;
    }

    public void onHandItemChanged(InteractionHand hand) {
        ItemStack handItem = this.android.m_21120_(hand);
        if (hand == InteractionHand.OFF_HAND) {
            this.leftUpgrade = this.dummyPocket.createUpgrade(handItem);
            return;
        }
        this.rightUpgrade = this.dummyPocket.createUpgrade(handItem);
    }
}

