/*
 * Decompiled with CFR 0.152.
 */
package com.thunderbear06.ai.modules;

import com.thunderbear06.ai.AndroidBrain;
import com.thunderbear06.ai.modules.AbstractAndroidModule;
import com.thunderbear06.entity.android.BaseAndroidEntity;
import com.thunderbear06.entity.player.AndroidPlayer;
import dan200.computercraft.api.lua.LuaException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SensorModule
extends AbstractAndroidModule {
    private final double entitySearchRadius;
    private final int blockSearchRadius;

    public SensorModule(BaseAndroidEntity android, AndroidBrain brain, double searchRadius, int blockSearchRadius) {
        super(android, brain);
        this.entitySearchRadius = searchRadius;
        this.blockSearchRadius = blockSearchRadius;
    }

    public List<HashMap<String, Object>> getMobs(@Nullable String type) {
        ArrayList<HashMap<String, Object>> result = new ArrayList<HashMap<String, Object>>();
        this.android.m_9236_().m_6443_(LivingEntity.class, this.android.m_20191_().m_82400_(this.entitySearchRadius), this.getTypePredicate(type)).forEach(entity -> {
            try {
                result.add(this.collectEntityInfo((Entity)entity));
            }
            catch (LuaException luaException) {
                // empty catch block
            }
        });
        return result;
    }

    public HashMap<String, Object> getClosestMobOfType(@Nullable String type) throws LuaException {
        LivingEntity livingEntity;
        BlockPos pos = this.android.m_20183_();
        LivingEntity entity = this.android.m_9236_().m_45963_(LivingEntity.class, TargetingConditions.f_26872_.m_26888_(this.getTypePredicate(type)), (LivingEntity)this.android, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123341_(), this.android.m_20191_().m_82400_(this.entitySearchRadius));
        if (entity == null || entity instanceof LivingEntity && (livingEntity = entity).m_21224_()) {
            return new HashMap<String, Object>();
        }
        return this.collectEntityInfo((Entity)entity);
    }

    public HashMap<String, Object> getClosestPlayer() throws LuaException {
        ServerPlayer player = (ServerPlayer)this.android.m_9236_().m_45930_((Entity)this.android, 100.0);
        if (player == null) {
            return new HashMap<String, Object>();
        }
        return this.collectEntityInfo((Entity)player);
    }

    @Nullable
    public ItemEntity getGroundItem(@Nullable String type) {
        List items = this.android.m_9236_().m_45976_(ItemEntity.class, this.android.m_20191_().m_82400_(5.0));
        for (ItemEntity entity : items) {
            if (type != null && !BuiltInRegistries.f_257033_.m_7981_((Object)entity.m_32055_().m_41720_()).toString().contains(type)) continue;
            return entity;
        }
        return null;
    }

    public List<HashMap<String, Integer>> getBlocksOfType(BlockPos origin, Vec3 eyePos, Level world, String type) {
        ArrayList<HashMap<String, Integer>> blocks = new ArrayList<HashMap<String, Integer>>();
        block0: for (final BlockPos pos : BlockPos.m_121925_((BlockPos)origin, (int)this.blockSearchRadius, (int)this.blockSearchRadius, (int)this.blockSearchRadius)) {
            if (!BuiltInRegistries.f_256975_.m_7981_((Object)world.m_8055_(pos).m_60734_()).toString().contains(type)) continue;
            for (Direction direction : Direction.m_235666_().toList()) {
                ClipContext context;
                if (world.m_8055_(pos.m_121945_(direction)).m_60796_((BlockGetter)world, pos.m_121945_(direction)) || !world.m_45547_(context = new ClipContext(eyePos, pos.m_121945_(direction).m_252807_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)this.android)).m_82425_().equals((Object)pos.m_121945_(direction))) continue;
                blocks.add(new HashMap<String, Integer>(){
                    {
                        this.put("x", pos.m_123341_());
                        this.put("y", pos.m_123342_());
                        this.put("z", pos.m_123343_());
                    }
                });
                continue block0;
            }
        }
        return blocks;
    }

    public HashMap<String, Object> collectEntityInfo(Entity entity) throws LuaException {
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        infoMap.put("uuid", entity.m_20149_());
        infoMap.put("name", entity.m_7755_().getString());
        infoMap.put("posX", entity.m_20185_());
        infoMap.put("posY", entity.m_20186_());
        infoMap.put("posZ", entity.m_20189_());
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            infoMap.put("health", Float.valueOf(livingEntity.m_21223_()));
        }
        return infoMap;
    }

    private Predicate<LivingEntity> getTypePredicate(@Nullable String type) {
        if (type == null) {
            return entity -> entity != this.android && this.android.m_142582_((Entity)entity);
        }
        return entity -> EntityType.m_20613_((EntityType)entity.m_6095_()).toString().contains(type) && entity != this.android && !entity.m_5833_() && entity.m_6084_() && this.android.m_142582_((Entity)entity);
    }

    public HashMap<String, Object> GetContainerInfo(BlockPos pos) throws LuaException {
        BaseContainerBlockEntity locked;
        if (!pos.m_203195_((Position)this.android.m_20182_(), (double)this.android.getBlockSearchRadius())) {
            throw new LuaException("Position out of range");
        }
        ServerPlayer androidPlr = AndroidPlayer.get(this.brain).player();
        BlockEntity blockEntity = this.android.m_9236_().m_7702_(pos);
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        if (!(blockEntity instanceof Container)) {
            return infoMap;
        }
        Container inv = (Container)blockEntity;
        infoMap.put("slotCount", inv.m_6643_());
        infoMap.put("locked", blockEntity instanceof BaseContainerBlockEntity && !(locked = (BaseContainerBlockEntity)blockEntity).m_7525_((Player)androidPlr));
        ArrayList items = new ArrayList();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            ArrayList<Object> itemInfo = new ArrayList<Object>();
            itemInfo.add(stack.m_41786_().toString());
            itemInfo.add(stack.m_41613_());
            items.add(itemInfo);
        }
        infoMap.put("slots", items);
        return infoMap;
    }
}

