/*
 * Decompiled with CFR 0.152.
 */
package com.thunderbear06.ai.modules;

import com.thunderbear06.ai.AndroidBrain;
import com.thunderbear06.ai.modules.AbstractAndroidModule;
import com.thunderbear06.entity.android.BaseAndroidEntity;
import com.thunderbear06.entity.player.AndroidPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public class MiningModule
extends AbstractAndroidModule {
    private float breakProgress = 0.0f;

    public MiningModule(BaseAndroidEntity owner, AndroidBrain brain) {
        super(owner, brain);
    }

    public void mine(BlockPos pos) {
        this.breakProgress = this.tickBreakProgress(pos, this.breakProgress);
        if (this.breakProgress >= 10.0f) {
            this.breakBlock(pos);
        }
    }

    public void breakBlock(BlockPos pos) {
        AndroidPlayer.get((AndroidBrain)this.brain).player().f_8941_.m_9280_(pos);
    }

    public void resetBreakProgress(BlockPos pos) {
        this.android.m_9236_().m_6801_(this.android.m_19879_(), pos, -1);
        this.breakProgress = 0.0f;
    }

    public boolean canMineBlock(BlockPos pos) {
        BlockState state = this.android.m_9236_().m_8055_(pos);
        return !state.m_60795_() && state.m_60800_((BlockGetter)this.android.m_9236_(), pos) > -1.0f;
    }

    private float tickBreakProgress(BlockPos pos, float progress) {
        this.android.m_9236_().m_6801_(this.android.m_19879_(), pos, (int)progress);
        return progress += this.getBreakSpeed(pos);
    }

    private float getBreakSpeed(BlockPos pos) {
        BlockState state = this.android.m_9236_().m_8055_(pos);
        ServerPlayer player = AndroidPlayer.get(this.brain).player();
        float hardnessMod = state.m_60800_((BlockGetter)this.android.m_9236_(), pos);
        int canHarvestMod = player.m_36298_(state) ? 30 : 100;
        return player.m_36281_(state) / hardnessMod / (float)canHarvestMod * 100.0f;
    }
}

