/*
 * Decompiled with CFR 0.152.
 */
package com.thunderbear06.ai.modules;

import com.thunderbear06.ai.AndroidBrain;
import com.thunderbear06.ai.modules.AbstractAndroidModule;
import com.thunderbear06.entity.android.AndroidEntity;
import com.thunderbear06.entity.android.BaseAndroidEntity;
import com.thunderbear06.entity.player.AndroidPlayer;
import com.thunderbear06.item.ItemRegistry;
import dan200.computercraft.api.lua.LuaException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.phys.BlockHitResult;

public class InteractionModule
extends AbstractAndroidModule {
    public InteractionModule(BaseAndroidEntity android, AndroidBrain brain) {
        super(android, brain);
    }

    public void interactWithBlock(InteractionHand hand, BlockPos pos) {
        ServerPlayer player = AndroidPlayer.get(this.brain).player();
        this.android.m_6674_(hand);
        player.f_8941_.m_7179_(player, this.android.m_9236_(), player.m_21120_(hand), hand, new BlockHitResult(pos.m_252807_(), Direction.UP, pos, true));
    }

    public void interactWithEntity(InteractionHand hand, LivingEntity entity) {
        ServerPlayer player = AndroidPlayer.get(this.brain).player();
        ItemStack handStack = player.m_21120_(hand);
        this.android.m_6674_(hand);
        if (entity instanceof AndroidEntity) {
            AndroidEntity droid = (AndroidEntity)entity;
            if (handStack.m_150930_((Item)ItemRegistry.COMPONENTS.get()) && droid.repair(handStack)) {
                return;
            }
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (handStack.m_150930_(Items.f_42655_) && mob.m_21524_() == null) {
                mob.m_21463_((Entity)this.android, true);
                handStack.m_41774_(1);
                this.android.m_21008_(hand, handStack);
                return;
            }
            if (handStack.m_41619_() && mob.m_21524_() != null && mob.m_21524_().equals((Object)this.android)) {
                mob.m_21455_(true, true);
                return;
            }
        }
        entity.m_6096_((Player)player, hand);
    }

    public void tickDoorInteraction() {
        GroundPathNavigation nav = (GroundPathNavigation)this.android.m_21573_();
        if (nav.m_26571_() || nav.m_26570_() == null) {
            return;
        }
        Node node = nav.m_26570_().m_77401_();
        Node lastNode = nav.m_26570_().m_77402_();
        this.toggleDoor(node.m_77288_(), true);
        if (lastNode != null && lastNode.f_77278_ != null) {
            this.toggleDoor(lastNode.f_77278_.m_77288_(), false);
        }
    }

    private void toggleDoor(BlockPos pos, boolean open) {
        BlockState state = this.android.m_9236_().m_8055_(pos);
        if (state.m_204336_(BlockTags.f_13095_)) {
            DoorBlock door = (DoorBlock)state.m_60734_();
            door.m_153165_((Entity)this.android, this.android.m_9236_(), state, pos, open);
        }
    }

    public void StoreHeldItemInContainer(BlockPos pos, int slot) throws LuaException {
        BaseContainerBlockEntity locked;
        if (!pos.m_203195_((Position)this.android.m_20182_(), (double)this.android.getBlockSearchRadius())) {
            throw new LuaException("Position out of range");
        }
        ServerPlayer androidPlr = AndroidPlayer.get(this.brain).player();
        ItemStack heldStack = androidPlr.m_21205_();
        BlockEntity blockEntity = this.android.m_9236_().m_7702_(pos);
        if (!(blockEntity instanceof Container)) {
            throw new LuaException("Targeted block does not have an inventory");
        }
        Container inv = (Container)blockEntity;
        if (blockEntity instanceof BaseContainerBlockEntity && !(locked = (BaseContainerBlockEntity)blockEntity).m_7525_((Player)androidPlr)) {
            throw new LuaException("Targeted container is locked!");
        }
        if (!inv.m_7013_(slot, heldStack)) {
            throw new LuaException("Held item can not be placed in that slot");
        }
        ItemStack invStack = inv.m_8020_(slot);
        inv.m_5856_((Player)androidPlr);
        this.android.m_6674_(InteractionHand.MAIN_HAND);
        if (invStack.m_41619_()) {
            inv.m_6836_(slot, heldStack.m_41777_());
            this.android.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        } else if (ItemStack.m_150942_((ItemStack)invStack, (ItemStack)heldStack)) {
            int space = invStack.m_41741_() - invStack.m_41613_();
            int transfer = Math.min(heldStack.m_41613_(), space);
            invStack.m_41769_(transfer);
            heldStack.m_41774_(transfer);
        } else {
            throw new LuaException("There is already a item in that slot");
        }
        inv.m_5785_((Player)androidPlr);
    }

    public void GrabItemFromContainer(BlockPos pos, int slot) throws LuaException {
        BaseContainerBlockEntity locked;
        if (!pos.m_203195_((Position)this.android.m_20182_(), (double)this.android.getBlockSearchRadius())) {
            throw new LuaException("Position out of range");
        }
        ServerPlayer androidPlr = AndroidPlayer.get(this.brain).player();
        ItemStack heldStack = this.android.m_21205_();
        BlockEntity blockEntity = this.android.m_9236_().m_7702_(pos);
        if (!(blockEntity instanceof Container)) {
            throw new LuaException("Targeted block does not have an inventory");
        }
        Container inv = (Container)blockEntity;
        if (blockEntity instanceof BaseContainerBlockEntity && !(locked = (BaseContainerBlockEntity)blockEntity).m_7525_((Player)androidPlr)) {
            throw new LuaException("Targeted container is locked!");
        }
        ItemStack invStack = inv.m_8020_(slot);
        if (invStack.m_41619_()) {
            throw new LuaException("Slot is empty");
        }
        inv.m_5856_((Player)androidPlr);
        this.android.m_6674_(InteractionHand.MAIN_HAND);
        if (heldStack.m_41619_()) {
            this.android.m_21008_(InteractionHand.MAIN_HAND, invStack.m_41777_());
            inv.m_6836_(slot, ItemStack.f_41583_);
        } else if (ItemStack.m_150942_((ItemStack)invStack, (ItemStack)heldStack)) {
            int space = heldStack.m_41741_() - heldStack.m_41613_();
            int transfer = Math.min(invStack.m_41613_(), space);
            heldStack.m_41769_(transfer);
            invStack.m_41774_(transfer);
        } else {
            throw new LuaException("Slot is blocked by item");
        }
        inv.m_5785_((Player)androidPlr);
    }
}

