/*
 * Decompiled with CFR 0.152.
 */
package com.thunderbear06.ai;

import com.mojang.authlib.GameProfile;
import com.thunderbear06.CCAndroids;
import com.thunderbear06.ai.modules.AndroidModules;
import com.thunderbear06.ai.task.Task;
import com.thunderbear06.ai.task.TaskManager;
import com.thunderbear06.entity.android.AndroidEntity;
import com.thunderbear06.entity.player.AndroidPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;

public class AndroidBrain {
    protected final AndroidEntity android;
    protected final TaskManager taskManager;
    protected final AndroidModules modules;
    @Deprecated
    public AndroidPlayer fakePlayer;
    private GameProfile owningPlayerProfile;

    public AndroidBrain(AndroidEntity entity) {
        this.android = entity;
        this.taskManager = new TaskManager();
        this.modules = new AndroidModules(entity, this);
        this.fakePlayer = this.android.m_9236_() instanceof ServerLevel ? AndroidPlayer.get(this) : null;
    }

    public void onShutdown() {
        this.taskManager.clearCurrentTask();
    }

    public void setTask(Task task) {
        if (CCAndroids.CONFIG.DebugLogging) {
            CCAndroids.LOGGER.info("Set current android task to {}", (Object)task.getName());
        }
        this.taskManager.setCurrentTask(task);
    }

    public AndroidEntity getAndroid() {
        return this.android;
    }

    public AndroidModules getModules() {
        return this.modules;
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    public boolean isOwningPlayer(Player player) {
        return this.owningPlayerProfile == player.m_36316_();
    }

    public GameProfile getOwningPlayerProfile() {
        return this.owningPlayerProfile;
    }

    public void setOwningPlayer(GameProfile gameProfile) {
        this.owningPlayerProfile = gameProfile;
    }

    public void writeNbt(CompoundTag computerCompound) {
        if (this.owningPlayerProfile == null) {
            return;
        }
        computerCompound.m_128362_("OwningPlayerUUID", this.owningPlayerProfile.getId());
        computerCompound.m_128359_("OwningPlayerName", this.owningPlayerProfile.getName());
    }

    public void readNbt(CompoundTag computerCompound) {
        if (!computerCompound.m_128441_("OwningPlayerUUID")) {
            return;
        }
        this.owningPlayerProfile = new GameProfile(computerCompound.m_128342_("OwningPlayerUUID"), computerCompound.m_128461_("OwningPlayerName"));
    }
}

