/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.server;

import dan200.computercraft.shared.computer.menu.ComputerMenu;
import dan200.computercraft.shared.computer.menu.ServerInputHandler;
import dan200.computercraft.shared.network.MessageType;
import dan200.computercraft.shared.network.NetworkMessages;
import dan200.computercraft.shared.network.server.ComputerServerMessage;
import dan200.computercraft.shared.network.server.ServerNetworkContext;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class MouseEventServerMessage
extends ComputerServerMessage {
    private final Action type;
    private final int x;
    private final int y;
    private final int arg;

    public MouseEventServerMessage(AbstractContainerMenu menu, Action type, int arg, int x, int y) {
        super(menu);
        this.type = type;
        this.arg = arg;
        this.x = x;
        this.y = y;
    }

    public MouseEventServerMessage(FriendlyByteBuf buf) {
        super(buf);
        this.type = (Action)buf.m_130066_(Action.class);
        this.arg = buf.m_130242_();
        this.x = buf.m_130242_();
        this.y = buf.m_130242_();
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        super.write(buf);
        buf.m_130068_((Enum)this.type);
        buf.m_130130_(this.arg);
        buf.m_130130_(this.x);
        buf.m_130130_(this.y);
    }

    @Override
    protected void handle(ServerNetworkContext context, ComputerMenu container) {
        ServerInputHandler input = container.getInput();
        switch (this.type.ordinal()) {
            case 0: {
                input.mouseClick(this.arg, this.x, this.y);
                break;
            }
            case 1: {
                input.mouseDrag(this.arg, this.x, this.y);
                break;
            }
            case 2: {
                input.mouseUp(this.arg, this.x, this.y);
                break;
            }
            case 3: {
                input.mouseScroll(this.arg, this.x, this.y);
            }
        }
    }

    @Override
    public MessageType<MouseEventServerMessage> type() {
        return NetworkMessages.MOUSE_EVENT;
    }

    public static enum Action {
        CLICK,
        DRAG,
        UP,
        SCROLL;

    }
}

