/*
 * Decompiled with CFR 0.152.
 */
package com.dsvv.cbcat.cannon.twin_autocannon.recoil_spring;

import com.dsvv.cbcat.cannon.twin_autocannon.TwinAutocannonBlock;
import com.dsvv.cbcat.cannon.twin_autocannon.recoil_spring.TwinAutocannonRecoilSpringBlockEntity;
import com.dsvv.cbcat.registry.ExtraDataRegister;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.OrientedInstance;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import rbasamoyai.createbigcannons.index.CBCAutocannonMaterials;

public class TwinAutocannonRecoilSpringInstance
extends AbstractBlockEntityVisual<TwinAutocannonRecoilSpringBlockEntity>
implements SimpleDynamicVisual {
    private TransformedInstance spring;
    private final Map<BlockPos, OrientedInstance> blocks1 = new HashMap<BlockPos, OrientedInstance>();
    private final Map<BlockPos, OrientedInstance> blocks2 = new HashMap<BlockPos, OrientedInstance>();
    private Direction facing;
    private boolean vertical;
    private boolean firstFire = true;

    public TwinAutocannonRecoilSpringInstance(VisualizationContext ctx, TwinAutocannonRecoilSpringBlockEntity blockEntity, float partialTicks) {
        super(ctx, (BlockEntity)blockEntity, partialTicks);
        this.vertical = blockEntity.isVertical();
        this.facing = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61372_);
        this.spring = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)this.getPartialModelForState(), (Direction)this.facing)).createInstance();
        this.blocks1.clear();
        this.blocks2.clear();
        for (Map.Entry<BlockPos, BlockState> entry : ((TwinAutocannonRecoilSpringBlockEntity)this.blockEntity).toAnimate.entrySet()) {
            if (entry.getValue() == null) continue;
            this.blocks1.put(entry.getKey(), (OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.block((BlockState)entry.getValue())).createInstance());
            this.blocks2.put(entry.getKey(), (OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.block((BlockState)entry.getValue())).createInstance());
        }
        this.updateTransforms(partialTicks);
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        this.updateTransforms(ctx.partialTick());
    }

    private void updateTransforms(float partialTicks) {
        BlockPos pos1;
        this.firstFire = ((TwinAutocannonRecoilSpringBlockEntity)this.blockEntity).firstFire;
        boolean flag = this.facing.m_122421_() == Direction.AxisDirection.NEGATIVE;
        BlockPos pos = this.visualPos.m_5484_(this.facing.m_122424_(), flag ? 1 : 0);
        Vec3 pivot = Vec3.m_82528_((Vec3i)pos);
        Map.Entry<Float, Boolean> beValues = ((TwinAutocannonRecoilSpringBlockEntity)this.blockEntity).getAnimateOffset(partialTicks);
        float scale = beValues.getKey().floatValue();
        this.firstFire = beValues.getValue();
        float f1 = scale * 0.5f + 0.5f;
        Direction.Axis axis = this.facing.m_122434_();
        float fx = axis == Direction.Axis.X ? f1 : 1.0f;
        float fy = axis == Direction.Axis.Y ? f1 : 1.0f;
        float fz = axis == Direction.Axis.Z ? f1 : 1.0f;
        this.spring.setIdentityTransform().translate(pivot);
        if (flag) {
            ((TransformedInstance)this.spring.rotateCentered((float)Math.PI, axis.m_122478_() ? Direction.EAST : Direction.UP)).translate((Vector3fc)this.facing.m_122424_().m_253071_());
        }
        this.spring.scale(fx, fy, fz);
        Vector3f offs = this.facing.m_253071_();
        offs.add((float)this.visualPos.m_123341_(), (float)this.visualPos.m_123342_(), (float)this.visualPos.m_123343_());
        offs.sub((Vector3fc)this.facing.m_253071_());
        offs.sub((Vector3fc)this.facing.m_253071_());
        Vector3f offsFiring = this.facing.m_253071_();
        offsFiring.mul((1.0f - scale) * -0.5f);
        offsFiring.add((float)this.visualPos.m_123341_(), (float)this.visualPos.m_123342_(), (float)this.visualPos.m_123343_());
        offsFiring.sub((Vector3fc)this.facing.m_253071_());
        Vector3f offs2 = this.vertical ? new Vector3f(0.0f, 0.25f, 0.0f) : new Vector3f(this.facing.m_122434_() == Direction.Axis.Z ? -0.25f : 0.0f, 0.0f, this.facing.m_122434_() == Direction.Axis.X ? -0.25f : 0.0f);
        for (Map.Entry<BlockPos, OrientedInstance> entry : this.blocks1.entrySet()) {
            pos1 = entry.getKey().m_121945_(this.facing);
            entry.getValue().position((Vec3i)pos1);
            if (entry != this.blocks1.entrySet().toArray()[0]) {
                entry.getValue().translatePosition(offs2.x, offs2.y, offs2.z);
            }
            if (this.firstFire) {
                entry.getValue().translatePosition(offsFiring.x, offsFiring.y, offsFiring.z);
                continue;
            }
            entry.getValue().translatePosition(offs.x, offs.y, offs.z);
        }
        for (Map.Entry<BlockPos, OrientedInstance> entry : this.blocks2.entrySet()) {
            pos1 = entry.getKey().m_121945_(this.facing);
            entry.getValue().position((Vec3i)pos1);
            if (entry != this.blocks2.entrySet().toArray()[0]) {
                entry.getValue().translatePosition(-offs2.x, -offs2.y, -offs2.z);
            }
            if (!this.firstFire) {
                entry.getValue().translatePosition(offsFiring.x, offsFiring.y, offsFiring.z);
                continue;
            }
            entry.getValue().translatePosition(offs.x, offs.y, offs.z);
        }
    }

    public void updateLight(float partialTicks) {
        this.relight(this.pos, new FlatLit[]{this.spring});
        for (Map.Entry<BlockPos, OrientedInstance> entry : this.blocks1.entrySet()) {
            this.relight(this.pos.m_121955_((Vec3i)entry.getKey()), new FlatLit[]{(FlatLit)entry.getValue()});
        }
        for (Map.Entry<BlockPos, OrientedInstance> entry : this.blocks2.entrySet()) {
            this.relight(this.pos.m_121955_((Vec3i)entry.getKey()), new FlatLit[]{(FlatLit)entry.getValue()});
        }
    }

    protected void _delete() {
        this.spring.delete();
        for (OrientedInstance block : this.blocks1.values()) {
            block.delete();
        }
        for (OrientedInstance block : this.blocks2.values()) {
            block.delete();
        }
    }

    private PartialModel getPartialModelForState() {
        PartialModel partialModel;
        Block block = this.blockState.m_60734_();
        if (block instanceof TwinAutocannonBlock) {
            TwinAutocannonBlock cBlock = (TwinAutocannonBlock)block;
            partialModel = ExtraDataRegister.twinAutocannonSpringFor(cBlock.getAutocannonMaterial(), this.vertical);
        } else {
            partialModel = ExtraDataRegister.twinAutocannonSpringFor(CBCAutocannonMaterials.CAST_IRON, this.vertical);
        }
        return partialModel;
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        consumer.accept((Instance)this.spring);
        for (OrientedInstance block : this.blocks1.values()) {
            consumer.accept((Instance)block);
        }
        for (OrientedInstance block : this.blocks2.values()) {
            consumer.accept((Instance)block);
        }
    }
}

