/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.cataclysm_dimension.worldgen;

import com.p1nero.cataclysm_dimension.worldgen.CDSurfaceRuleData;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class CDNoiseSettings {
    public static final ResourceKey<NoiseGeneratorSettings> PLAIN = CDNoiseSettings.createNoiseGeneratorKey("plain_noise_gen");
    public static final ResourceKey<NoiseGeneratorSettings> SEA = CDNoiseSettings.createNoiseGeneratorKey("sea");
    public static final ResourceKey<NoiseGeneratorSettings> DEEP_SEA = CDNoiseSettings.createNoiseGeneratorKey("deep_sea");
    public static final ResourceKey<NoiseGeneratorSettings> DESERT = CDNoiseSettings.createNoiseGeneratorKey("no_sea");
    public static final ResourceKey<NoiseGeneratorSettings> ARENA = CDNoiseSettings.createNoiseGeneratorKey("arena");
    public static final ResourceKey<NoiseGeneratorSettings> SOUL = CDNoiseSettings.createNoiseGeneratorKey("soul");
    public static final ResourceKey<NoiseGeneratorSettings> AIR = CDNoiseSettings.createNoiseGeneratorKey("air");
    private static final ResourceKey<DensityFunction> SHIFT_X = CDNoiseSettings.createKey("shift_x");
    private static final ResourceKey<DensityFunction> SHIFT_Z = CDNoiseSettings.createKey("shift_z");
    public static final ResourceKey<DensityFunction> CONTINENTS = CDNoiseSettings.createKey("overworld/continents");
    public static final ResourceKey<DensityFunction> EROSION = CDNoiseSettings.createKey("overworld/erosion");
    public static final ResourceKey<DensityFunction> RIDGES = CDNoiseSettings.createKey("overworld/ridges");
    public static final ResourceKey<DensityFunction> FACTOR = CDNoiseSettings.createKey("overworld/factor");
    public static final ResourceKey<DensityFunction> DEPTH = CDNoiseSettings.createKey("overworld/depth");
    private static final ResourceKey<DensityFunction> SLOPED_CHEESE = CDNoiseSettings.createKey("overworld/sloped_cheese");
    private static final ResourceKey<DensityFunction> MY_BASE_3D_NOISE_NETHER = ResourceKey.m_135785_((ResourceKey)Registries.f_257040_, (ResourceLocation)new ResourceLocation("cataclysm_dimension", "nether/base_3d_noise"));

    private static ResourceKey<NoiseGeneratorSettings> createNoiseGeneratorKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256932_, (ResourceLocation)new ResourceLocation("cataclysm_dimension", name));
    }

    public static void bootstrap(BootstapContext<NoiseGeneratorSettings> context) {
        HolderGetter densityFunctions = context.m_255420_(Registries.f_257040_);
        HolderGetter noise = context.m_255420_(Registries.f_256865_);
        context.m_255272_(PLAIN, (Object)CDNoiseSettings.plainNoise((HolderGetter<DensityFunction>)densityFunctions, (HolderGetter<NormalNoise.NoiseParameters>)noise));
        context.m_255272_(SEA, (Object)CDNoiseSettings.overworldWithSeaLevel(context, false, false, 128));
        context.m_255272_(DESERT, (Object)CDNoiseSettings.plainDesert((HolderGetter<DensityFunction>)densityFunctions, (HolderGetter<NormalNoise.NoiseParameters>)noise));
        context.m_255272_(ARENA, (Object)CDNoiseSettings.arena((HolderGetter<DensityFunction>)densityFunctions, (HolderGetter<NormalNoise.NoiseParameters>)noise));
        context.m_255272_(SOUL, (Object)CDNoiseSettings.arena((HolderGetter<DensityFunction>)densityFunctions, (HolderGetter<NormalNoise.NoiseParameters>)noise));
        context.m_255272_(AIR, (Object)new NoiseGeneratorSettings(new NoiseSettings(0, 128, 2, 1), Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), new NoiseRouter(DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_()), CDSurfaceRuleData.air(), List.of(), 0, true, false, false, true));
    }

    public static NoiseGeneratorSettings plainNoise(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noiseParameters) {
        return new NoiseGeneratorSettings(new NoiseSettings(32, 256, 1, 2), Blocks.f_50069_.m_49966_(), Blocks.f_49990_.m_49966_(), CDNoiseSettings.overworldZIP(densityFunctions, noiseParameters), CDSurfaceRuleData.overworld(), new OverworldBiomeBuilder().m_187154_(), 63, false, true, true, false);
    }

    public static NoiseGeneratorSettings plainDesert(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noiseParameters) {
        return new NoiseGeneratorSettings(new NoiseSettings(32, 256, 1, 2), Blocks.f_50069_.m_49966_(), Blocks.f_49990_.m_49966_(), CDNoiseSettings.overworldZIP(densityFunctions, noiseParameters), CDSurfaceRuleData.overworld(), new OverworldBiomeBuilder().m_187154_(), -128, false, true, true, false);
    }

    public static NoiseGeneratorSettings arena(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noiseParameters) {
        return new NoiseGeneratorSettings(new NoiseSettings(0, 128, 1, 1), Blocks.f_50134_.m_49966_(), Blocks.f_49991_.m_49966_(), CDNoiseSettings.nether(densityFunctions, noiseParameters), CDSurfaceRuleData.nether(), List.of(), 32, false, false, false, true);
    }

    public static NoiseGeneratorSettings soul(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noiseParameters) {
        return new NoiseGeneratorSettings(new NoiseSettings(-128, 384, 1, 1), Blocks.f_50134_.m_49966_(), Blocks.f_49991_.m_49966_(), CDNoiseSettings.soulNoiseRouter(densityFunctions, noiseParameters), CDSurfaceRuleData.nether(), List.of(), 64, false, false, false, true);
    }

    public static NoiseGeneratorSettings sunkenCity(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noiseParameters) {
        return new NoiseGeneratorSettings(new NoiseSettings(-128, 384, 1, 1), Blocks.f_50069_.m_49966_(), Blocks.f_49990_.m_49966_(), CDNoiseSettings.overworldZIP2(densityFunctions, noiseParameters), CDSurfaceRuleData.overworld(), new OverworldBiomeBuilder().m_187154_(), 63, false, true, true, false);
    }

    public static NoiseGeneratorSettings overworldWithSeaLevel(BootstapContext<?> context, boolean large, boolean amplified, int seaLevel) {
        return new NoiseGeneratorSettings(new NoiseSettings(-64, 384, 1, 2), Blocks.f_50069_.m_49966_(), Blocks.f_49990_.m_49966_(), NoiseRouterData.m_255262_((HolderGetter)context.m_255420_(Registries.f_257040_), (HolderGetter)context.m_255420_(Registries.f_256865_), (boolean)amplified, (boolean)large), CDSurfaceRuleData.overworld(), new OverworldBiomeBuilder().m_187154_(), seaLevel, false, true, true, false);
    }

    protected static NoiseRouter overworldZIP(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noiseParameters) {
        DensityFunction $$4 = DensityFunctions.m_208324_((Holder)noiseParameters.m_255043_(Noises.f_189287_), (double)0.5);
        DensityFunction $$5 = DensityFunctions.m_208324_((Holder)noiseParameters.m_255043_(Noises.f_189288_), (double)0.67);
        DensityFunction $$6 = DensityFunctions.m_208324_((Holder)noiseParameters.m_255043_(Noises.f_189290_), (double)0.7142857142857143);
        DensityFunction $$7 = DensityFunctions.m_208322_((Holder)noiseParameters.m_255043_(Noises.f_189289_));
        DensityFunction $$8 = CDNoiseSettings.getFunction(densityFunctions, SHIFT_X);
        DensityFunction $$9 = CDNoiseSettings.getFunction(densityFunctions, SHIFT_Z);
        DensityFunction $$10 = DensityFunctions.m_208296_((DensityFunction)$$8, (DensityFunction)$$9, (double)0.25, (Holder)noiseParameters.m_255043_(Noises.f_189269_));
        DensityFunction $$11 = DensityFunctions.m_208296_((DensityFunction)$$8, (DensityFunction)$$9, (double)0.25, (Holder)noiseParameters.m_255043_(Noises.f_189278_));
        DensityFunction $$12 = CDNoiseSettings.getFunction(densityFunctions, FACTOR);
        DensityFunction $$13 = CDNoiseSettings.getFunction(densityFunctions, DEPTH);
        DensityFunction $$14 = CDNoiseSettings.noiseGradientDensity(DensityFunctions.m_208373_((DensityFunction)$$12), $$13);
        DensityFunction $$15 = CDNoiseSettings.getFunction(densityFunctions, SLOPED_CHEESE);
        DensityFunction function0 = DensityFunctions.m_208281_((DensityFunction)$$15);
        DensityFunction function = DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208266_((int)-32, (int)256, (double)100.0, (double)-100.0), (DensityFunction)function0);
        return new NoiseRouter($$4, $$5, $$6, $$7, $$10, $$11, CDNoiseSettings.getFunction(densityFunctions, CONTINENTS), CDNoiseSettings.getFunction(densityFunctions, EROSION), $$13, CDNoiseSettings.getFunction(densityFunctions, RIDGES), CDNoiseSettings.slideOverworld(false, DensityFunctions.m_208293_((DensityFunction)$$14, (DensityFunction)DensityFunctions.m_208264_((double)-0.703125)).m_208220_(-64.0, 64.0)), function, DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_());
    }

    protected static NoiseRouter overworldZIP2(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noiseParameters) {
        DensityFunction $$4 = DensityFunctions.m_208324_((Holder)noiseParameters.m_255043_(Noises.f_189287_), (double)0.2);
        DensityFunction $$5 = DensityFunctions.m_208324_((Holder)noiseParameters.m_255043_(Noises.f_189288_), (double)0.37);
        DensityFunction $$6 = DensityFunctions.m_208324_((Holder)noiseParameters.m_255043_(Noises.f_189290_), (double)0.7142857142857143);
        DensityFunction $$7 = DensityFunctions.m_208322_((Holder)noiseParameters.m_255043_(Noises.f_189289_));
        DensityFunction $$8 = CDNoiseSettings.getFunction(densityFunctions, SHIFT_X);
        DensityFunction $$9 = CDNoiseSettings.getFunction(densityFunctions, SHIFT_Z);
        DensityFunction $$10 = DensityFunctions.m_208296_((DensityFunction)$$8, (DensityFunction)$$9, (double)0.25, (Holder)noiseParameters.m_255043_(Noises.f_189269_));
        DensityFunction $$11 = DensityFunctions.m_208296_((DensityFunction)$$8, (DensityFunction)$$9, (double)0.25, (Holder)noiseParameters.m_255043_(Noises.f_189278_));
        DensityFunction $$12 = CDNoiseSettings.getFunction(densityFunctions, FACTOR);
        DensityFunction $$13 = CDNoiseSettings.getFunction(densityFunctions, DEPTH);
        DensityFunction $$14 = CDNoiseSettings.noiseGradientDensity(DensityFunctions.m_208373_((DensityFunction)$$12), $$13);
        DensityFunction $$15 = CDNoiseSettings.getFunction(densityFunctions, CONTINENTS);
        DensityFunction function = DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208266_((int)-64, (int)0, (double)1.3, (double)-1.5), (DensityFunction)$$15);
        return new NoiseRouter($$4, $$5, $$6, $$7, $$10, $$11, CDNoiseSettings.getFunction(densityFunctions, CONTINENTS), CDNoiseSettings.getFunction(densityFunctions, EROSION), $$13, CDNoiseSettings.getFunction(densityFunctions, RIDGES), CDNoiseSettings.slideOverworld(false, DensityFunctions.m_208293_((DensityFunction)$$14, (DensityFunction)DensityFunctions.m_208264_((double)-0.703125)).m_208220_(-32.0, 32.0)), function, DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_());
    }

    protected static NoiseRouter soulNoiseRouter(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noiseParameters) {
        DensityFunction $$4 = DensityFunctions.m_208324_((Holder)noiseParameters.m_255043_(Noises.f_189287_), (double)0.5);
        DensityFunction $$5 = DensityFunctions.m_208324_((Holder)noiseParameters.m_255043_(Noises.f_189288_), (double)0.67);
        DensityFunction $$6 = DensityFunctions.m_208324_((Holder)noiseParameters.m_255043_(Noises.f_189290_), (double)0.7142857142857143);
        DensityFunction $$7 = DensityFunctions.m_208322_((Holder)noiseParameters.m_255043_(Noises.f_189289_));
        DensityFunction $$8 = CDNoiseSettings.getFunction(densityFunctions, SHIFT_X);
        DensityFunction $$9 = CDNoiseSettings.getFunction(densityFunctions, SHIFT_Z);
        DensityFunction $$10 = DensityFunctions.m_208296_((DensityFunction)$$8, (DensityFunction)$$9, (double)0.25, (Holder)noiseParameters.m_255043_(Noises.f_189269_));
        DensityFunction $$11 = DensityFunctions.m_208296_((DensityFunction)$$8, (DensityFunction)$$9, (double)0.25, (Holder)noiseParameters.m_255043_(Noises.f_189278_));
        DensityFunction $$12 = CDNoiseSettings.getFunction(densityFunctions, FACTOR);
        DensityFunction $$13 = CDNoiseSettings.getFunction(densityFunctions, DEPTH);
        DensityFunction $$14 = CDNoiseSettings.noiseGradientDensity(DensityFunctions.m_208373_((DensityFunction)$$12), $$13);
        DensityFunction $$15 = CDNoiseSettings.getFunction(densityFunctions, SLOPED_CHEESE);
        DensityFunction function0 = DensityFunctions.m_208281_((DensityFunction)$$15);
        return new NoiseRouter($$4, $$5, $$6, $$7, $$10, $$11, CDNoiseSettings.getFunction(densityFunctions, CONTINENTS), CDNoiseSettings.getFunction(densityFunctions, EROSION), $$13, CDNoiseSettings.getFunction(densityFunctions, RIDGES), CDNoiseSettings.slideOverworld(false, DensityFunctions.m_208293_((DensityFunction)$$14, (DensityFunction)DensityFunctions.m_208264_((double)-0.703125)).m_208220_(-32.0, 32.0)), function0, DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_());
    }

    protected static NoiseRouter nether(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noiseParameters) {
        return CDNoiseSettings.noNewCaves(densityFunctions, noiseParameters, CDNoiseSettings.slideNetherLike(densityFunctions, 0, 128));
    }

    private static DensityFunction slideNetherLike(HolderGetter<DensityFunction> densityFunctions, int minY, int maxY) {
        return CDNoiseSettings.slide(CDNoiseSettings.getFunction(densityFunctions, MY_BASE_3D_NOISE_NETHER), minY, maxY, 24, 0, 0.9375, -8, 24, 2.5);
    }

    private static NoiseRouter noNewCaves(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noiseParameters, DensityFunction p_256378_) {
        DensityFunction densityfunction = CDNoiseSettings.getFunction(densityFunctions, SHIFT_X);
        DensityFunction densityfunction1 = CDNoiseSettings.getFunction(densityFunctions, SHIFT_Z);
        DensityFunction densityfunction2 = DensityFunctions.m_208296_((DensityFunction)densityfunction, (DensityFunction)densityfunction1, (double)0.25, (Holder)noiseParameters.m_255043_(Noises.f_189269_));
        DensityFunction densityfunction3 = DensityFunctions.m_208296_((DensityFunction)densityfunction, (DensityFunction)densityfunction1, (double)0.25, (Holder)noiseParameters.m_255043_(Noises.f_189278_));
        DensityFunction densityfunction4 = CDNoiseSettings.postProcess(p_256378_);
        return new NoiseRouter(DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), densityfunction2, densityfunction3, DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), densityfunction4, DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_());
    }

    private static ResourceKey<DensityFunction> createKey(String location) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_257040_, (ResourceLocation)new ResourceLocation(location));
    }

    private static DensityFunction slideOverworld(boolean amplified, DensityFunction densityFunction) {
        return CDNoiseSettings.slide(densityFunction, -64, 384, amplified ? 16 : 80, amplified ? 0 : 64, -0.078125, 0, 24, amplified ? 0.4 : 0.1171875);
    }

    private static DensityFunction noiseGradientDensity(DensityFunction p_212272_, DensityFunction p_212273_) {
        DensityFunction $$2 = DensityFunctions.m_208363_((DensityFunction)p_212273_, (DensityFunction)p_212272_);
        return DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)4.0), (DensityFunction)$$2.m_208233_());
    }

    private static DensityFunction postProcess(DensityFunction p_224493_) {
        DensityFunction $$1 = DensityFunctions.m_208389_((DensityFunction)p_224493_);
        return DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208281_((DensityFunction)$$1), (DensityFunction)DensityFunctions.m_208264_((double)0.64)).m_208234_();
    }

    private static DensityFunction slide(DensityFunction density, int minY, int maxY, int fromYTop, int toYTop, double offset1, int fromYBottom, int toYBottom, double offset2) {
        DensityFunction topSlide = DensityFunctions.m_208266_((int)(minY + maxY - fromYTop), (int)(minY + maxY - toYTop), (double)1.0, (double)0.0);
        density = DensityFunctions.m_224030_((DensityFunction)topSlide, (double)offset1, (DensityFunction)density);
        DensityFunction bottomSlide = DensityFunctions.m_208266_((int)(minY + fromYBottom), (int)(minY + toYBottom), (double)0.0, (double)1.0);
        return DensityFunctions.m_224030_((DensityFunction)bottomSlide, (double)offset2, (DensityFunction)density);
    }

    private static DensityFunction getFunction(HolderGetter<DensityFunction> densityFunctions, ResourceKey<DensityFunction> key) {
        return new DensityFunctions.HolderHolder((Holder)densityFunctions.m_255043_(key));
    }
}

