/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.util;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class MultiSlotItemHandler
implements IItemHandler {
    private ItemStack[] items;
    private final int invLimit;

    public MultiSlotItemHandler(int size, int invLimit) {
        this.items = new ItemStack[size];
        for (int i = 0; i < size; ++i) {
            this.items[i] = ItemStack.f_41583_;
        }
        this.invLimit = invLimit;
    }

    public MultiSlotItemHandler(ItemStack[] items, int invLimit) {
        this.items = items;
        this.invLimit = invLimit;
    }

    public int getSlots() {
        return this.items.length;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.items[slot];
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        this.items[slot] = stack;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stackInSlot = this.getStackInSlot(slot);
        if (!stackInSlot.m_41619_()) {
            if (stackInSlot.m_41613_() >= Math.min(stackInSlot.m_41741_(), this.getSlotLimit(slot))) {
                return stack;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot)) {
                return stack;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            int m = Math.min(stack.m_41741_(), this.getSlotLimit(slot)) - stackInSlot.m_41613_();
            if (stack.m_41613_() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.m_41777_();
                    copy.m_41769_(stackInSlot.m_41613_());
                    this.setInventorySlotContents(slot, copy);
                }
                return ItemStack.f_41583_;
            }
            stack = stack.m_41777_();
            if (!simulate) {
                ItemStack copy = stack.m_41620_(m);
                copy.m_41769_(stackInSlot.m_41613_());
                this.setInventorySlotContents(slot, copy);
                return stack;
            }
            stack.m_41774_(m);
            return stack;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        int m = Math.min(stack.m_41741_(), this.getSlotLimit(slot));
        if (m < stack.m_41613_()) {
            stack = stack.m_41777_();
            if (!simulate) {
                this.setInventorySlotContents(slot, stack.m_41620_(m));
                return stack;
            }
            stack.m_41774_(m);
            return stack;
        }
        if (!simulate) {
            this.setInventorySlotContents(slot, stack);
        }
        return ItemStack.f_41583_;
    }

    public boolean canTransferAllItemsToSlots(List<ItemStack> stackList, boolean simulate) {
        ItemStack[] copyList = new ItemStack[this.items.length];
        for (int i = 0; i < copyList.length; ++i) {
            copyList[i] = this.items[i].m_41777_();
        }
        boolean hasStashedAll = true;
        for (ItemStack stack : stackList) {
            if (stack.m_41619_()) continue;
            for (int slot = 0; slot < copyList.length; ++slot) {
                int m;
                ItemStack stackInSlot = copyList[slot];
                if (!stackInSlot.m_41619_()) {
                    ItemStack copy;
                    if (stackInSlot.m_41613_() >= Math.min(stackInSlot.m_41741_(), this.getSlotLimit(slot)) || !ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot) || !this.isItemValid(slot, stack)) continue;
                    m = Math.min(stack.m_41741_(), this.getSlotLimit(slot)) - stackInSlot.m_41613_();
                    if (stack.m_41613_() <= m) {
                        copy = stack.m_41777_();
                        if (!simulate) {
                            copy.m_41769_(stackInSlot.m_41613_());
                            copyList[slot] = copy;
                        }
                        stack = ItemStack.f_41583_;
                        break;
                    }
                    stack = stack.m_41777_();
                    if (!simulate) {
                        copy = stack.m_41620_(m);
                        copy.m_41769_(stackInSlot.m_41613_());
                        copyList[slot] = copy;
                        continue;
                    }
                    stack.m_41774_(m);
                    continue;
                }
                if (!this.isItemValid(slot, stack)) continue;
                m = Math.min(stack.m_41741_(), this.getSlotLimit(slot));
                if (m < stack.m_41613_()) {
                    stack = stack.m_41777_();
                    if (!simulate) {
                        copyList[slot] = stack.m_41620_(m);
                        continue;
                    }
                    stack.m_41774_(m);
                    continue;
                }
                if (!simulate) {
                    copyList[slot] = stack;
                }
                stack = ItemStack.f_41583_;
            }
            if (stack.m_41619_()) continue;
            hasStashedAll = false;
            break;
        }
        if (!simulate) {
            this.items = copyList;
        }
        return hasStashedAll;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack stackInSlot = this.getStackInSlot(slot);
        if (stackInSlot.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (simulate) {
            if (stackInSlot.m_41613_() < amount) {
                return stackInSlot.m_41777_();
            }
            ItemStack copy = stackInSlot.m_41777_();
            copy.m_41764_(amount);
            return copy;
        }
        int m = Math.min(stackInSlot.m_41613_(), amount);
        ItemStack decrStackSize = this.decrStackSize(slot, m);
        return decrStackSize;
    }

    public ItemStack decrStackSize(int slot, int amount) {
        if (!this.getStackInSlot(slot).m_41619_()) {
            if (this.getStackInSlot(slot).m_41613_() <= amount) {
                ItemStack itemStack = this.getStackInSlot(slot);
                this.setInventorySlotContents(slot, ItemStack.f_41583_);
                return itemStack;
            }
            ItemStack itemStack = this.getStackInSlot(slot).m_41620_(amount);
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        return this.invLimit;
    }
}

