/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.util;

import java.text.DecimalFormat;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.util.helper.TextHelper;

public class ChatUtil {
    private static final int DELETION_ID = 2525277;
    private static int lastAdded;
    public static final DecimalFormat DECIMAL_FORMAT;

    private static void sendNoSpamMessages(Component[] messages) {
        ChatComponent chat = Minecraft.m_91087_().f_91065_.m_93076_();
        for (int i = 0; i < messages.length; ++i) {
            chat.m_93785_(messages[i]);
        }
        lastAdded = 2525277 + messages.length - 1;
    }

    public static Component wrap(String s) {
        return Component.m_237113_((String)s);
    }

    public static Component[] wrap(String ... s) {
        Component[] ret = new Component[s.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ChatUtil.wrap(s[i]);
        }
        return ret;
    }

    public static Component wrapFormatted(String s, Object ... args) {
        return Component.m_237110_((String)s, (Object[])args);
    }

    public static void sendChat(Player player, String ... lines) {
        ChatUtil.sendChat(player, ChatUtil.wrap(lines));
    }

    public static void sendChatUnloc(Player player, String ... unlocLines) {
        ChatUtil.sendChat(player, TextHelper.localizeAll(unlocLines));
    }

    public static void sendChat(Player player, Component ... lines) {
        for (Component c : lines) {
            player.m_213846_(c);
        }
    }

    public static void sendNoSpamClientUnloc(String ... unlocLines) {
        ChatUtil.sendNoSpamClient(TextHelper.localizeAll(unlocLines));
    }

    public static void sendNoSpamClient(String ... lines) {
        ChatUtil.sendNoSpamClient(ChatUtil.wrap(lines));
    }

    public static void sendNoSpamClient(Component ... lines) {
        ChatUtil.sendNoSpamMessages(lines);
    }

    public static void sendNoSpamUnloc(Player player, String ... unlocLines) {
        ChatUtil.sendNoSpam(player, TextHelper.localizeAll(unlocLines));
    }

    public static void sendNoSpam(Player player, String ... lines) {
        ChatUtil.sendNoSpam(player, ChatUtil.wrap(lines));
    }

    public static void sendNoSpam(Player player, Component ... lines) {
        if (player instanceof ServerPlayer) {
            ChatUtil.sendNoSpam((ServerPlayer)player, lines);
        }
    }

    public static void sendNoSpamUnloc(ServerPlayer player, String ... unlocLines) {
        ChatUtil.sendNoSpam(player, TextHelper.localizeAll(unlocLines));
    }

    public static void sendNoSpam(ServerPlayer player, String ... lines) {
        ChatUtil.sendNoSpam(player, ChatUtil.wrap(lines));
    }

    public static void sendNoSpam(ServerPlayer player, Component ... lines) {
        if (lines.length > 0) {
            BloodMagic.packetHandler.sendTo(new PacketNoSpamChat(lines), player);
        }
    }

    static {
        DECIMAL_FORMAT = new DecimalFormat("###,###.##");
    }

    public static class PacketNoSpamChat {
        private Component[] chatLines;

        public PacketNoSpamChat() {
            this.chatLines = new Component[0];
        }

        private PacketNoSpamChat(Component ... lines) {
            this.chatLines = lines;
        }

        public static void encode(PacketNoSpamChat pkt, FriendlyByteBuf buf) {
            buf.writeInt(pkt.chatLines.length);
            for (Component c : pkt.chatLines) {
                buf.m_130070_(Component.Serializer.m_130703_((Component)c));
            }
        }

        public static PacketNoSpamChat decode(FriendlyByteBuf buf) {
            PacketNoSpamChat pkt = new PacketNoSpamChat(new Component[buf.readInt()]);
            for (int i = 0; i < pkt.chatLines.length; ++i) {
                pkt.chatLines[i] = Component.Serializer.m_130714_((String)buf.m_130277_());
            }
            return pkt;
        }

        public static void handle(PacketNoSpamChat message, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> ChatUtil.sendNoSpamMessages(message.chatLines));
            context.get().setPacketHandled(true);
        }
    }
}

