/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.compat.patchouli.processors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.util.helper.RitualHelper;
import wayoftime.bloodmagic.util.helper.TextHelper;
import wayoftime.bloodmagic.will.DemonWillHolder;

public class RitualInfoProcessor
implements IComponentProcessor {
    private Ritual ritual;
    private String pageType;
    private String extraText = "";
    private String heading;
    private ItemStack item = new ItemStack((ItemLike)BloodMagicItems.RITUAL_READER.get());
    private String infoBlurb = "";
    private final String LANGUAGE_BASE = "guide.patchouli.bloodmagic.ritual_info.";
    private final String DIVINER_BASE = "tooltip.bloodmagic.diviner.";

    public void setup(Level level, IVariableProvider variables) {
        String id = variables.get("ritual").asString();
        this.ritual = BloodMagic.RITUAL_MANAGER.getRitual(id);
        if (this.ritual == null) {
            LogManager.getLogger().warn("Guidebook given invalid Ritual ID {}", (Object)id);
            return;
        }
        this.pageType = variables.has("page_type") ? variables.get("page_type").asString() : "info";
        Boolean infoAlreadySet = false;
        String rangeInfo = "";
        switch (this.pageType) {
            case "info": {
                this.infoBlurb = TextHelper.localize(this.ritual.getTranslationKey() + ".info", new Object[0]);
                infoAlreadySet = true;
                break;
            }
            case "raw": {
                this.infoBlurb = TextHelper.localize(this.ritual.getTranslationKey() + ".default.info", new Object[0]);
                this.heading = this.GetAndRemoveLeadTitle();
                this.item = new ItemStack((ItemLike)BloodMagicItems.RAW_CRYSTAL.get());
                infoAlreadySet = true;
                break;
            }
            case "corrosive": {
                this.item = new ItemStack((ItemLike)BloodMagicItems.CORROSIVE_CRYSTAL.get());
                break;
            }
            case "destructive": {
                this.item = new ItemStack((ItemLike)BloodMagicItems.DESTRUCTIVE_CRYSTAL.get());
                break;
            }
            case "steadfast": {
                this.item = new ItemStack((ItemLike)BloodMagicItems.STEADFAST_CRYSTAL.get());
                break;
            }
            case "vengeful": {
                this.item = new ItemStack((ItemLike)BloodMagicItems.VENGEFUL_CRYSTAL.get());
                break;
            }
            default: {
                DemonWillHolder emptyHolder = new DemonWillHolder();
                int n = this.ritual.getMaxVolumeForRange(this.pageType, Collections.emptyList(), emptyHolder);
                int horizontal = this.ritual.getMaxHorizontalRadiusForRange(this.pageType, Collections.emptyList(), emptyHolder);
                int vertical = this.ritual.getMaxVerticalRadiusForRange(this.pageType, Collections.emptyList(), emptyHolder);
                rangeInfo = TextHelper.localize("guide.patchouli.bloodmagic.ritual_info.range_formatter", n == 0 ? TextHelper.localize("guide.patchouli.bloodmagic.ritual_info.full_range", new Object[0]) : Integer.valueOf(n), horizontal, vertical);
            }
        }
        if (!infoAlreadySet.booleanValue()) {
            this.infoBlurb = TextHelper.localize(this.ritual.getTranslationKey() + "." + this.pageType + ".info", new Object[0]);
            this.heading = this.GetAndRemoveLeadTitle();
        }
        this.infoBlurb = this.infoBlurb + rangeInfo;
        if (variables.has("text_overrides")) {
            List varOverridePairs = variables.get("text_overrides").asList();
            ArrayList overrideTable = new ArrayList();
            for (IVariable iVariable : varOverridePairs) {
                ArrayList pair = new ArrayList();
                iVariable.asStream().forEach(p -> pair.add(p.asString()));
                overrideTable.add(pair);
            }
            for (List list : overrideTable) {
                String text = (String)list.get(0);
                String code = (String)list.get(1);
                this.infoBlurb = this.infoBlurb.replaceAll(String.format("\\b%s\\b", text), TextHelper.localize("guide.patchouli.bloodmagic.ritual_info.text_override_formatter", code, text));
            }
        }
        if (variables.has("heading_override")) {
            this.heading = variables.get("heading_override").asString();
        }
        if (variables.has("item_override")) {
            this.item = (ItemStack)variables.get("item_override").as(ItemStack.class);
        }
        if (variables.has("text")) {
            this.extraText = variables.get("text").asString();
        }
    }

    public IVariable process(Level level, String key) {
        if (this.ritual == null) {
            return null;
        }
        switch (key) {
            case "auto_text": {
                StringBuilder outputText = new StringBuilder();
                if (this.pageType.equals("info")) {
                    outputText.append(this.infoPageSetup());
                } else {
                    outputText.append(this.infoBlurb);
                }
                outputText.append(TextHelper.localize("guide.patchouli.bloodmagic.common.double_new_line", this.extraText));
                return IVariable.wrap((String)outputText.toString());
            }
            case "heading": {
                return IVariable.wrap((String)this.heading);
            }
            case "item": {
                return IVariable.from((Object)this.item);
            }
        }
        return null;
    }

    private String GetAndRemoveLeadTitle() {
        if (this.infoBlurb.charAt(0) == '(') {
            String leadTitle = this.infoBlurb.substring(1, this.infoBlurb.indexOf(")"));
            this.infoBlurb = this.infoBlurb.replaceFirst("^\\(" + leadTitle + "\\) ", "");
            return leadTitle;
        }
        return "";
    }

    private String infoPageSetup() {
        StringBuilder runeCounts = new StringBuilder();
        Tuple<Integer, Map<EnumRuneType, Integer>> runeCounter = RitualHelper.countRunes(this.ritual);
        Map runeMap = (Map)runeCounter.m_14419_();
        for (EnumRuneType type : EnumRuneType.values()) {
            int count = runeMap.getOrDefault((Object)type, 0);
            if (count <= 0) continue;
            runeCounts.append(TextHelper.localize("guide.patchouli.bloodmagic.ritual_info.counter_formatter", type.patchouliColor, TextHelper.localize("tooltip.bloodmagic.diviner." + type.translationKey, count)));
        }
        int totalRunes = (Integer)runeCounter.m_14418_();
        String totalRuneCount = TextHelper.localize("tooltip.bloodmagic.diviner.totalRune", totalRunes);
        String crystalLevel = switch (this.ritual.getCrystalLevel()) {
            case 0 -> TextHelper.localize("guide.patchouli.bloodmagic.ritual_info.weak_activation_crystal_link", TextHelper.localize("item.bloodmagic.activationcrystalweak", new Object[0]));
            case 1 -> TextHelper.localize("guide.patchouli.bloodmagic.ritual_info.awakened_activation_crystal_link", TextHelper.localize("item.bloodmagic.activationcrystalawakened", new Object[0]));
            default -> TextHelper.localize("item.bloodmagic.activationcrystalcreative", new Object[0]);
        };
        String activationCost = TextHelper.localize("guide.patchouli.bloodmagic.ritual_info.activation_cost", this.ritual.getActivationCost());
        String upkeepCost = "";
        if (this.ritual.getRefreshCost() != 0) {
            upkeepCost = TextHelper.localize("guide.patchouli.bloodmagic.ritual_info.upkeep_cost", this.ritual.getRefreshCost(), this.ritual.getRefreshTime());
        }
        return TextHelper.localize("guide.patchouli.bloodmagic.ritual_info.info_formatter", this.infoBlurb, runeCounts.toString(), totalRuneCount, crystalLevel, activationCost, upkeepCost);
    }
}

