/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.routing;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.client.button.FilterButtonTogglePress;
import wayoftime.bloodmagic.common.container.item.ContainerFilter;
import wayoftime.bloodmagic.common.item.inventory.InventoryFilter;
import wayoftime.bloodmagic.common.item.routing.BasicFilterKey;
import wayoftime.bloodmagic.common.item.routing.IFilterKey;
import wayoftime.bloodmagic.common.item.routing.IItemFilterProvider;
import wayoftime.bloodmagic.common.routing.BasicItemFilter;
import wayoftime.bloodmagic.common.routing.BlacklistItemFilter;
import wayoftime.bloodmagic.common.routing.IItemFilter;
import wayoftime.bloodmagic.util.GhostItemHelper;
import wayoftime.bloodmagic.util.Utils;

public class ItemRouterFilter
extends Item
implements MenuProvider,
IItemFilterProvider {
    public static final int inventorySize = 9;
    public static final int maxUpgrades = 9;
    public static final String FILTER_INV = "filterInventory";

    public ItemRouterFilter() {
        super(new Item.Properties().m_41487_(16));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_) {
            Utils.setUUID(stack);
            if (player instanceof ServerPlayer) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, buf -> buf.writeItemStack(stack, false));
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public AbstractContainerMenu m_7208_(int p_createMenu_1_, Inventory p_createMenu_2_, Player player) {
        assert (player.m_20193_() != null);
        return new ContainerFilter(p_createMenu_1_, player, p_createMenu_2_, player.m_21205_());
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Filter");
    }

    @Override
    public ItemStack getContainedStackForItem(ItemStack filterStack, ItemStack keyStack) {
        ItemStack copyStack = keyStack.m_41777_();
        GhostItemHelper.setItemGhostAmount(copyStack, 0);
        copyStack.m_41764_(1);
        return copyStack;
    }

    protected IItemFilter getFilterTypeFromConfig(ItemStack filterStack) {
        int state = this.getCurrentButtonState(filterStack, "blackwhitelist", 0);
        if (state == 1) {
            return new BlacklistItemFilter();
        }
        return new BasicItemFilter();
    }

    @Override
    public IFilterKey getFilterKey(ItemStack filterStack, int slot, ItemStack ghostStack, int amount) {
        return new BasicFilterKey(ghostStack, amount);
    }

    @Override
    public IItemFilter getInputItemFilter(ItemStack filterStack, BlockEntity tile, IItemHandler handler) {
        IItemFilter testFilter = this.getFilterTypeFromConfig(filterStack);
        ArrayList<IFilterKey> filteredList = new ArrayList<IFilterKey>();
        InventoryFilter inv = new InventoryFilter(filterStack);
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            int amount = GhostItemHelper.getItemGhostAmount(stack);
            ItemStack ghostStack = GhostItemHelper.getSingleStackFromGhost(stack);
            IFilterKey key = this.getFilterKey(filterStack, i, ghostStack, amount);
            filteredList.add(key);
        }
        testFilter.initializeFilter(filteredList, tile, handler, false);
        return testFilter;
    }

    @Override
    public IItemFilter getOutputItemFilter(ItemStack filterStack, BlockEntity tile, IItemHandler handler) {
        IItemFilter testFilter = this.getFilterTypeFromConfig(filterStack);
        ArrayList<IFilterKey> filteredList = new ArrayList<IFilterKey>();
        InventoryFilter inv = new InventoryFilter(filterStack);
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            int amount = GhostItemHelper.getItemGhostAmount(stack);
            ItemStack ghostStack = GhostItemHelper.getSingleStackFromGhost(stack);
            if (amount == 0) {
                amount = Integer.MAX_VALUE;
            }
            IFilterKey key = this.getFilterKey(filterStack, i, ghostStack, amount);
            filteredList.add(key);
        }
        testFilter.initializeFilter(filteredList, tile, handler, true);
        return testFilter;
    }

    @Override
    public void setGhostItemAmount(ItemStack filterStack, int ghostItemSlot, int amount) {
        InventoryFilter inv = new InventoryFilter(filterStack);
        ItemStack stack = inv.m_8020_(ghostItemSlot);
        if (!stack.m_41619_()) {
            GhostItemHelper.setItemGhostAmount(stack, amount);
            inv.writeToStack(filterStack);
        }
    }

    @Override
    public int receiveButtonPress(ItemStack filterStack, String buttonKey, int ghostItemSlot, int currentButtonState) {
        CompoundTag tag = filterStack.m_41783_();
        if (tag == null) {
            filterStack.m_41751_(new CompoundTag());
            tag = filterStack.m_41783_();
        }
        if (buttonKey.equals("blackwhitelist")) {
            int nextState = 0;
            switch (currentButtonState) {
                case 0: {
                    nextState = 1;
                    break;
                }
                default: {
                    nextState = 0;
                }
            }
            tag.m_128405_("button:blackwhitelist", nextState);
            return nextState;
        }
        return -1;
    }

    @Override
    public int getCurrentButtonState(ItemStack filterStack, String buttonKey, int ghostItemSlot) {
        CompoundTag tag = filterStack.m_41783_();
        if (tag != null && buttonKey.equals("blackwhitelist")) {
            int state = tag.m_128451_("button:blackwhitelist");
            return state;
        }
        return -1;
    }

    @Override
    public List<Component> getTextForHoverItem(ItemStack filterStack, String buttonKey, int ghostItemSlot) {
        ArrayList<Component> componentList = new ArrayList<Component>();
        int currentState = this.getCurrentButtonState(filterStack, buttonKey, ghostItemSlot);
        if (buttonKey.equals("blackwhitelist")) {
            switch (currentState) {
                case 1: {
                    componentList.add((Component)Component.m_237115_((String)"filter.bloodmagic.blacklist"));
                    break;
                }
                default: {
                    componentList.add((Component)Component.m_237115_((String)"filter.bloodmagic.whitelist"));
                }
            }
        }
        return componentList;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Pair<String, Button.OnPress>> getButtonAction(ContainerFilter container) {
        ArrayList<Pair<String, Button.OnPress>> buttonList = new ArrayList<Pair<String, Button.OnPress>>();
        buttonList.add(Pair.of((Object)"blackwhitelist", (Object)new FilterButtonTogglePress("blackwhitelist", container)));
        return buttonList;
    }

    @Override
    public Pair<Integer, Integer> getTexturePositionForState(ItemStack filterStack, String buttonKey, int currentButtonState) {
        if (buttonKey.equals("blackwhitelist")) {
            switch (currentButtonState) {
                case 1: {
                    return Pair.of((Object)176, (Object)20);
                }
            }
            return Pair.of((Object)176, (Object)0);
        }
        return Pair.of((Object)0, (Object)0);
    }

    @Override
    public boolean isButtonGlobal(ItemStack filterStack, String buttonKey) {
        return buttonKey.equals("blackwhitelist");
    }

    @Override
    public IItemFilter getUninitializedItemFilter(ItemStack filterStack) {
        IItemFilter testFilter = this.getFilterTypeFromConfig(filterStack);
        ArrayList<IFilterKey> filteredList = new ArrayList<IFilterKey>();
        InventoryFilter inv = new InventoryFilter(filterStack);
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            int amount = GhostItemHelper.getItemGhostAmount(stack);
            ItemStack ghostStack = GhostItemHelper.getSingleStackFromGhost(stack);
            IFilterKey key = this.getFilterKey(filterStack, i, ghostStack, amount);
            filteredList.add(key);
        }
        testFilter.initializeFilter(filteredList);
        return testFilter;
    }
}

