/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.screens;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import wayoftime.bloodmagic.client.screens.ScreenBase;
import wayoftime.bloodmagic.common.container.tile.ContainerAlchemyTable;
import wayoftime.bloodmagic.common.tile.TileAlchemyTable;
import wayoftime.bloodmagic.network.AlchemyTableButtonPacket;
import wayoftime.bloodmagic.network.BloodMagicPacketHandler;

public class ScreenAlchemyTable
extends ScreenBase<ContainerAlchemyTable> {
    private static final ResourceLocation background = new ResourceLocation("bloodmagic", "textures/gui/alchemytable.png");
    private static final List<Component> orbError = new ArrayList<Component>();
    private static final List<Component> lpError = new ArrayList<Component>();
    public TileAlchemyTable tileTable;
    private int left;
    private int top;

    public ScreenAlchemyTable(ContainerAlchemyTable container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        this.tileTable = container.tileTable;
        this.f_97726_ = 176;
        this.f_97727_ = 205;
        orbError.clear();
        orbError.add((Component)Component.m_237115_((String)"tooltip.bloodmagic.alchemytable.orberror.title").m_130940_(ChatFormatting.RED));
        orbError.add((Component)Component.m_237115_((String)"tooltip.bloodmagic.alchemytable.orberror.text").m_130940_(ChatFormatting.GRAY));
        lpError.clear();
        lpError.add((Component)Component.m_237115_((String)"tooltip.bloodmagic.alchemytable.lperror.title").m_130940_(ChatFormatting.RED));
        lpError.add((Component)Component.m_237115_((String)"tooltip.bloodmagic.alchemytable.lperror.text").m_130940_(ChatFormatting.GRAY));
    }

    @Override
    public ResourceLocation getBackground() {
        return background;
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"tile.bloodmagic.alchemytable.name"), 8, 5, 0x404040, false);
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"container.inventory"), 8, 111, 0x404040, false);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.left = (this.f_96543_ - this.f_97726_) / 2;
        this.top = (this.f_96544_ - this.f_97727_) / 2;
        this.m_169413_();
        this.m_142416_((GuiEventListener)new DirectionalButton(this.left + 135, this.top + 52, 14, 14, (Component)Component.m_237113_((String)"D"), new DirectionalPress(this.tileTable, Direction.DOWN)));
        this.m_142416_((GuiEventListener)new DirectionalButton(this.left + 153, this.top + 52, 14, 14, (Component)Component.m_237113_((String)"U"), new DirectionalPress(this.tileTable, Direction.UP)));
        this.m_142416_((GuiEventListener)new DirectionalButton(this.left + 135, this.top + 70, 14, 14, (Component)Component.m_237113_((String)"N"), new DirectionalPress(this.tileTable, Direction.NORTH)));
        this.m_142416_((GuiEventListener)new DirectionalButton(this.left + 153, this.top + 70, 14, 14, (Component)Component.m_237113_((String)"S"), new DirectionalPress(this.tileTable, Direction.SOUTH)));
        this.m_142416_((GuiEventListener)new DirectionalButton(this.left + 135, this.top + 88, 14, 14, (Component)Component.m_237113_((String)"W"), new DirectionalPress(this.tileTable, Direction.WEST)));
        this.m_142416_((GuiEventListener)new DirectionalButton(this.left + 153, this.top + 88, 14, 14, (Component)Component.m_237113_((String)"E"), new DirectionalPress(this.tileTable, Direction.EAST)));
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int slotId;
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(background, i, j, 0, 0, this.f_97726_, this.f_97727_);
        int l = this.getCookProgressScaled(90);
        guiGraphics.m_280218_(background, i + 106, j + 14 + 90 - l, 176, 90 - l, 18, l);
        if (this.getOrbFlag()) {
            guiGraphics.m_280218_(background, i + 106, j + 24, 194, 55, 18, 18);
            if (mouseX >= i + 106 && mouseX < i + 106 + 18 && mouseY >= j + 24 && mouseY < j + 24 + 18) {
                guiGraphics.m_280677_(this.f_96547_, orbError, Optional.empty(), mouseY, mouseY);
            }
        } else if (this.getLPFlag()) {
            guiGraphics.m_280218_(background, i + 106, j + 24, 194, 73, 18, 18);
            if (mouseX >= i + 106 && mouseX < i + 106 + 18 && mouseY >= j + 24 && mouseY < j + 24 + 18) {
                guiGraphics.m_280677_(this.f_96547_, lpError, Optional.empty(), mouseX, mouseY);
            }
        }
        if ((slotId = this.tileTable.activeSlot) != -1) {
            Slot slot = ((ContainerAlchemyTable)this.m_6262_()).m_38853_(slotId);
            if (slotId == 7) {
                guiGraphics.m_280218_(background, i + slot.f_40220_, j + slot.f_40221_, 195, 37, 16, 16);
            } else {
                guiGraphics.m_280218_(background, i + slot.f_40220_, j + slot.f_40221_, 195, 19, 16, 16);
            }
            for (int buttonId = 0; buttonId < 6; ++buttonId) {
                int xOffset = buttonId % 2 * 18 + 133;
                int yOffset = buttonId / 2 * 18 + 50;
                if (this.tileTable.isSlotEnabled(slotId, Direction.m_122376_((int)buttonId))) {
                    guiGraphics.m_280218_(background, i + xOffset, j + yOffset, 212, 18, 18, 18);
                    continue;
                }
                guiGraphics.m_280218_(background, i + xOffset, j + yOffset, 212, 0, 18, 18);
            }
        }
    }

    public int getCookProgressScaled(int scale) {
        double progress = this.tileTable.getProgressForGui();
        return (int)(progress * (double)scale);
    }

    public boolean getOrbFlag() {
        return this.tileTable.getOrbFlagForGui();
    }

    public boolean getLPFlag() {
        return this.tileTable.getLPFlagforGui();
    }

    public class DirectionalButton
    extends Button {
        private static final int BUTTON_TEX_X = 200;
        private static final int BUTTON_TEX_Y = 60;

        public DirectionalButton(int x, int y, int width, int height, Component title, Button.OnPress pressedAction) {
            super(x, y, width, height, title, pressedAction, f_252438_);
        }
    }

    public class DirectionalPress
    implements Button.OnPress {
        private final TileAlchemyTable table;
        private final Direction direction;

        public DirectionalPress(TileAlchemyTable table, Direction direction) {
            this.table = table;
            this.direction = direction;
        }

        public void m_93750_(Button button) {
            int activeSlot = this.table.activeSlot;
            if (activeSlot != -1) {
                boolean enabled = this.table.isSlotEnabled(activeSlot, this.direction);
                this.table.setSlotEnabled(!enabled, activeSlot, this.direction);
                BloodMagicPacketHandler.INSTANCE.sendToServer((Object)new AlchemyTableButtonPacket(this.table.m_58899_(), activeSlot, this.direction, !enabled));
            }
        }
    }
}

