/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.key;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Locale;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.client.ClientEvents;
import wayoftime.bloodmagic.client.key.IKeybindable;
import wayoftime.bloodmagic.common.item.sigil.ItemSigilHolding;
import wayoftime.bloodmagic.network.KeyProcessorPacket;
import wayoftime.bloodmagic.util.handler.event.ClientHandler;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum KeyBindings {
    OPEN_HOLDING((IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, -1){

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void handleKeybind() {
            ItemStack itemStack = ClientHandler.minecraft.f_91074_.m_21205_();
            if (itemStack.m_41720_() instanceof IKeybindable) {
                BloodMagic.packetHandler.sendToServer(new KeyProcessorPacket(this.ordinal(), false));
            }
        }
    }
    ,
    CYCLE_HOLDING_POS((IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.SHIFT, -1){

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void handleKeybind() {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player.m_21205_().m_41720_() instanceof ItemSigilHolding) {
                ClientEvents.cycleSigil(player.m_21205_(), (Player)player, -1);
            }
        }
    }
    ,
    CYCLE_HOLDING_NEG((IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.SHIFT, -1){

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void handleKeybind() {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player.m_21205_().m_41720_() instanceof ItemSigilHolding) {
                ClientEvents.cycleSigil(player.m_21205_(), (Player)player, 1);
            }
        }
    };

    private final IKeyConflictContext keyConflictContext;
    private final KeyModifier keyModifier;
    private final int keyCode;
    @OnlyIn(value=Dist.CLIENT)
    private KeyMapping key;

    private KeyBindings(IKeyConflictContext keyConflictContext, KeyModifier keyModifier, int keyCode) {
        this.keyConflictContext = keyConflictContext;
        this.keyModifier = keyModifier;
        this.keyCode = keyCode;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void handleKeybind();

    public IKeyConflictContext getKeyConflictContext() {
        return this.keyConflictContext;
    }

    public KeyModifier getKeyModifier() {
        return this.keyModifier;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    @OnlyIn(value=Dist.CLIENT)
    public KeyMapping getKey() {
        if (this.key == null) {
            this.key = this.toKeyMapping();
        }
        return this.key;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setKey(KeyMapping key) {
        this.key = key;
    }

    public String getDescription() {
        return "bloodmagic.keybind." + this.name().toLowerCase(Locale.ROOT);
    }

    public KeyMapping toKeyMapping() {
        return new KeyMapping(this.getDescription(), this.keyConflictContext, this.keyModifier, InputConstants.Type.KEYSYM, this.getKeyCode(), "key.bloodmagic.category");
    }
}

