/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.hud;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.Window;
import java.awt.Point;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import wayoftime.bloodmagic.client.hud.ElementRegistry;
import wayoftime.bloodmagic.client.hud.element.HUDElement;

public class GuiEditHUD
extends Screen {
    private static final int LINE_COLOR = 0x2D2D2D;
    private final Screen parent;
    private final Map<ResourceLocation, Vec2> currentOverrides = Maps.newHashMap();
    private HUDElement dragged;
    public boolean changes;

    public GuiEditHUD(Screen parent) {
        super((Component)Component.m_237113_((String)"Testing GuiEditHUD"));
        this.parent = parent;
    }

    public void m_7856_() {
        super.m_7856_();
        Button btn = Button.m_253074_((Component)Component.m_237115_((String)"gui.bloodmagic.toggle"), b -> Minecraft.m_91087_().m_91152_(this.parent)).m_252794_(this.f_96543_ / 2 - 155, this.f_96544_ - 30).m_253046_(70, 20).m_253136_();
        btn.f_93623_ = false;
        this.m_142416_((GuiEventListener)btn);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.bloodmagic.default"), b -> {
            this.currentOverrides.clear();
            ElementRegistry.resetPos();
            this.changes = false;
        }).m_252794_(this.f_96543_ / 2 - 75, this.f_96544_ - 30).m_253046_(70, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.bloodmagic.save"), b -> {
            ElementRegistry.save(this.currentOverrides);
            Minecraft.m_91087_().m_91152_(this.parent);
        }).m_252794_(this.f_96543_ / 2 + 5, this.f_96544_ - 30).m_253046_(70, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.bloodmagic.cancel"), b -> {
            this.currentOverrides.clear();
            Minecraft.m_91087_().m_91152_(this.parent);
        }).m_252794_(this.f_96543_ / 2 + 90, this.f_96544_ - 30).m_253046_(70, 20).m_253136_());
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        Window window = Minecraft.m_91087_().m_91268_();
        for (HUDElement element : ElementRegistry.getElements()) {
            if (this.dragged == element) continue;
            ResourceLocation key = ElementRegistry.getKey(element);
            Vec2 position = this.currentOverrides.getOrDefault(key, ElementRegistry.getPosition(key));
            int xPos = (int)((float)window.m_85445_() * position.f_82470_);
            int yPos = (int)((float)window.m_85446_() * position.f_82471_);
            this.drawWithBox(guiGraphics, element, partialTicks, xPos, yPos);
        }
        if (this.dragged != null) {
            Point bounded = this.getBoundedDrag(window, mouseX, mouseY);
            this.drawWithBox(guiGraphics, this.dragged, partialTicks, bounded.x, bounded.y);
        }
    }

    public boolean m_7043_() {
        return true;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        HUDElement element;
        if (this.dragged == null && (element = this.getHoveredElement(mouseX, mouseY)) != null && button == 0) {
            this.dragged = element;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int state) {
        if (this.dragged != null) {
            Window window = Minecraft.m_91087_().m_91268_();
            Point bounded = this.getBoundedDrag(window, mouseX, mouseY);
            float xPos = (float)bounded.x / (float)window.m_85445_();
            float yPos = (float)bounded.y / (float)window.m_85446_();
            this.currentOverrides.put(ElementRegistry.getKey(this.dragged), new Vec2(xPos, yPos));
            this.changes = true;
            this.dragged = null;
        }
        return super.m_6348_(mouseX, mouseY, state);
    }

    @Nullable
    public HUDElement getHoveredElement(double mouseX, double mouseY) {
        Window window = Minecraft.m_91087_().m_91268_();
        for (HUDElement element : ElementRegistry.getElements()) {
            ResourceLocation key = ElementRegistry.getKey(element);
            Vec2 position = this.currentOverrides.getOrDefault(key, ElementRegistry.getPosition(key));
            int xPos = (int)((float)window.m_85445_() * position.f_82470_);
            int yPos = (int)((float)window.m_85446_() * position.f_82471_);
            if (mouseX < (double)xPos || mouseX > (double)(xPos + element.getWidth()) || mouseY < (double)yPos || mouseY > (double)(yPos + element.getHeight())) continue;
            return element;
        }
        return null;
    }

    protected Point getBoundedDrag(Window window, double mouseX, double mouseY) {
        int drawY;
        int drawX = (int)(mouseX - (double)(this.dragged.getWidth() / 2));
        if (drawX + this.dragged.getWidth() >= window.m_85445_()) {
            drawX = window.m_85445_() - this.dragged.getWidth();
        }
        if (drawX < 0) {
            drawX = 0;
        }
        if ((drawY = (int)(mouseY - (double)(this.dragged.getHeight() / 2))) + this.dragged.getHeight() >= window.m_85446_()) {
            drawY = window.m_85446_() - this.dragged.getHeight();
        }
        if (drawY < 0) {
            drawY = 0;
        }
        return new Point(drawX, drawY);
    }

    protected void drawWithBox(GuiGraphics guiGraphics, HUDElement element, float partialTicks, int drawX, int drawY) {
        int color = ElementRegistry.getColor(ElementRegistry.getKey(element));
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280315_(drawX, drawY, drawY + element.getHeight() - 1, color);
        guiGraphics.m_280315_(drawX + element.getWidth() - 1, drawY, drawY + element.getHeight() - 1, color);
        guiGraphics.m_280656_(drawX, drawX + element.getWidth() - 1, drawY, color);
        guiGraphics.m_280656_(drawX, drawX + element.getWidth() - 1, drawY + element.getHeight() - 1, color);
        guiGraphics.m_280168_().m_85849_();
        element.draw(guiGraphics, partialTicks, drawX, drawY);
    }
}

