/*
 * Decompiled with CFR 0.152.
 */
package org.crimsoncrips.bellraidconfig.mixins;

import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.block.entity.BellBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.crimsoncrips.bellraidconfig.BRCConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BellBlockEntity.class})
public class BRCBellBlock
extends BlockEntity {
    @Shadow
    private long f_58816_;
    @Shadow
    private List<LivingEntity> f_58817_;

    public BRCBellBlock(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    @Inject(method={"isRaiderWithinRange"}, at={@At(value="HEAD")}, cancellable=true)
    private static void injected(BlockPos pPos, LivingEntity pRaider, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)BRCBellBlock.raiderIsWithinRange(pPos, pRaider));
    }

    @Unique
    private static boolean raiderIsWithinRange(BlockPos pos, LivingEntity raider) {
        return raider.m_6084_() && !raider.m_213877_() && pos.m_203195_((Position)raider.m_20182_(), (double)BRCConfig.giveRange) && raider.m_6095_().m_204039_(EntityTypeTags.f_13121_);
    }

    @Inject(method={"updateEntities"}, at={@At(value="HEAD")}, cancellable=true)
    private void updateEntities(CallbackInfo ci) {
        ci.cancel();
        BlockPos $$0 = this.m_58899_();
        if (this.f_58857_.m_46467_() > this.f_58816_ + 60L || this.f_58817_ == null) {
            this.f_58816_ = this.f_58857_.m_46467_();
            AABB $$1 = new AABB($$0).m_82400_((double)BRCConfig.giveRange);
            this.f_58817_ = this.f_58857_.m_45976_(LivingEntity.class, $$1);
        }
        if (!this.f_58857_.f_46443_) {
            for (LivingEntity $$2 : this.f_58817_) {
                if (!$$2.m_6084_() || $$2.m_213877_() || !$$0.m_203195_((Position)$$2.m_20182_(), (double)BRCConfig.detectionRange)) continue;
                $$2.m_6274_().m_21879_(MemoryModuleType.f_26325_, (Object)this.f_58857_.m_46467_());
            }
        }
    }

    @Inject(method={"areRaidersNearby"}, at={@At(value="HEAD")}, cancellable=true)
    private static void areRaidersNearby(BlockPos pPos, List<LivingEntity> pRaiders, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)BRCBellBlock.raidersAreNearby(pRaiders, pPos));
    }

    @Unique
    private static boolean raidersAreNearby(List<LivingEntity> pRaiders, BlockPos pPos) {
        LivingEntity $$2;
        Iterator<LivingEntity> var2 = pRaiders.iterator();
        do {
            if (var2.hasNext()) continue;
            return false;
        } while (!($$2 = var2.next()).m_6084_() || $$2.m_213877_() || !pPos.m_203195_((Position)$$2.m_20182_(), (double)BRCConfig.detectionRange) || !$$2.m_6095_().m_204039_(EntityTypeTags.f_13121_));
        return true;
    }
}

