/*
 * Decompiled with CFR 0.152.
 */
package com.nekotune.battlemusic;

import com.nekotune.battlemusic.BattleMusic;
import com.nekotune.battlemusic.ModConfigs;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BattleMusicInstance
extends AbstractTickableSoundInstance {
    public Mob entity;
    public SoundEvent soundEvent;
    public int priority;
    public float fadeLength;
    public boolean fadeOut = false;

    public BattleMusicInstance(BattleMusic.EntitySoundData soundData, Mob entity) {
        super(soundData.soundEvent, SoundSource.MASTER, SoundInstance.m_235150_());
        this.f_119573_ = ((Double)ModConfigs.FADE_TIME.get()).floatValue() == 0.0f ? BattleMusic.getVolume() : 0.0f;
        this.f_119578_ = true;
        this.f_119582_ = true;
        this.soundEvent = soundData.soundEvent;
        this.priority = soundData.priority;
        this.entity = entity;
        this.fadeLength = ((Double)ModConfigs.FADE_TIME.get()).floatValue();
    }

    public boolean m_7784_() {
        return true;
    }

    public void setVolume(float volume) {
        this.f_119573_ = volume;
    }

    public void setPitch(float pitch) {
        this.f_119574_ = pitch;
    }

    public void destroy() {
        this.m_119609_();
        Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)this);
        this.fadeLength = 0.0f;
        if (BattleMusic.playing == this) {
            BattleMusic.playing = null;
        }
    }

    public void fade(float seconds) {
        this.fadeOut = true;
        if (seconds == 0.0f) {
            this.destroy();
        } else {
            this.fadeLength = seconds;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_7788_() {
        boolean belowHpThreshold;
        LocalPlayer player;
        block17: {
            block16: {
                if (this.m_7801_()) {
                    return;
                }
                Minecraft.m_91087_().m_91106_().m_120386_(null, SoundSource.MUSIC);
                if (!(this.fadeLength > 0.0f)) break block16;
                if (!this.fadeOut) {
                    this.f_119573_ += BattleMusic.getVolume() / (this.fadeLength * 20.0f);
                    if (this.f_119573_ >= BattleMusic.getVolume()) {
                        this.f_119573_ = BattleMusic.getVolume();
                        this.fadeLength = 0.0f;
                    }
                    break block17;
                } else {
                    if (BattleMusic.validEntities.contains(this.entity)) {
                        this.fadeOut = false;
                        return;
                    }
                    this.f_119573_ -= BattleMusic.getVolume() / (this.fadeLength * 20.0f);
                    if (!(this.f_119573_ <= 0.0f)) return;
                    this.destroy();
                    return;
                }
            }
            if (!BattleMusic.validEntities.contains(this.entity)) {
                this.fade(Math.max(((Double)ModConfigs.FADE_TIME.get()).floatValue(), 2.0f));
            } else {
                this.f_119573_ = BattleMusic.getVolume();
            }
        }
        if ((player = Minecraft.m_91087_().f_91074_) == null) {
            return;
        }
        float pitch = 1.0f;
        if (((Boolean)ModConfigs.HEALTH_PITCH_PERCENT.get()).booleanValue()) {
            belowHpThreshold = player.m_21223_() / player.m_21233_() * 100.0f <= (float)((Integer)ModConfigs.HEALTH_PITCH_THRESH.get()).intValue();
        } else {
            boolean bl = belowHpThreshold = player.m_21223_() <= (float)((Integer)ModConfigs.HEALTH_PITCH_THRESH.get()).intValue();
        }
        if (belowHpThreshold && !(this.entity instanceof Warden)) {
            pitch = (float)((double)pitch + (Double)ModConfigs.HEALTH_PITCH_AMOUNT.get());
        }
        if ((Double)ModConfigs.PHASE2_PITCH_AMOUNT.get() != 0.0) {
            if (this.entity instanceof EnderDragon) {
                List list = this.entity.m_9236_().m_45976_(EndCrystal.class, AABB.m_165882_((Vec3)new Vec3(0.0, 64.0, 0.0), (double)128.0, (double)128.0, (double)128.0));
                if (list.isEmpty()) {
                    pitch = (float)((double)pitch + (Double)ModConfigs.PHASE2_PITCH_AMOUNT.get());
                }
            } else if (this.entity instanceof WitherBoss && ((WitherBoss)this.entity).m_7090_()) {
                pitch = (float)((double)pitch + (Double)ModConfigs.PHASE2_PITCH_AMOUNT.get());
            }
        }
        this.f_119574_ = pitch;
    }
}

