/*
 * Decompiled with CFR 0.152.
 */
package com.nekotune.battlemusic;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.nekotune.battlemusic.BattleMusicInstance;
import com.nekotune.battlemusic.ModCommands;
import com.nekotune.battlemusic.ModConfigs;
import com.nekotune.battlemusic.ModSounds;
import com.nekotune.battlemusic.compat.AetherCompat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

@Mod(value="battlemusic")
public class BattleMusic {
    public static final String MOD_ID = "battlemusic";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final float VOLUME_REDUCTION = 2.0f;
    public static final double MAX_SONG_RANGE = 256.0;
    public static BattleMusicInstance playing = null;
    private static float volume = 1.0f;
    public static ArrayList<Mob> validEntities = new ArrayList();
    protected static final HashMap<EntityType<?>, EntitySoundData> ENTITY_SOUND_DATA = new HashMap();

    public BattleMusic() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModSounds.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ModConfigs.SPEC, "battlemusic-client.toml");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        BattleMusic.updateEntitySoundData();
        BattleMusic.setVolume(((Double)ModConfigs.VOLUME.get()).floatValue());
    }

    public static void updateEntitySoundData() {
        ENTITY_SOUND_DATA.clear();
        List entityDataStrings = (List)ModConfigs.ENTITIES_SONGS.get();
        String ERROR_MSG = "Error loading entity music data from battlemusic config: ";
        for (String entityDataString : entityDataStrings) {
            EntityType entityType = null;
            SoundEvent soundEvent = null;
            String entityString = entityDataString.substring(0, entityDataString.indexOf(59));
            DataResult weakEntityResource = ResourceLocation.m_135837_((String)entityString);
            if (weakEntityResource.get().left().isPresent()) {
                ResourceLocation resource = (ResourceLocation)weakEntityResource.get().left().get();
                entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(resource);
            }
            if (entityType == null || entityType == EntityType.f_20510_) {
                LOGGER.warn("Error loading entity music data from battlemusic config: Skipping invalid entity ID \"{}\" (You can ignore this warning)", (Object)entityString);
                continue;
            }
            String soundString = entityDataString.substring(entityDataString.indexOf(59) + 1, entityDataString.lastIndexOf(59));
            DataResult weakSoundResource = ResourceLocation.m_135837_((String)soundString);
            if (weakSoundResource.get().left().isPresent()) {
                ResourceLocation resource = (ResourceLocation)weakSoundResource.get().left().get();
                soundEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(resource);
            }
            if (soundEvent == null) {
                LOGGER.error("Error loading entity music data from battlemusic config: Invalid sound ID \"{}\" in line \"{}\", skipping", (Object)soundString, (Object)entityDataString);
                continue;
            }
            int priority = 0;
            String priorityString = entityDataString.substring(entityDataString.lastIndexOf(59) + 1, entityDataString.lastIndexOf(59) + 2);
            try {
                priority = Integer.parseInt(priorityString);
            }
            catch (Exception e) {
                LOGGER.error("Error loading entity music data from battlemusic config: Invalid priority \"{}\" in line \"{}\", defaulting to 0", (Object)priorityString, (Object)entityDataString);
            }
            LOGGER.debug("Added battle music {} to {} with priority {}", new Object[]{soundEvent.m_11660_(), entityType, priority});
            ENTITY_SOUND_DATA.put(entityType, new EntitySoundData(soundEvent, priority));
        }
        String defaultSongString = (String)ModConfigs.DEFAULT_SONG.get();
        if (!defaultSongString.isEmpty()) {
            SoundEvent defaultSong = null;
            DataResult weakDefaultSongResource = ResourceLocation.m_135837_((String)defaultSongString);
            if (weakDefaultSongResource.get().left().isPresent()) {
                ResourceLocation resource = (ResourceLocation)weakDefaultSongResource.get().left().get();
                defaultSong = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(resource);
            }
            if (defaultSong == null) {
                LOGGER.error("Error loading entity music data from battlemusic config: Invalid default song sound ID \"{}\"", (Object)defaultSongString);
            } else {
                for (EntityType e : ForgeRegistries.ENTITY_TYPES.getValues()) {
                    ENTITY_SOUND_DATA.putIfAbsent(e, new EntitySoundData(defaultSong, Integer.MIN_VALUE));
                }
            }
        }
        if (playing != null) {
            playing.destroy();
        }
        LOGGER.debug("[BATTLE MUSIC] Updated entity sound data");
    }

    public static HashMap<EntityType<?>, EntitySoundData> getEntitySoundData() {
        HashMap clone = new HashMap();
        for (EntityType<?> key : ENTITY_SOUND_DATA.keySet()) {
            clone.put(key, ENTITY_SOUND_DATA.get(key));
        }
        return clone;
    }

    public static void setVolume(float newVolume) {
        newVolume /= 2.0f;
        if (((Boolean)ModConfigs.LINKED_TO_MUSIC.get()).booleanValue()) {
            newVolume *= Minecraft.m_91087_().f_91066_.m_92147_(SoundSource.MUSIC);
        }
        if (playing != null) {
            playing.setVolume(playing.m_7769_() * (newVolume / volume));
            volume = newVolume;
            if (playing.m_7769_() > volume) {
                playing.setVolume(volume);
            }
        } else {
            volume = newVolume;
        }
    }

    public static float getVolume() {
        return volume;
    }

    public static boolean validEntity(Mob mob, boolean toStart) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || player.m_21224_()) {
            return false;
        }
        if (mob == null || mob.m_21224_()) {
            return false;
        }
        if (ModList.get().isLoaded("nitrogen_internals") && AetherCompat.isBoss(mob) && !AetherCompat.isActiveBoss(mob)) {
            return false;
        }
        if (!(ENTITY_SOUND_DATA.get(mob.m_6095_()) == null || !mob.m_9236_().m_6042_().equals((Object)player.m_9236_().m_6042_()) || mob.m_5803_() || mob.m_21525_() || mob.m_7307_((Entity)player.self()) || mob instanceof NeutralMob && !mob.m_5912_())) {
            double followRange;
            AttributeInstance frAttribute = mob.m_21051_(Attributes.f_22277_);
            double d = followRange = frAttribute != null ? frAttribute.m_22135_() : 256.0;
            if (mob instanceof EnderDragon) {
                followRange = 300.0;
            }
            if (!(!toStart || player.m_142582_((Entity)mob) && mob.m_142582_((Entity)player))) {
                return false;
            }
            return mob.m_21040_((LivingEntity)player, TargetingConditions.m_148352_().m_26883_(followRange).m_148355_().m_26893_());
        }
        return false;
    }

    public static void reload() {
        BattleMusic.updateEntitySoundData();
        validEntities.clear();
    }

    public static class EntitySoundData {
        public SoundEvent soundEvent;
        public int priority;

        public EntitySoundData(SoundEvent soundEvent, int priority) {
            this.soundEvent = soundEvent;
            this.priority = priority;
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="battlemusic")
    public static abstract class ForgeEvents {
        @SubscribeEvent
        public static void onCommandRegister(RegisterCommandsEvent event) {
            ModCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (playing != null) {
                playing.destroy();
            }
            validEntities.clear();
        }

        @SubscribeEvent
        public static void onLivingTick(LivingEvent.LivingTickEvent event) {
            LivingEntity entity = event.getEntity();
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null || entity.m_9236_() != player.m_9236_()) {
                return;
            }
            if (entity instanceof Mob && BattleMusic.validEntity((Mob)entity, true) && !validEntities.contains(entity)) {
                validEntities.add((Mob)entity);
            }
        }

        @SubscribeEvent
        public static void onLevelTick(TickEvent.LevelTickEvent event) {
            if (event.phase == TickEvent.Phase.START || event.side != LogicalSide.CLIENT) {
                return;
            }
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            EntitySoundData f_soundData = null;
            Mob f_entity = null;
            for (int i = 0; i < validEntities.size(); ++i) {
                Mob entity = validEntities.get(i);
                if (!BattleMusic.validEntity(entity, false)) {
                    validEntities.remove(entity);
                    --i;
                    continue;
                }
                EntitySoundData soundData = BattleMusic.getEntitySoundData().get(entity.m_6095_());
                if (playing != null) {
                    if (BattleMusic.playing.priority >= soundData.priority) continue;
                    if (BattleMusic.playing.soundEvent.m_11660_().equals((Object)soundData.soundEvent.m_11660_())) {
                        BattleMusic.playing.priority = soundData.priority;
                        BattleMusic.playing.entity = entity;
                        continue;
                    }
                }
                if (f_soundData != null) {
                    if (f_soundData.priority >= soundData.priority) continue;
                    if (f_soundData.soundEvent.m_11660_().equals((Object)soundData.soundEvent.m_11660_())) {
                        f_soundData = soundData;
                        continue;
                    }
                }
                f_soundData = soundData;
                f_entity = entity;
            }
            SoundManager sounds = Minecraft.m_91087_().m_91106_();
            if (f_soundData != null && BattleMusic.validEntity(f_entity, true)) {
                if (playing != null) {
                    playing.destroy();
                }
                playing = new BattleMusicInstance(f_soundData, f_entity);
                sounds.m_120372_((TickableSoundInstance)playing);
            }
        }
    }
}

